/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.Named;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterArg
extends InsnArg
implements Named {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterArg.class);
    public static final String THIS_ARG_NAME = "this";
    protected final int regNum;
    private SSAVar sVar;

    public RegisterArg(int rn, ArgType type) {
        this.type = type;
        this.regNum = rn;
    }

    public int getRegNum() {
        return this.regNum;
    }

    @Override
    public boolean isRegister() {
        return true;
    }

    @Override
    public void setType(ArgType newType) {
        if (this.sVar == null) {
            throw new JadxRuntimeException("Can't change type for register without SSA variable: " + this);
        }
        if (this.contains(AFlag.IMMUTABLE_TYPE)) {
            if (!this.type.isTypeKnown()) {
                throw new JadxRuntimeException("Unknown immutable type '" + this.type + "' in " + this);
            }
            if (!this.type.equals(newType)) {
                LOG.warn("JADX WARNING: Can't change immutable type from '{}' to '{}' for {}", new Object[]{this.type, newType, this});
                return;
            }
        }
        this.sVar.setType(newType);
    }

    @Override
    public ArgType getType() {
        if (this.sVar != null) {
            return this.sVar.getTypeInfo().getType();
        }
        LOG.warn("Register type unknown, SSA variable not initialized: r{}", (Object)this.regNum);
        return this.type;
    }

    public ArgType getInitType() {
        return this.type;
    }

    @Override
    public boolean isTypeImmutable() {
        return this.contains(AFlag.IMMUTABLE_TYPE) || this.sVar != null && this.sVar.contains(AFlag.IMMUTABLE_TYPE);
    }

    public SSAVar getSVar() {
        return this.sVar;
    }

    void setSVar(@NotNull SSAVar sVar) {
        this.sVar = sVar;
        if (this.contains(AFlag.IMMUTABLE_TYPE)) {
            sVar.add(AFlag.IMMUTABLE_TYPE);
        }
    }

    @Override
    public String getName() {
        if (this.isThis()) {
            return THIS_ARG_NAME;
        }
        if (this.sVar == null) {
            return null;
        }
        return this.sVar.getName();
    }

    @Override
    public void setName(String name) {
        if (this.sVar != null && name != null) {
            this.sVar.setName(name);
        }
    }

    public boolean isNameEquals(InsnArg arg) {
        String n = this.getName();
        if (n == null || !(arg instanceof Named)) {
            return false;
        }
        return n.equals(((Named)((Object)arg)).getName());
    }

    @Override
    public RegisterArg duplicate() {
        return this.duplicate(this.getRegNum(), this.sVar);
    }

    public RegisterArg duplicate(int regNum, @Nullable SSAVar sVar) {
        RegisterArg dup = new RegisterArg(regNum, this.getInitType());
        if (sVar != null) {
            dup.setSVar(sVar);
        }
        dup.copyAttributesFrom(this);
        return dup;
    }

    @Nullable
    public InsnNode getAssignInsn() {
        if (this.sVar == null) {
            return null;
        }
        return this.sVar.getAssign().getParentInsn();
    }

    public boolean equalRegisterAndType(RegisterArg arg) {
        return this.regNum == arg.regNum && this.type.equals(arg.type);
    }

    public boolean sameRegAndSVar(InsnArg arg) {
        if (!arg.isRegister()) {
            return false;
        }
        RegisterArg reg = (RegisterArg)arg;
        return this.regNum == reg.getRegNum() && Objects.equals(this.sVar, reg.getSVar());
    }

    public boolean sameCodeVar(RegisterArg arg) {
        return this.getSVar().getCodeVar() == arg.getSVar().getCodeVar();
    }

    public int hashCode() {
        return this.regNum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RegisterArg)) {
            return false;
        }
        RegisterArg other = (RegisterArg)obj;
        return this.regNum == other.regNum && Objects.equals(this.sVar, other.getSVar());
    }

    public String toString() {
        ArgType type;
        StringBuilder sb = new StringBuilder();
        sb.append("(r");
        sb.append(this.regNum);
        if (this.sVar != null) {
            sb.append('v').append(this.sVar.getVersion());
        }
        if (this.getName() != null) {
            sb.append(" '").append(this.getName()).append('\'');
        }
        ArgType argType = type = this.sVar != null ? this.getType() : null;
        if (type != null) {
            sb.append(' ').append(type);
        }
        ArgType initType = this.getInitType();
        if (type == null || !type.equals(initType) && !type.isTypeKnown()) {
            sb.append(" I:").append(initType);
        }
        if (!this.isAttrStorageEmpty()) {
            sb.append(' ').append(this.getAttributesString());
        }
        sb.append(')');
        return sb.toString();
    }
}

