/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class FieldArg
extends RegisterArg {
    private final FieldInfo field;
    @Nullable
    private final InsnArg instArg;

    public FieldArg(FieldInfo field, @Nullable InsnArg reg) {
        super(-1, field.getType());
        this.instArg = reg;
        this.field = field;
    }

    public FieldInfo getField() {
        return this.field;
    }

    public InsnArg getInstanceArg() {
        return this.instArg;
    }

    public boolean isStatic() {
        return this.instArg == null;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public boolean isRegister() {
        return false;
    }

    @Override
    public ArgType getType() {
        return this.field.getType();
    }

    @Override
    public ArgType getInitType() {
        return this.field.getType();
    }

    @Override
    public void setType(ArgType newType) {
        throw new JadxRuntimeException("Can't set type for FieldArg");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldArg) || !super.equals(obj)) {
            return false;
        }
        FieldArg fieldArg = (FieldArg)obj;
        if (!this.field.equals(fieldArg.field)) {
            return false;
        }
        return Objects.equals(this.instArg, fieldArg.instArg);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + (this.instArg != null ? this.instArg.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "(" + this.field + ')';
    }
}

