/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import ch.qos.logback.classic.Level;
import jadx.gui.settings.JadxSettings;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.utils.NLS;
import jadx.gui.utils.logs.ILogListener;
import jadx.gui.utils.logs.LogCollector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

class LogViewer
extends JDialog {
    private static final long serialVersionUID = -2188700277429054641L;
    private static final Level[] LEVEL_ITEMS = new Level[]{Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR};
    private static Level level = Level.WARN;
    private final transient JadxSettings settings;
    private transient RSyntaxTextArea textPane;

    public LogViewer(MainWindow mainWindow) {
        this.settings = mainWindow.getSettings();
        this.initUI(mainWindow);
        this.registerLogListener();
        this.settings.loadWindowPos(this);
    }

    public final void initUI(MainWindow mainWindow) {
        this.textPane = CodeArea.getDefaultArea(mainWindow);
        this.textPane.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel controlPane = new JPanel();
        controlPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JComboBox<Level> cb = new JComboBox<Level>(LEVEL_ITEMS);
        cb.setSelectedItem(level);
        cb.addActionListener(e -> {
            int i = cb.getSelectedIndex();
            level = LEVEL_ITEMS[i];
            this.registerLogListener();
        });
        JLabel levelLabel = new JLabel(NLS.str("log_viewer.log_level", new Object[0]));
        levelLabel.setLabelFor(cb);
        controlPane.add(levelLabel);
        controlPane.add(cb);
        JScrollPane scrollPane = new JScrollPane((Component)this.textPane);
        JButton close = new JButton(NLS.str("tabs.close", new Object[0]));
        close.addActionListener(event -> this.close());
        close.setAlignmentX(0.5f);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)controlPane, "First");
        contentPane.add((Component)scrollPane, "Center");
        contentPane.add((Component)close, "Last");
        this.setTitle(NLS.str("log_viewer.title", new Object[0]));
        this.pack();
        this.setSize(800, 600);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.setLocationRelativeTo(null);
    }

    private void registerLogListener() {
        LogCollector logCollector = LogCollector.getInstance();
        logCollector.resetListener();
        this.textPane.setText("");
        logCollector.registerListener(new ILogListener(){

            @Override
            public Level getFilterLevel() {
                return level;
            }

            @Override
            public void onAppend(String logStr) {
                SwingUtilities.invokeLater(() -> LogViewer.this.textPane.append(logStr));
            }
        });
    }

    private void close() {
        this.dispose();
    }

    @Override
    public void dispose() {
        LogCollector.getInstance().resetListener();
        this.settings.saveWindowPos(this);
        super.dispose();
    }
}

