/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.VMStackWalker;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Package
implements AnnotatedElement {
    private final String name;
    private final String implTitle;
    private final String implVendor;
    private final String implVersion;
    private final String specTitle;
    private final String specVendor;
    private final String specVersion;
    private final URL sealed;
    private ClassLoader loader;

    Package(String name, String specTitle, String specVendor, String specVersion, String implTitle, String implVendor, String implVersion, URL sealed) {
        this(name, specTitle, specVendor, specVersion, implTitle, implVendor, implVersion, sealed, null);
    }

    Package(String name, String specTitle, String specVendor, String specVersion, String implTitle, String implVendor, String implVersion, URL sealed, ClassLoader loader) {
        if (name == null) {
            throw new IllegalArgumentException("null Package name");
        }
        this.name = name;
        this.implTitle = implTitle;
        this.implVendor = implVendor;
        this.implVersion = implVersion;
        this.specTitle = specTitle;
        this.specVendor = specVendor;
        this.specVersion = specVersion;
        this.sealed = sealed;
        this.loader = loader;
    }

    public String getName() {
        return this.name;
    }

    public String getSpecificationTitle() {
        return this.specTitle;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public String getSpecificationVendor() {
        return this.specVendor;
    }

    public String getImplementationTitle() {
        return this.implTitle;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public String getImplementationVendor() {
        return this.implVendor;
    }

    public boolean isSealed() {
        return this.sealed != null;
    }

    public boolean isSealed(URL url) {
        return url.equals(this.sealed);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCompatibleWith(String version) {
        StringTokenizer versionTokens = new StringTokenizer(version, ".");
        StringTokenizer specTokens = new StringTokenizer(this.specVersion, ".");
        try {
            int vers;
            int spec;
            do {
                if (!versionTokens.hasMoreElements()) {
                    return true;
                }
                vers = Integer.parseInt(versionTokens.nextToken());
                spec = Integer.parseInt(specTokens.nextToken());
                if (spec >= vers) continue;
                return false;
            } while (spec <= vers);
            return true;
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
    }

    public static Package getPackage(String name) {
        ClassLoader cl = VMStackWalker.getCallingClassLoader();
        return cl != null ? cl.getPackage(name) : VMClassLoader.getPackage(name);
    }

    public static Package[] getPackages() {
        ClassLoader cl = VMStackWalker.getCallingClassLoader();
        return cl != null ? cl.getPackages() : VMClassLoader.getPackages();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "package " + this.name + (this.specTitle == null ? "" : ", " + this.specTitle) + (this.specVersion == null ? "" : ", version " + this.specVersion);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        Annotation[] annotations;
        Annotation foundAnnotation = null;
        Annotation[] annotationArray = annotations = this.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType() == annotationClass) {
                foundAnnotation = annotation;
            }
            ++n2;
        }
        return (A)foundAnnotation;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        try {
            Class<?> pkgInfo = Class.forName(String.valueOf(this.name) + ".package-info", false, this.loader);
            return pkgInfo.getDeclaredAnnotations();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new Annotation[0];
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation((Class)annotationClass) != null;
    }
}

