/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.orbd;

import gnu.CORBA.NamingService.NamingMap;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.InvalidName;

public class PersistentMap
extends NamingMap {
    public final File file;
    ORB orb;
    boolean reset;

    public PersistentMap(ORB an_orb, File mapFile, boolean a_reset) {
        this.orb = an_orb;
        this.file = mapFile;
        this.reset = a_reset;
        if (this.file.exists() && !this.reset) {
            try {
                FileInputStream fin = new FileInputStream(this.file);
                BufferedReader in = new BufferedReader(new InputStreamReader(fin));
                Entry e = new Entry();
                while (e.read(in)) {
                    Object object = this.string_to_object(e.ior);
                    this.orb.connect(object);
                    this.map.put(e.getComponent(), object);
                }
            }
            catch (Exception ex) {
                InternalError ierr = new InternalError(this.file.getAbsolutePath());
                ierr.initCause(ex);
                throw ierr;
            }
        }
    }

    protected Object string_to_object(String description) {
        return this.orb.string_to_object(description);
    }

    protected String object_to_string(Object object) {
        return this.orb.object_to_string(object);
    }

    public void bind(NameComponent name, Object object) throws AlreadyBound, InvalidName {
        if (this.containsKey(name)) {
            throw new AlreadyBound(String.valueOf(name.id) + "." + name.kind);
        }
        super.bind(name, object);
        this.register(name, object);
    }

    public void rebind(NameComponent name, Object object) throws InvalidName {
        if (this.containsKey(name)) {
            String xior;
            Object existing = this.get(name);
            String ior = this.object_to_string(object);
            if (ior.equals(xior = this.object_to_string(existing))) {
                return;
            }
            this.remove(name);
        }
        Iterator iter = this.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry item = (Map.Entry)iter.next();
            if (!item.getValue().equals(object)) continue;
            iter.remove();
        }
        this.map.put(name, object);
        this.register(name, object);
    }

    public void remove(NameComponent name) {
        super.remove(name);
        this.unregister(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(NameComponent name, Object object) {
        String ior = this.object_to_string(object);
        File file = this.file;
        synchronized (file) {
            try {
                FileOutputStream fou = !this.file.exists() ? new FileOutputStream(this.file) : new FileOutputStream(this.file, true);
                Entry e = new Entry();
                e.id = name.id;
                e.kind = name.kind;
                e.ior = ior;
                e.write(fou);
                fou.close();
            }
            catch (Exception e) {
                InternalError ierr = new InternalError(this.file.getAbsolutePath());
                ierr.initCause(e);
                throw ierr;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(NameComponent name) {
        File file = this.file;
        synchronized (file) {
            try {
                File nf = new File(this.file.getParent(), String.valueOf(this.file.getName()) + "_t");
                FileInputStream fin = new FileInputStream(this.file);
                FileOutputStream fou = new FileOutputStream(nf);
                BufferedOutputStream ou = new BufferedOutputStream(fou);
                BufferedReader in = new BufferedReader(new InputStreamReader(fin));
                String nk = name.kind;
                if (nk == null) {
                    nk = "";
                }
                Entry e = new Entry();
                while (e.read(in)) {
                    if (e.id.equals(name.id) && e.kind.equals(nk)) continue;
                    e.write(ou);
                }
                File deleteIt = new File(this.file.getParent(), String.valueOf(this.file.getName()) + "_d");
                if (deleteIt.exists()) {
                    deleteIt.delete();
                }
                if (!this.file.renameTo(deleteIt)) {
                    throw new IOException(String.valueOf(this.file.getAbsolutePath()) + " rename failed");
                }
                if (!nf.renameTo(this.file)) {
                    throw new IOException(String.valueOf(this.file.getAbsolutePath()) + " rename failed");
                }
            }
            catch (Exception e) {
                InternalError ierr = new InternalError(this.file.getAbsolutePath());
                ierr.initCause(e);
                throw ierr;
            }
        }
    }

    public static class Entry {
        String id;
        String kind;
        String ior;

        public NameComponent getComponent() {
            return new NameComponent(this.id, this.kind);
        }

        public void write(OutputStream out) throws IOException {
            out.write(this.getKey(this.id, this.kind).getBytes());
            out.write(10);
            out.write(this.ior.getBytes());
            out.write(10);
            out.close();
        }

        public boolean read(BufferedReader in) throws IOException {
            String key = in.readLine();
            String xior = in.readLine();
            if (key != null && xior != null) {
                if (key.length() < 2) {
                    this.id = key;
                    this.kind = "";
                } else {
                    int iks = -1;
                    int i = 1;
                    while (i < key.length()) {
                        if (key.charAt(i) == '.' && key.charAt(i - 1) != '\\') {
                            iks = i;
                            break;
                        }
                        ++i;
                    }
                    if (iks < 0) {
                        this.id = key;
                        this.kind = "";
                    } else if (iks == key.length() - 1) {
                        this.id = key.substring(0, key.length() - 1);
                        this.kind = "";
                    } else {
                        this.id = key.substring(0, iks);
                        this.kind = key.substring(iks + 1);
                    }
                }
                this.ior = xior;
                return true;
            }
            return false;
        }

        public String getKey(String id, String kind) {
            StringBuilder b = new StringBuilder(id.length() + 8);
            this.appEscaping(b, id);
            b.append('.');
            if (kind != null && kind.length() > 0) {
                this.appEscaping(b, kind);
            }
            return b.toString();
        }

        void appEscaping(StringBuilder b, String s) {
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                switch (c) {
                    case '.': 
                    case '/': 
                    case '\\': {
                        b.append('\\');
                        b.append(c);
                        break;
                    }
                    default: {
                        b.append(c);
                    }
                }
                ++i;
            }
        }
    }
}

