/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RunningTotal {
    private long total = 0L;
    private int size;
    private Deque<Long> values;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    public RunningTotal(int size) {
        this.size = size;
        this.values = new ArrayDeque<Long>(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long value) {
        this.writeLock.lock();
        try {
            if (this.values.size() >= this.size) {
                Long oldValue = this.values.pollFirst();
                this.total -= oldValue.longValue();
            }
            this.values.add(value);
            this.total += value;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        this.readLock.lock();
        try {
            long l = this.values.size();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotal() {
        this.readLock.lock();
        try {
            long l = this.total;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAverage() {
        this.readLock.lock();
        try {
            if (this.values.size() <= 0) {
                double d = 0.0;
                return d;
            }
            double d = (double)this.total / (double)this.values.size();
            return d;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        return Long.toString(this.getTotal());
    }
}

