/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DataConverter;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class Gps103ProtocolDecoder
extends BaseProtocolDecoder {
    private int photoPackets = 0;
    private ByteBuf photo;
    private static final Pattern PATTERN = new PatternBuilder().text("imei:").number("(d+),").expression("([^,]+),").groupBegin().number("(dd)/?(dd)/?(dd) ?").number("(dd):?(dd)(?:dd)?,").or().number("d*,").groupEnd().expression("([^,]+)?,").groupBegin().text("L,,,").number("(x+),,").number("(x+),,,").or().text("F,").groupBegin().number("(dd)(dd)(dd).d+").or().number("(?:d{1,5}.d+)?").groupEnd().text(",").expression("([AV]),").expression("([NS]),").optional().number("(d+)(dd.d+),").expression("([NS]),").optional().expression("([EW]),").optional().number("(d+)(dd.d+),").expression("([EW])?,").optional().number("(d+.?d*)?").optional().number(",(d+.?d*)?").optional().number(",(d+.?d*)?").optional().number(",([01])?").optional().number(",([01])?").optional().groupBegin().number(",(?:(d+.d+)%)?").number(",(?:(d+.d+)%|d+)?").groupEnd("?").number(",([-+]?d+)?").groupEnd().any().compile();
    private static final Pattern PATTERN_OBD = new PatternBuilder().text("imei:").number("(d+),").expression("OBD,").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").number("(d+)?,").number("(d+.d+)?,").number("(d+.d+)?,").number("(d+)?,").number("(d+),").number("(d+.?d*%),").number("(?:([-+]?d+)|[-+]?),").number("(d+.?d*%),").number("(d+),").number("(d+.d+),").number("([^;]*)").any().compile();
    private static final Pattern PATTERN_ALT = new PatternBuilder().text("imei:").number("(d+),").expression("[^,]+,").expression("(?:-+|(.+)),").expression("(?:-+|(.+)),").expression("(?:-+|(.+)),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(d+),").number("(d),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+),").number("(d+),").number("(-?d+),").number("(d+.d+),").number("(d+),").number("([01]),").number("([01]),").expression("(?:-+|(.+))").any().compile();

    public Gps103ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(String value) {
        if (value.startsWith("T:")) {
            return "temperature";
        }
        if (value.startsWith("oil")) {
            return "fuelLeak";
        }
        switch (value) {
            case "tracker": {
                return null;
            }
            case "help me": {
                return "sos";
            }
            case "low battery": {
                return "lowBattery";
            }
            case "stockade": {
                return "geofence";
            }
            case "move": {
                return "movement";
            }
            case "speed": {
                return "overspeed";
            }
            case "acc on": {
                return "powerOn";
            }
            case "acc off": {
                return "powerOff";
            }
            case "door alarm": {
                return "door";
            }
            case "ac alarm": {
                return "powerCut";
            }
            case "accident alarm": {
                return "accident";
            }
            case "sensor alarm": {
                return "shock";
            }
            case "bonnet alarm": {
                return "bonnet";
            }
            case "footbrake alarm": {
                return "footBrake";
            }
            case "DTC": {
                return "fault";
            }
        }
        return null;
    }

    private Position decodeRegular(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        String imei = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        String alarm = parser.next();
        position.set("alarm", this.decodeAlarm(alarm));
        if (alarm.equals("help me")) {
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage("**,imei:" + imei + ",E;", remoteAddress));
            }
        } else if (alarm.startsWith("vt")) {
            this.photoPackets = Integer.parseInt(alarm.substring(2));
            this.photo = Unpooled.buffer();
        } else if (alarm.equals("acc on")) {
            position.set("ignition", true);
        } else if (alarm.equals("acc off")) {
            position.set("ignition", false);
        } else if (alarm.startsWith("T:")) {
            position.set("temp1", Double.parseDouble(alarm.substring(2)));
        } else if (alarm.startsWith("oil ")) {
            position.set("fuel", Double.parseDouble(alarm.substring(4)));
        } else if (!position.getAttributes().containsKey("alarm") && !alarm.equals("tracker")) {
            position.set("event", alarm);
        }
        DateBuilder dateBuilder = new DateBuilder().setDate(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        int localHours = parser.nextInt(0);
        int localMinutes = parser.nextInt(0);
        String rfid = parser.next();
        if (alarm.equals("rfid")) {
            position.set("driverUniqueId", rfid);
        }
        if (parser.hasNext(2)) {
            this.getLastLocation(position, null);
            position.setNetwork(new Network(CellTower.fromLacCid(parser.nextHexInt(0), parser.nextHexInt(0))));
        } else {
            String utcHours = parser.next();
            String utcMinutes = parser.next();
            dateBuilder.setTime(localHours, localMinutes, parser.nextInt(0));
            if (utcHours != null && utcMinutes != null) {
                int deltaMinutes = (localHours - Integer.parseInt(utcHours)) * 60;
                if ((deltaMinutes += localMinutes - Integer.parseInt(utcMinutes)) <= -720) {
                    deltaMinutes += 1440;
                } else if (deltaMinutes > 720) {
                    deltaMinutes -= 1440;
                }
                dateBuilder.addMinute(-deltaMinutes);
            }
            position.setTime(dateBuilder.getDate());
            position.setValid(parser.next().equals("A"));
            position.setFixTime(position.getDeviceTime());
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN_HEM));
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN_HEM));
            position.setSpeed(parser.nextDouble(0.0));
            position.setCourse(parser.nextDouble(0.0));
            position.setAltitude(parser.nextDouble(0.0));
            if (parser.hasNext()) {
                position.set("ignition", parser.nextInt() == 1);
            }
            if (parser.hasNext()) {
                position.set("door", parser.nextInt() == 1);
            }
            position.set("fuel1", parser.nextDouble());
            position.set("fuel2", parser.nextDouble());
            position.set("temp1", parser.nextInt());
        }
        return position;
    }

    private Position decodeObd(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_OBD, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, parser.nextDateTime());
        position.set("odometer", parser.nextInt(0));
        parser.nextDouble(0.0);
        position.set("fuelConsumption", parser.nextDouble(0.0));
        if (parser.hasNext()) {
            position.set("hours", UnitsConverter.msFromHours(parser.nextInt().intValue()));
        }
        position.set("obdSpeed", parser.nextInt(0));
        position.set("engineLoad", parser.next());
        position.set("coolantTemp", parser.nextInt());
        position.set("throttle", parser.next());
        position.set("rpm", parser.nextInt(0));
        position.set("battery", parser.nextDouble(0.0));
        position.set("dtcs", parser.next().replace(',', ' ').trim());
        return position;
    }

    private Position decodeAlternative(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_ALT, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("event", parser.next());
        position.set("sensorId", parser.next());
        position.set("sensorVoltage", parser.nextDouble());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.HMS_DMY));
        position.set("rssi", parser.nextInt());
        position.setValid(parser.nextInt() > 0);
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        position.setCourse(parser.nextInt().intValue());
        position.setAltitude(parser.nextInt().intValue());
        position.set("hdop", parser.nextDouble());
        position.set("sat", parser.nextInt());
        position.set("ignition", parser.nextInt() > 0);
        position.set("charge", parser.nextInt() > 0);
        position.set("error", parser.next());
        return position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Position decodePhoto(Channel channel, SocketAddress remoteAddress, String sentence) {
        String imei = sentence.substring(5, 20);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(sentence.substring(24, sentence.endsWith(";") ? sentence.length() - 1 : sentence.length())));
        int index = buf.readUnsignedShortLE();
        this.photo.writeBytes(buf, buf.readerIndex() + 2, buf.readableBytes() - 4);
        if (index + 1 >= this.photoPackets) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            try {
                position.set("image", Context.getMediaManager().writeFile(imei, this.photo, "jpg"));
            }
            finally {
                this.photoPackets = 0;
                this.photo.release();
                this.photo = null;
            }
            return position;
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.contains("imei:") && sentence.length() <= 30) {
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage("LOAD", remoteAddress));
                Matcher matcher = Pattern.compile("imei:(\\d+),").matcher(sentence);
                if (matcher.find()) {
                    this.getDeviceSession(channel, remoteAddress, matcher.group(1));
                }
            }
            return null;
        }
        if (!sentence.isEmpty() && Character.isDigit(sentence.charAt(0))) {
            int start;
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage("ON", remoteAddress));
            }
            if ((start = sentence.indexOf("imei:")) >= 0) {
                sentence = sentence.substring(start);
            } else {
                return null;
            }
        }
        if (sentence.substring(21, 23).equals("vr")) {
            return this.decodePhoto(channel, remoteAddress, sentence);
        }
        if (sentence.substring(21, 24).contains("OBD")) {
            return this.decodeObd(channel, remoteAddress, sentence);
        }
        if (sentence.endsWith("*")) {
            return this.decodeAlternative(channel, remoteAddress, sentence);
        }
        return this.decodeRegular(channel, remoteAddress, sentence);
    }
}

