/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BitBuffer;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;

public class AisProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("!AIVDM,").number("(d+),").number("(d+),").number("(d+)?,").expression(".,").expression("([^,]+),").any().compile();

    public AisProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Position decodePayload(Channel channel, SocketAddress remoteAddress, BitBuffer buf) {
        int type = buf.readUnsigned(6);
        if (type == 1 || type == 2 || type == 3 || type == 18) {
            buf.readUnsigned(2);
            int mmsi = buf.readUnsigned(30);
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(mmsi));
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setTime(new Date());
            if (type == 18) {
                buf.readUnsigned(8);
            } else {
                position.set("status", buf.readUnsigned(4));
                position.set("turn", buf.readSigned(8));
            }
            position.setSpeed((double)buf.readUnsigned(10) * 0.1);
            position.setValid(buf.readUnsigned(1) != 0);
            position.setLongitude((double)buf.readSigned(28) * 1.0E-4 / 60.0);
            position.setLatitude((double)buf.readSigned(27) * 1.0E-4 / 60.0);
            position.setCourse((double)buf.readUnsigned(12) * 0.1);
            position.set("heading", buf.readUnsigned(9));
            return position;
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String[] sentences = ((String)msg).split("\\r\\n");
        ArrayList<Position> positions = new ArrayList<Position>();
        HashMap<Integer, BitBuffer> buffers = new HashMap<Integer, BitBuffer>();
        for (String sentence : sentences) {
            BitBuffer bits;
            Parser parser;
            if (sentence.isEmpty() || !(parser = new Parser(PATTERN, sentence)).matches()) continue;
            int count = parser.nextInt(0);
            int index = parser.nextInt(0);
            int id = parser.nextInt(0);
            Position position = null;
            if (count == 1) {
                bits = new BitBuffer();
                bits.writeEncoded(parser.next().getBytes(StandardCharsets.US_ASCII));
                position = this.decodePayload(channel, remoteAddress, bits);
            } else {
                bits = (BitBuffer)buffers.get(id);
                if (bits == null) {
                    bits = new BitBuffer();
                    buffers.put(id, bits);
                }
                bits.writeEncoded(parser.next().getBytes(StandardCharsets.US_ASCII));
                if (count == index) {
                    position = this.decodePayload(channel, remoteAddress, bits);
                    buffers.remove(id);
                }
            }
            if (position == null) continue;
            positions.add(position);
        }
        return positions;
    }
}

