/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.events;

import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.Map;
import org.traccar.BaseEventHandler;
import org.traccar.Context;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class IgnitionEventHandler
extends BaseEventHandler {
    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        Device device = Context.getIdentityManager().getById(position.getDeviceId());
        if (device == null || !Context.getIdentityManager().isLatestPosition(position)) {
            return null;
        }
        Map<Event, Position> result = null;
        if (position.getAttributes().containsKey("ignition")) {
            boolean ignition = position.getBoolean("ignition");
            Position lastPosition = Context.getIdentityManager().getLastPosition(position.getDeviceId());
            if (lastPosition != null && lastPosition.getAttributes().containsKey("ignition")) {
                boolean oldIgnition = lastPosition.getBoolean("ignition");
                if (ignition && !oldIgnition) {
                    result = Collections.singletonMap(new Event("ignitionOn", position.getDeviceId(), position.getId()), position);
                } else if (!ignition && oldIgnition) {
                    result = Collections.singletonMap(new Event("ignitionOff", position.getDeviceId(), position.getId()), position);
                }
            }
        }
        return result;
    }
}

