/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.exchange;

import com.projectlibre1.exchange.FileImporter;
import com.projectlibre1.grouping.core.model.DefaultNodeModel;
import com.projectlibre1.job.Job;
import com.projectlibre1.job.JobRunnable;
import com.projectlibre1.pm.resource.ResourcePool;
import com.projectlibre1.pm.resource.ResourcePoolFactory;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.server.data.DataUtil;
import com.projectlibre1.server.data.DocumentData;
import com.projectlibre1.session.LocalSession;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.undo.DataFactoryUndoController;
import com.projectlibre1.util.Alert;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class LocalFileImporter
extends FileImporter {
    public static final String VERSION = "1.0.0";
    private static final String PROJECT_LIBRE_FILE_SEPARATOR = "@@@@@@@@@@ProjectLibreSeparator_MSXML@@@@@@@@@@";
    private static final String XML_FILE_START = "<?xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importFile() throws Exception {
        block33: {
            Object object;
            Object object2;
            File file = new File(this.getFileName());
            FileInputStream fileInputStream = new FileInputStream(file);
            Exception exception = null;
            try {
                object2 = new DataUtil();
                System.out.println("Loading " + this.getFileName() + "...");
                long l = System.currentTimeMillis();
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                object = objectInputStream.readObject();
                if (object instanceof String) {
                    object = objectInputStream.readObject();
                }
                DocumentData documentData = (DocumentData)object;
                documentData.setMaster(true);
                documentData.setLocal(true);
                long l2 = System.currentTimeMillis();
                System.out.println("Loading...Done in " + (l2 - l) + " ms");
                System.out.println("Deserializing...");
                l = System.currentTimeMillis();
                this.setProject(((DataUtil)object2).deserializeLocalDocument(documentData));
                l2 = System.currentTimeMillis();
                System.out.println("Deserializing...Done in " + (l2 - l) + " ms");
            }
            catch (Exception exception2) {
                exception = exception2;
                this.project = null;
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception3) {
                    exception3.printStackTrace();
                }
            }
            if (this.project == null) {
                object2 = null;
                try {
                    int n;
                    System.out.println("Trying to recover with XML...");
                    fileInputStream = new FileInputStream(file);
                    byte[] byArray = PROJECT_LIBRE_FILE_SEPARATOR.getBytes();
                    byte[] byArray2 = XML_FILE_START.getBytes();
                    int n2 = 100;
                    if (n2 < byArray.length) {
                        n2 = byArray.length;
                    }
                    object = new byte[n2];
                    object2 = new BufferedInputStream(fileInputStream);
                    int n3 = 0;
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = true;
                    ((BufferedInputStream)object2).mark(n2);
                    while ((n = ((BufferedInputStream)object2).read((byte[])object, 0, n2)) != -1) {
                        int n4;
                        if (bl3 && n > byArray2.length) {
                            for (n4 = 0; n4 < byArray2.length; ++n4) {
                                if (byArray2[n4] == object[n4]) continue;
                                bl3 = false;
                                break;
                            }
                            if (bl3) {
                                bl2 = true;
                                break;
                            }
                        }
                        for (n4 = 0; n4 < n; ++n4) {
                            if (byArray[n3] == object[n4]) {
                                if (n3 == byArray.length - 1) {
                                    bl = true;
                                    ((BufferedInputStream)object2).reset();
                                    ((BufferedInputStream)object2).read((byte[])object, 0, n4 + 1);
                                    break;
                                }
                                ++n3;
                                continue;
                            }
                            n3 = 0;
                        }
                        if (bl) break;
                        ((BufferedInputStream)object2).mark(n2);
                    }
                    if (bl2) {
                        if (object2 != null) {
                            try {
                                ((BufferedInputStream)object2).close();
                            }
                            catch (Exception exception4) {
                                exception4.printStackTrace();
                            }
                        }
                        fileInputStream = new FileInputStream(file);
                        object2 = new BufferedInputStream(fileInputStream);
                    }
                    if (bl || bl2) {
                        System.out.println("XML found");
                        FileImporter fileImporter = LocalSession.getImporter("com.projectlibre1.exchange.MicrosoftImporter");
                        ResourcePool resourcePool = null;
                        DataFactoryUndoController dataFactoryUndoController = new DataFactoryUndoController();
                        resourcePool = ResourcePoolFactory.getInstance().createResourcePool("", dataFactoryUndoController);
                        resourcePool.setLocal(true);
                        this.project = Project.createProject(resourcePool, dataFactoryUndoController);
                        ((DefaultNodeModel)this.project.getTaskOutline()).setDataFactory(this.project);
                        fileImporter.setProject(this.project);
                        fileImporter.loadProject((InputStream)object2);
                        System.out.println("Recovered with XML");
                    } else if (exception != null) {
                        throw exception;
                    }
                }
                catch (Exception exception5) {
                    exception5.printStackTrace();
                    if (object2 == null) break block33;
                    try {
                        ((BufferedInputStream)object2).close();
                    }
                    catch (Exception exception6) {
                        exception6.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void exportFile() throws Exception {
        File file;
        String string = "";
        String string2 = this.fileName;
        String string3 = this.fileName;
        int n = this.fileName.lastIndexOf(46);
        if (n > 0) {
            string = this.fileName.substring(n);
            string2 = this.fileName.substring(0, n);
        }
        File file2 = file = new File(this.fileName);
        int n2 = 0;
        while (file2.exists()) {
            string3 = string2 + "_tmp" + n2 + string;
            file2 = new File(string3);
            ++n2;
        }
        n2 = 0;
        try {
            Object object;
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                object = new DataUtil();
                System.out.println("Serialization...");
                long l = System.currentTimeMillis();
                DocumentData documentData = ((DataUtil)object).serializeDocument(this.getProject());
                documentData.setMaster(true);
                documentData.setLocal(true);
                long l2 = System.currentTimeMillis();
                System.out.println("Serialization...Done in " + (l2 - l) + " ms");
                System.out.println("Saving " + file + "...");
                l = System.currentTimeMillis();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(VERSION);
                objectOutputStream.writeObject(documentData);
                objectOutputStream.flush();
                l2 = System.currentTimeMillis();
                System.out.println("Saving...Done in " + (l2 - l) + " ms");
            }
            catch (Exception exception) {
                n2 = 1;
                exception.printStackTrace();
            }
            try {
                object = new BufferedOutputStream(fileOutputStream);
                ((FilterOutputStream)object).write(PROJECT_LIBRE_FILE_SEPARATOR.getBytes());
                ((BufferedOutputStream)object).flush();
                FileImporter fileImporter = LocalSession.getImporter("com.projectlibre1.exchange.MicrosoftImporter");
                fileImporter.saveProject(this.project, (OutputStream)object);
                ((BufferedOutputStream)object).flush();
            }
            catch (Exception exception) {
                n2 = 1;
                exception.printStackTrace();
            }
            fileOutputStream.close();
        }
        catch (Exception exception) {
            n2 = 1;
            exception.printStackTrace();
        }
        if (n2 != 0) {
            if (file.equals(file2)) {
                Alert.error(Messages.getString("Message.saveError"));
            } else {
                Alert.error(Messages.getString("Message.saveErrorTmpFile") + string3);
            }
        } else if (!file.equals(file2)) {
            file.delete();
            file2.renameTo(file);
        }
    }

    @Override
    public Job getImportFileJob() {
        return LocalFileImporter.getImportFileJob(this);
    }

    public static Job getImportFileJob(final FileImporter fileImporter) {
        Job job = new Job(fileImporter.getJobQueue(), "importFile", Messages.getString("LocalFileImporter.Importing"), true);
        job.addRunnable(new JobRunnable("Import", 1.0f){

            @Override
            public Object run() throws Exception {
                fileImporter.importFile();
                this.setProgress(1.0f);
                return null;
            }
        });
        return job;
    }

    @Override
    public Job getExportFileJob() {
        return LocalFileImporter.getExportFileJob(this);
    }

    public static Job getExportFileJob(final FileImporter fileImporter) {
        Job job = new Job(fileImporter.getJobQueue(), "exportFile", Messages.getString("LocalFileImporter.Exporting"), true);
        job.addRunnable(new JobRunnable("Export", 1.0f){

            @Override
            public Object run() throws Exception {
                fileImporter.exportFile();
                this.setProgress(1.0f);
                return null;
            }
        });
        return job;
    }

    @Override
    public boolean saveProject(Project project, OutputStream outputStream) throws Exception {
        return false;
    }

    @Override
    public Project loadProject(InputStream inputStream) throws Exception {
        return null;
    }
}

