/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFormatter
extends JFormattedTextField.AbstractFormatter
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -355018354457785329L;
    boolean commitsOnValidEdit = false;
    boolean overwriteMode = true;
    boolean allowsInvalid = true;
    Class valueClass;

    @Override
    public void install(JFormattedTextField ftf) {
        super.install(ftf);
    }

    public boolean getCommitsOnValidEdit() {
        return this.commitsOnValidEdit;
    }

    public void setCommitsOnValidEdit(boolean commitsOnValidEdit) {
        this.commitsOnValidEdit = commitsOnValidEdit;
    }

    public boolean getOverwriteMode() {
        return this.overwriteMode;
    }

    public void setOverwriteMode(boolean overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public boolean getAllowsInvalid() {
        return this.allowsInvalid;
    }

    public void setAllowsInvalid(boolean allowsInvalid) {
        this.allowsInvalid = allowsInvalid;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Class<?> valueClass) {
        this.valueClass = valueClass;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        JFormattedTextField jft;
        String value = string;
        Class<Object> valueClass = this.getValueClass();
        if (valueClass == null && (jft = this.getFormattedTextField()) != null) {
            valueClass = jft.getValue().getClass();
        }
        if (valueClass != null) {
            try {
                Constructor<?> constr = valueClass.getConstructor(String.class);
                value = constr.newInstance(string);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                throw new ParseException(string, 0);
            }
        }
        return value;
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        return new FormatterDocumentFilter();
    }

    private class FormatterDocumentFilter
    extends DocumentFilter {
        private FormatterDocumentFilter() {
        }

        public void remove(DocumentFilter.FilterBypass bypass, int offset, int length) throws BadLocationException {
            super.remove(bypass, offset, length);
            this.checkValidInput();
            this.commitIfAllowed();
        }

        public void insertString(DocumentFilter.FilterBypass bypass, int offset, String text, AttributeSet attributes) throws BadLocationException {
            if (DefaultFormatter.this.overwriteMode) {
                this.replace(bypass, offset, text.length(), text, attributes);
            } else {
                super.insertString(bypass, offset, text, attributes);
            }
            this.checkValidInput();
            this.commitIfAllowed();
        }

        public void replace(DocumentFilter.FilterBypass bypass, int offset, int length, String text, AttributeSet attributes) throws BadLocationException {
            super.replace(bypass, offset, length, text, attributes);
            this.checkValidInput();
            this.commitIfAllowed();
        }

        private void commitIfAllowed() {
            if (DefaultFormatter.this.commitsOnValidEdit) {
                try {
                    DefaultFormatter.this.getFormattedTextField().commitEdit();
                }
                catch (ParseException parseException) {}
            }
        }

        private void checkValidInput() {
            block4: {
                JFormattedTextField ftf = DefaultFormatter.this.getFormattedTextField();
                try {
                    DefaultFormatter.this.stringToValue(ftf.getText());
                }
                catch (ParseException parseException) {
                    if (DefaultFormatter.this.allowsInvalid) break block4;
                    try {
                        ftf.setText(DefaultFormatter.this.valueToString(ftf.getValue()));
                    }
                    catch (ParseException pe) {
                        AssertionError ae = new AssertionError((Object)"values must be parseable");
                        ((Throwable)((Object)ae)).initCause(pe);
                        throw ae;
                    }
                }
            }
        }
    }
}

