/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.UnmodifiableSetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeSetUtilities {
    private AttributeSetUtilities() {
    }

    public static AttributeSet synchronizedView(AttributeSet attributeSet) {
        return new SynchronizedAttributeSet(attributeSet);
    }

    public static DocAttributeSet synchronizedView(DocAttributeSet attributeSet) {
        return new SynchronizedDocAttributeSet(attributeSet);
    }

    public static PrintJobAttributeSet synchronizedView(PrintJobAttributeSet attributeSet) {
        return new SynchronizedPrintJobAttributeSet(attributeSet);
    }

    public static PrintRequestAttributeSet synchronizedView(PrintRequestAttributeSet attributeSet) {
        return new SynchronizedPrintRequestAttributeSet(attributeSet);
    }

    public static PrintServiceAttributeSet synchronizedView(PrintServiceAttributeSet attributeSet) {
        return new SynchronizedPrintServiceAttributeSet(attributeSet);
    }

    public static AttributeSet unmodifiableView(AttributeSet attributeSet) {
        return new UnmodifiableAttributeSet(attributeSet);
    }

    public static DocAttributeSet unmodifiableView(DocAttributeSet attributeSet) {
        return new UnmodifiableDocAttributeSet(attributeSet);
    }

    public static PrintJobAttributeSet unmodifiableView(PrintJobAttributeSet attributeSet) {
        return new UnmodifiablePrintJobAttributeSet(attributeSet);
    }

    public static PrintRequestAttributeSet unmodifiableView(PrintRequestAttributeSet attributeSet) {
        return new UnmodifiablePrintRequestAttributeSet(attributeSet);
    }

    public static PrintServiceAttributeSet unmodifiableView(PrintServiceAttributeSet attributeSet) {
        return new UnmodifiablePrintServiceAttributeSet(attributeSet);
    }

    public static Class<?> verifyAttributeCategory(Object object, Class<?> interfaceName) {
        if (object == null) {
            throw new NullPointerException("object may not be null");
        }
        Class clazz = (Class)object;
        if (interfaceName.isAssignableFrom(clazz)) {
            return clazz;
        }
        throw new ClassCastException();
    }

    public static Attribute verifyAttributeValue(Object object, Class<?> interfaceName) {
        if (object == null) {
            throw new NullPointerException("object may not be null");
        }
        if (interfaceName.isInstance(object)) {
            return (Attribute)object;
        }
        throw new ClassCastException();
    }

    public static void verifyCategoryForValue(Class<?> category, Attribute attribute) {
        if (category == null || attribute == null) {
            throw new NullPointerException("category or attribute may not be null");
        }
        if (!category.equals(attribute.getCategory())) {
            throw new IllegalArgumentException("category of attribute not equal to category");
        }
    }

    private static class SynchronizedAttributeSet
    implements AttributeSet,
    Serializable {
        private AttributeSet attrset;

        public SynchronizedAttributeSet(AttributeSet attributeSet) {
            if (attributeSet == null) {
                throw new NullPointerException("attributeSet may not be null");
            }
            this.attrset = attributeSet;
        }

        public synchronized boolean add(Attribute attribute) {
            return this.attrset.add(attribute);
        }

        public synchronized boolean addAll(AttributeSet attributes) {
            return this.attrset.addAll(attributes);
        }

        public synchronized void clear() {
            this.attrset.clear();
        }

        public synchronized boolean containsKey(Class category) {
            return this.attrset.containsKey(category);
        }

        public synchronized boolean containsValue(Attribute attribute) {
            return this.attrset.containsValue(attribute);
        }

        public synchronized boolean equals(Object obj) {
            return this.attrset.equals(obj);
        }

        public synchronized Attribute get(Class interfaceName) {
            return this.attrset.get(interfaceName);
        }

        public synchronized int hashCode() {
            return this.attrset.hashCode();
        }

        public synchronized boolean isEmpty() {
            return this.attrset.isEmpty();
        }

        public synchronized boolean remove(Class category) {
            return this.attrset.remove(category);
        }

        public synchronized boolean remove(Attribute attribute) {
            return this.attrset.remove(attribute);
        }

        public synchronized int size() {
            return this.attrset.size();
        }

        public synchronized Attribute[] toArray() {
            return this.attrset.toArray();
        }
    }

    private static class SynchronizedDocAttributeSet
    extends SynchronizedAttributeSet
    implements DocAttributeSet,
    Serializable {
        public SynchronizedDocAttributeSet(DocAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class SynchronizedPrintJobAttributeSet
    extends SynchronizedAttributeSet
    implements PrintJobAttributeSet,
    Serializable {
        public SynchronizedPrintJobAttributeSet(PrintJobAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class SynchronizedPrintRequestAttributeSet
    extends SynchronizedAttributeSet
    implements PrintRequestAttributeSet,
    Serializable {
        public SynchronizedPrintRequestAttributeSet(PrintRequestAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class SynchronizedPrintServiceAttributeSet
    extends SynchronizedAttributeSet
    implements PrintServiceAttributeSet,
    Serializable {
        public SynchronizedPrintServiceAttributeSet(PrintServiceAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class UnmodifiableAttributeSet
    implements AttributeSet,
    Serializable {
        private AttributeSet attrset;

        public UnmodifiableAttributeSet(AttributeSet attributeSet) {
            if (attributeSet == null) {
                throw new NullPointerException("attributeSet may not be null");
            }
            this.attrset = attributeSet;
        }

        public boolean add(Attribute attribute) {
            throw new UnmodifiableSetException();
        }

        public boolean addAll(AttributeSet attributes) {
            throw new UnmodifiableSetException();
        }

        public void clear() {
            throw new UnmodifiableSetException();
        }

        public boolean containsKey(Class category) {
            return this.attrset.containsKey(category);
        }

        public boolean containsValue(Attribute attribute) {
            return this.attrset.containsValue(attribute);
        }

        public boolean equals(Object obj) {
            return this.attrset.equals(obj);
        }

        public Attribute get(Class interfaceName) {
            return this.attrset.get(interfaceName);
        }

        public int hashCode() {
            return this.attrset.hashCode();
        }

        public boolean isEmpty() {
            return this.attrset.isEmpty();
        }

        public boolean remove(Class category) {
            throw new UnmodifiableSetException();
        }

        public boolean remove(Attribute attribute) {
            throw new UnmodifiableSetException();
        }

        public int size() {
            return this.attrset.size();
        }

        public Attribute[] toArray() {
            return this.attrset.toArray();
        }
    }

    private static class UnmodifiableDocAttributeSet
    extends UnmodifiableAttributeSet
    implements DocAttributeSet,
    Serializable {
        public UnmodifiableDocAttributeSet(DocAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class UnmodifiablePrintJobAttributeSet
    extends UnmodifiableAttributeSet
    implements PrintJobAttributeSet,
    Serializable {
        public UnmodifiablePrintJobAttributeSet(PrintJobAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class UnmodifiablePrintRequestAttributeSet
    extends UnmodifiableAttributeSet
    implements PrintRequestAttributeSet,
    Serializable {
        public UnmodifiablePrintRequestAttributeSet(PrintRequestAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class UnmodifiablePrintServiceAttributeSet
    extends UnmodifiableAttributeSet
    implements PrintServiceAttributeSet,
    Serializable {
        public UnmodifiablePrintServiceAttributeSet(PrintServiceAttributeSet attributeSet) {
            super(attributeSet);
        }
    }
}

