/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ExemptionMechanismException;
import javax.crypto.ExemptionMechanismSpi;
import javax.crypto.ShortBufferException;

public class ExemptionMechanism {
    private static final String SERVICE = "ExemptionMechanism";
    private ExemptionMechanismSpi emSpi;
    private Provider provider;
    private String mechanism;
    private boolean virgin;

    protected ExemptionMechanism(ExemptionMechanismSpi emSpi, Provider provider, String mechanism) {
        this.emSpi = emSpi;
        this.provider = provider;
        this.mechanism = mechanism;
        this.virgin = true;
    }

    public static final ExemptionMechanism getInstance(String mechanism) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        NoSuchAlgorithmException lastException = null;
        int i = 0;
        while (i < p.length) {
            try {
                return ExemptionMechanism.getInstance(mechanism, p[i]);
            }
            catch (NoSuchAlgorithmException x) {
                lastException = x;
                ++i;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new NoSuchAlgorithmException(mechanism);
    }

    public static final ExemptionMechanism getInstance(String mechanism, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return ExemptionMechanism.getInstance(mechanism, p);
    }

    public static final ExemptionMechanism getInstance(String mechanism, Provider provider) throws NoSuchAlgorithmException {
        Throwable cause;
        StringBuilder sb = new StringBuilder("ExemptionMechanism [").append(mechanism).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object spi = Engine.getInstance(SERVICE, mechanism, provider);
            return new ExemptionMechanism((ExemptionMechanismSpi)spi, provider, mechanism);
        }
        catch (InvocationTargetException x) {
            cause = x.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)cause;
            }
            if (cause == null) {
                cause = x;
            }
        }
        catch (ClassCastException x) {
            cause = x;
        }
        NoSuchAlgorithmException x = new NoSuchAlgorithmException(sb.toString());
        x.initCause(cause);
        throw x;
    }

    public final byte[] genExemptionBlob() throws IllegalStateException, ExemptionMechanismException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.emSpi.engineGenExemptionBlob();
    }

    public final int genExemptionBlob(byte[] output) throws IllegalStateException, ExemptionMechanismException, ShortBufferException {
        return this.genExemptionBlob(output, 0);
    }

    public final int genExemptionBlob(byte[] output, int outputOffset) throws IllegalStateException, ExemptionMechanismException, ShortBufferException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.emSpi.engineGenExemptionBlob(output, outputOffset);
    }

    public final String getName() {
        return this.mechanism;
    }

    public final int getOutputSize(int inputLength) throws IllegalStateException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.emSpi.engineGetOutputSize(inputLength);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws ExemptionMechanismException, InvalidKeyException {
        this.emSpi.engineInit(key);
        this.virgin = false;
    }

    public final void init(Key key, AlgorithmParameters params) throws ExemptionMechanismException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.emSpi.engineInit(key, params);
        this.virgin = false;
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws ExemptionMechanismException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.emSpi.engineInit(key, params);
        this.virgin = false;
    }

    public final boolean isCryptoAllowed(Key key) throws ExemptionMechanismException {
        return true;
    }

    protected void finalize() {
    }
}

