/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Observer;
import java.util.Set;

public class Observable {
    private boolean changed;
    private LinkedHashSet observers = new LinkedHashSet();

    public synchronized void addObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException("can't add null observer");
        }
        this.observers.add(observer);
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized int countObservers() {
        return this.observers.size();
    }

    public synchronized void deleteObserver(Observer victim) {
        this.observers.remove(victim);
    }

    public synchronized void deleteObservers() {
        this.observers.clear();
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object obj) {
        Set s;
        if (!this.hasChanged()) {
            return;
        }
        Observable observable = this;
        synchronized (observable) {
            s = (Set)this.observers.clone();
        }
        int i = s.size();
        Iterator iter = s.iterator();
        while (--i >= 0) {
            ((Observer)iter.next()).update(this, obj);
        }
        this.clearChanged();
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }
}

