/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import gnu.classpath.SystemProperties;
import gnu.java.lang.management.ClassLoadingMXBeanImpl;
import gnu.java.lang.management.CompilationMXBeanImpl;
import gnu.java.lang.management.GarbageCollectorMXBeanImpl;
import gnu.java.lang.management.MemoryMXBeanImpl;
import gnu.java.lang.management.MemoryManagerMXBeanImpl;
import gnu.java.lang.management.MemoryPoolMXBeanImpl;
import gnu.java.lang.management.OperatingSystemMXBeanImpl;
import gnu.java.lang.management.RuntimeMXBeanImpl;
import gnu.java.lang.management.ThreadMXBeanImpl;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.management.VMManagementFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.LogManager;
import javax.management.Attribute;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementFactory {
    public static final String CLASS_LOADING_MXBEAN_NAME = "java.lang:type=ClassLoading";
    public static final String COMPILATION_MXBEAN_NAME = "java.lang:type=Compilation";
    public static final String GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE = "java.lang:type=GarbageCollector";
    public static final String MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryManager";
    public static final String MEMORY_MXBEAN_NAME = "java.lang:type=Memory";
    public static final String MEMORY_POOL_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryPool";
    public static final String OPERATING_SYSTEM_MXBEAN_NAME = "java.lang:type=OperatingSystem";
    public static final String RUNTIME_MXBEAN_NAME = "java.lang:type=Runtime";
    public static final String THREAD_MXBEAN_NAME = "java.lang:type=Threading";
    private static OperatingSystemMXBean osBean;
    private static RuntimeMXBean runtimeBean;
    private static ClassLoadingMXBean classLoadingBean;
    private static ThreadMXBean threadBean;
    private static MemoryMXBean memoryBean;
    private static CompilationMXBean compilationBean;
    private static MBeanServer platformServer;

    private ManagementFactory() {
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        if (osBean == null) {
            try {
                osBean = new OperatingSystemMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the operating system bean is not a compliant management bean.");
            }
        }
        return osBean;
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        if (runtimeBean == null) {
            try {
                runtimeBean = new RuntimeMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the runtime bean is not a compliant management bean.");
            }
        }
        return runtimeBean;
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        if (classLoadingBean == null) {
            try {
                classLoadingBean = new ClassLoadingMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the class loading bean is not a compliant management bean.");
            }
        }
        return classLoadingBean;
    }

    public static ThreadMXBean getThreadMXBean() {
        if (threadBean == null) {
            try {
                threadBean = new ThreadMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the thread bean is not a compliant management bean.");
            }
        }
        return threadBean;
    }

    public static MemoryMXBean getMemoryMXBean() {
        if (memoryBean == null) {
            try {
                memoryBean = new MemoryMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the memory bean is not a compliant management bean.");
            }
        }
        return memoryBean;
    }

    public static CompilationMXBean getCompilationMXBean() {
        if (compilationBean == null && SystemProperties.getProperty("gnu.java.compiler.name") != null) {
            try {
                compilationBean = new CompilationMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the compilation bean is not a compliant management bean.");
            }
        }
        return compilationBean;
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        ArrayList<MemoryPoolMXBean> poolBeans = new ArrayList<MemoryPoolMXBean>();
        String[] names = VMManagementFactory.getMemoryPoolNames();
        int a = 0;
        while (a < names.length) {
            try {
                poolBeans.add(new MemoryPoolMXBeanImpl(names[a]));
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the memory pool bean, " + a + ", is " + "not a compliant management bean.");
            }
            ++a;
        }
        return poolBeans;
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        ArrayList<MemoryManagerMXBean> managerBeans = new ArrayList<MemoryManagerMXBean>();
        String[] names = VMManagementFactory.getMemoryManagerNames();
        int a = 0;
        while (a < names.length) {
            try {
                managerBeans.add(new MemoryManagerMXBeanImpl(names[a]));
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the memory manager bean, " + a + ", is " + "not a compliant management bean.");
            }
            ++a;
        }
        managerBeans.addAll(ManagementFactory.getGarbageCollectorMXBeans());
        return managerBeans;
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        ArrayList<GarbageCollectorMXBean> gcBeans = new ArrayList<GarbageCollectorMXBean>();
        String[] names = VMManagementFactory.getGarbageCollectorNames();
        int a = 0;
        while (a < names.length) {
            try {
                gcBeans.add(new GarbageCollectorMXBeanImpl(names[a]));
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the garbage collector bean, " + a + ", is not a compliant management " + "bean.");
            }
            ++a;
        }
        return gcBeans;
    }

    public static MBeanServer getPlatformMBeanServer() {
        if (platformServer == null) {
            platformServer = MBeanServerFactory.createMBeanServer();
            try {
                platformServer.registerMBean(ManagementFactory.getOperatingSystemMXBean(), new ObjectName(OPERATING_SYSTEM_MXBEAN_NAME));
                platformServer.registerMBean(ManagementFactory.getRuntimeMXBean(), new ObjectName(RUNTIME_MXBEAN_NAME));
                platformServer.registerMBean(ManagementFactory.getClassLoadingMXBean(), new ObjectName(CLASS_LOADING_MXBEAN_NAME));
                platformServer.registerMBean(ManagementFactory.getThreadMXBean(), new ObjectName(THREAD_MXBEAN_NAME));
                platformServer.registerMBean(ManagementFactory.getMemoryMXBean(), new ObjectName(MEMORY_MXBEAN_NAME));
                CompilationMXBean compBean = ManagementFactory.getCompilationMXBean();
                if (compBean != null) {
                    platformServer.registerMBean(compBean, new ObjectName(COMPILATION_MXBEAN_NAME));
                }
                for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
                    platformServer.registerMBean(memoryPoolMXBean, new ObjectName("java.lang:type=MemoryPool,name=" + memoryPoolMXBean.getName()));
                }
                for (MemoryManagerMXBean memoryManagerMXBean : ManagementFactory.getMemoryManagerMXBeans()) {
                    platformServer.registerMBean(memoryManagerMXBean, new ObjectName("java.lang:type=MemoryManager,name=" + memoryManagerMXBean.getName()));
                }
                for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
                    platformServer.registerMBean(garbageCollectorMXBean, new ObjectName("java.lang:type=GarbageCollector,name=" + garbageCollectorMXBean.getName()));
                }
                platformServer.registerMBean(LogManager.getLoggingMXBean(), new ObjectName("java.util.logging:type=Logging"));
            }
            catch (InstanceAlreadyExistsException e) {
                throw (Error)new InternalError("One of the management beans is already registered.").initCause(e);
            }
            catch (MBeanRegistrationException e) {
                throw (Error)new InternalError("One of the management beans' preRegister methods threw an exception.").initCause(e);
            }
            catch (NotCompliantMBeanException e) {
                throw (Error)new InternalError("One of the management beans is not compliant.").initCause(e);
            }
            catch (MalformedObjectNameException e) {
                throw (Error)new InternalError("The object name of a management bean is not compliant.").initCause(e);
            }
        }
        return platformServer;
    }

    public static <T> T newPlatformMXBeanProxy(MBeanServerConnection connection, String mxbeanName, Class<T> mxbeanInterface) throws IOException {
        ObjectName bean;
        if (!(mxbeanName.equals(CLASS_LOADING_MXBEAN_NAME) || mxbeanName.equals(COMPILATION_MXBEAN_NAME) || mxbeanName.startsWith(GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE) || mxbeanName.startsWith(MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE) || mxbeanName.equals(MEMORY_MXBEAN_NAME) || mxbeanName.startsWith(MEMORY_POOL_MXBEAN_DOMAIN_TYPE) || mxbeanName.equals(OPERATING_SYSTEM_MXBEAN_NAME) || mxbeanName.equals(RUNTIME_MXBEAN_NAME) || mxbeanName.equals(THREAD_MXBEAN_NAME))) {
            throw new IllegalArgumentException("The named bean, " + mxbeanName + ", is not a platform name.");
        }
        if (mxbeanName.equals(CLASS_LOADING_MXBEAN_NAME) && mxbeanInterface != ClassLoadingMXBean.class || mxbeanName.equals(COMPILATION_MXBEAN_NAME) && mxbeanInterface != CompilationMXBean.class || mxbeanName.startsWith(GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE) && mxbeanInterface != GarbageCollectorMXBean.class || mxbeanName.startsWith(MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE) && mxbeanInterface != MemoryManagerMXBean.class || mxbeanName.equals(MEMORY_MXBEAN_NAME) && mxbeanInterface != MemoryMXBean.class || mxbeanName.startsWith(MEMORY_POOL_MXBEAN_DOMAIN_TYPE) && mxbeanInterface != MemoryPoolMXBean.class || mxbeanName.equals(OPERATING_SYSTEM_MXBEAN_NAME) && mxbeanInterface != OperatingSystemMXBean.class || mxbeanName.equals(RUNTIME_MXBEAN_NAME) && mxbeanInterface != RuntimeMXBean.class || mxbeanName.equals(THREAD_MXBEAN_NAME) && mxbeanInterface != ThreadMXBean.class) {
            throw new IllegalArgumentException("The interface, " + mxbeanInterface + ", does not match the bean, " + mxbeanName);
        }
        try {
            bean = new ObjectName(mxbeanName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException("The named bean is invalid.");
        }
        if (!connection.isRegistered(bean)) {
            throw new IllegalArgumentException("The bean is not registered on this connection.");
        }
        Class[] interfaces = mxbeanName.equals(MEMORY_MXBEAN_NAME) ? new Class[]{mxbeanInterface, NotificationEmitter.class} : new Class[]{mxbeanInterface};
        return (T)Proxy.newProxyInstance(mxbeanInterface.getClassLoader(), interfaces, new ManagementInvocationHandler(connection, bean));
    }

    private static class ManagementInvocationHandler
    implements InvocationHandler {
        private MBeanServerConnection conn;
        private ObjectName bean;

        public ManagementInvocationHandler(MBeanServerConnection conn, ObjectName bean) throws IOException {
            this.conn = conn;
            this.bean = bean;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            if (name.equals("toString")) {
                return "Proxy for " + this.bean + " using " + this.conn;
            }
            if (name.equals("addNotificationListener")) {
                this.conn.addNotificationListener(this.bean, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
                return null;
            }
            if (name.equals("getNotificationInfo")) {
                return this.conn.getMBeanInfo(this.bean).getNotifications();
            }
            if (name.equals("removeNotificationListener")) {
                if (args.length == 1) {
                    this.conn.removeNotificationListener(this.bean, (NotificationListener)args[0]);
                } else {
                    this.conn.removeNotificationListener(this.bean, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
                }
                return null;
            }
            String attrib = null;
            if (name.startsWith("get")) {
                attrib = name.substring(3);
            } else if (name.startsWith("is")) {
                attrib = name.substring(2);
            }
            if (attrib != null) {
                return this.translate(this.conn.getAttribute(this.bean, attrib), method);
            }
            if (name.startsWith("set")) {
                this.conn.setAttribute(this.bean, new Attribute(name.substring(3), args[0]));
                return null;
            }
            return this.translate(this.conn.invoke(this.bean, name, args, null), method);
        }

        private final Object translate(Object otype, Method method) throws Throwable {
            int n;
            int n2;
            Object[] objectArray;
            Class<?> returnType = method.getReturnType();
            if (returnType.isEnum()) {
                String ename = (String)otype;
                Enum[] constants = (Enum[])returnType.getEnumConstants();
                objectArray = constants;
                n2 = constants.length;
                n = 0;
                while (n < n2) {
                    Object c = objectArray[n];
                    if (((Enum)c).name().equals(ename)) {
                        return c;
                    }
                    ++n;
                }
            }
            if (List.class.isAssignableFrom(returnType)) {
                Object[] elems = (Object[])otype;
                ArrayList<Object> l = new ArrayList<Object>(elems.length);
                objectArray = elems;
                n2 = elems.length;
                n = 0;
                while (n < n2) {
                    Object elem = objectArray[n];
                    l.add(elem);
                    ++n;
                }
                return l;
            }
            if (Map.class.isAssignableFrom(returnType)) {
                TabularData data = (TabularData)otype;
                HashMap<Object, Object> m = new HashMap<Object, Object>(data.size());
                for (Object val : data.values()) {
                    CompositeData vals = (CompositeData)val;
                    m.put(vals.get("key"), vals.get("value"));
                }
                return m;
            }
            try {
                Method m = returnType.getMethod("from", CompositeData.class);
                return m.invoke(null, (CompositeData)otype);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return otype;
            }
        }
    }
}

