/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.classpath.Pair;
import gnu.classpath.VMStackWalker;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.SerializablePermission;
import java.io.StreamCorruptedException;
import java.io.VMObjectInputStream;
import java.io.WriteAbortedException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int BUFFER_SIZE = 1024;
    private DataInputStream realInputStream;
    private DataInputStream dataInputStream;
    private DataInputStream blockDataInput;
    private int blockDataPosition;
    private int blockDataBytes;
    private byte[] blockData;
    private boolean useSubclassMethod;
    private int nextOID;
    private boolean resolveEnabled;
    private Map<Integer, Pair<Boolean, Object>> handles;
    private Object currentObject;
    private ObjectStreamClass currentObjectStreamClass;
    private TreeSet<ValidatorAndPriority> currentObjectValidators;
    private boolean readDataFromBlock;
    private boolean fieldsAlreadyRead;
    private Hashtable<Class, ObjectStreamClass> classLookupTable;
    private GetField prereadFields;
    private static boolean dump;
    private int depth = 0;
    private static final boolean DEBUG = false;

    public ObjectInputStream(InputStream in) throws IOException, StreamCorruptedException {
        this.resolveEnabled = false;
        this.blockDataPosition = 0;
        this.blockDataBytes = 0;
        this.blockData = new byte[1024];
        this.blockDataInput = new DataInputStream(this);
        this.realInputStream = new DataInputStream(in);
        this.nextOID = 0x7E0000;
        this.handles = new HashMap<Integer, Pair<Boolean, Object>>();
        this.classLookupTable = new Hashtable();
        this.setBlockDataMode(true);
        this.readStreamHeader();
    }

    @Override
    public final Object readObject() throws ClassNotFoundException, IOException {
        return this.readObject(true);
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        return this.readObject(false);
    }

    private final Object readObject(boolean shared) throws ClassNotFoundException, IOException {
        Object ret_val;
        if (this.useSubclassMethod) {
            return this.readObjectOverride();
        }
        boolean old_mode = this.setBlockDataMode(false);
        byte marker = this.realInputStream.readByte();
        if (dump) {
            this.dumpElement("MARKER: 0x" + Integer.toHexString(marker) + " ");
        }
        try {
            ret_val = this.parseContent(marker, shared);
        }
        finally {
            this.setBlockDataMode(old_mode);
        }
        return ret_val;
    }

    private Object parseContent(byte marker, boolean shared) throws ClassNotFoundException, IOException {
        Object ret_val;
        boolean is_consumed = false;
        switch (marker) {
            case 120: {
                ret_val = null;
                is_consumed = true;
                break;
            }
            case 119: 
            case 122: {
                if (marker == 122) {
                    if (dump) {
                        this.dumpElementln("BLOCKDATALONG");
                    }
                } else if (dump) {
                    this.dumpElementln("BLOCKDATA");
                }
                this.readNextBlock(marker);
            }
            case 112: {
                if (dump) {
                    this.dumpElementln("NULL");
                }
                ret_val = null;
                break;
            }
            case 113: {
                if (dump) {
                    this.dumpElement("REFERENCE ");
                }
                int oid = this.realInputStream.readInt();
                if (dump) {
                    this.dumpElementln(Integer.toHexString(oid));
                }
                ret_val = this.lookupHandle(oid);
                if (shared) break;
                throw new InvalidObjectException("References can not be read unshared.");
            }
            case 118: {
                if (dump) {
                    this.dumpElementln("CLASS");
                }
                ObjectStreamClass osc = (ObjectStreamClass)this.readObject();
                Class<?> clazz = osc.forClass();
                this.assignNewHandle(clazz, shared);
                ret_val = clazz;
                break;
            }
            case 125: {
                if (dump) {
                    this.dumpElementln("PROXYCLASS");
                }
                int handle = this.assignNewHandle("Dummy proxy", shared);
                int n_intf = this.realInputStream.readInt();
                String[] intfs = new String[n_intf];
                int i = 0;
                while (i < n_intf) {
                    intfs[i] = this.realInputStream.readUTF();
                    ++i;
                }
                boolean oldmode = this.setBlockDataMode(true);
                Class<?> cl = this.resolveProxyClass(intfs);
                this.setBlockDataMode(oldmode);
                ObjectStreamClass osc = this.lookupClass(cl);
                if (osc.firstNonSerializableParentConstructor == null) {
                    osc.realClassIsSerializable = true;
                    osc.fieldMapping = new ObjectStreamField[0];
                    osc.fields = osc.fieldMapping;
                    try {
                        osc.firstNonSerializableParentConstructor = Object.class.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException x) {
                        throw (InternalError)new InternalError("Object ctor missing").initCause(x);
                    }
                }
                this.rememberHandle(osc, shared, handle);
                if (!is_consumed) {
                    byte b = this.realInputStream.readByte();
                    if (b != 120) {
                        throw new IOException("Data annotated to class was not consumed." + b);
                    }
                } else {
                    is_consumed = false;
                }
                ObjectStreamClass superosc = (ObjectStreamClass)this.readObject();
                osc.setSuperclass(superosc);
                ret_val = osc;
                break;
            }
            case 114: {
                ObjectStreamClass osc = this.readClassDescriptor();
                if (!is_consumed) {
                    byte b = this.realInputStream.readByte();
                    if (b != 120) {
                        throw new IOException("Data annotated to class was not consumed." + b);
                    }
                } else {
                    is_consumed = false;
                }
                osc.setSuperclass((ObjectStreamClass)this.readObject());
                ret_val = osc;
                break;
            }
            case 116: {
                if (dump) {
                    this.dumpElement("STRING=");
                }
                String s = this.realInputStream.readUTF();
                if (dump) {
                    this.dumpElementln(s);
                }
                ret_val = this.processResolution(null, s, this.assignNewHandle(s, shared), shared);
                break;
            }
            case 124: {
                if (dump) {
                    this.dumpElement("STRING=");
                }
                String s = this.realInputStream.readUTFLong();
                if (dump) {
                    this.dumpElementln(s);
                }
                ret_val = this.processResolution(null, s, this.assignNewHandle(s, shared), shared);
                break;
            }
            case 117: {
                if (dump) {
                    this.dumpElementln("ARRAY");
                }
                ObjectStreamClass osc = (ObjectStreamClass)this.readObject();
                Class<?> componentType = osc.forClass().getComponentType();
                if (dump) {
                    this.dumpElement("ARRAY LENGTH=");
                }
                int length = this.realInputStream.readInt();
                if (dump) {
                    this.dumpElementln(String.valueOf(length) + "; COMPONENT TYPE=" + componentType);
                }
                Object array = Array.newInstance(componentType, length);
                int handle = this.assignNewHandle(array, shared);
                this.readArrayElements(array, componentType);
                if (dump) {
                    int i = 0;
                    int len = Array.getLength(array);
                    while (i < len) {
                        this.dumpElementln("  ELEMENT[" + i + "]=", Array.get(array, i));
                        ++i;
                    }
                }
                ret_val = this.processResolution(null, array, handle, shared);
                break;
            }
            case 115: {
                if (dump) {
                    this.dumpElementln("OBJECT");
                }
                ObjectStreamClass osc = (ObjectStreamClass)this.readObject();
                Class<?> clazz = osc.forClass();
                if (!osc.realClassIsSerializable) {
                    throw new NotSerializableException(clazz + " is not Serializable, and thus cannot be deserialized.");
                }
                if (osc.realClassIsExternalizable) {
                    Externalizable obj = osc.newInstance();
                    int handle = this.assignNewHandle(obj, shared);
                    boolean read_from_blocks = (osc.getFlags() & 8) != 0;
                    boolean oldmode = this.readDataFromBlock;
                    if (read_from_blocks) {
                        this.setBlockDataMode(true);
                    }
                    obj.readExternal(this);
                    if (read_from_blocks) {
                        this.setBlockDataMode(oldmode);
                        if (!oldmode && this.realInputStream.readByte() != 120) {
                            throw new IOException("No end of block data seen for class with readExternal (ObjectInputStream) method.");
                        }
                    }
                    ret_val = this.processResolution(osc, obj, handle, shared);
                    break;
                }
                Object obj = this.newObject(clazz, osc.firstNonSerializableParentConstructor);
                int handle = this.assignNewHandle(obj, shared);
                Object prevObject = this.currentObject;
                ObjectStreamClass prevObjectStreamClass = this.currentObjectStreamClass;
                TreeSet<ValidatorAndPriority> prevObjectValidators = this.currentObjectValidators;
                this.currentObject = obj;
                this.currentObjectValidators = null;
                ObjectStreamClass[] hierarchy = this.hierarchy(clazz);
                int i = 0;
                while (i < hierarchy.length) {
                    Method readObjectMethod;
                    this.currentObjectStreamClass = hierarchy[i];
                    if (dump) {
                        this.dumpElementln("Reading fields of " + this.currentObjectStreamClass.getName());
                    }
                    if ((readObjectMethod = this.currentObjectStreamClass.readObjectMethod) != null) {
                        this.fieldsAlreadyRead = false;
                        boolean oldmode = this.setBlockDataMode(true);
                        this.callReadMethod(readObjectMethod, this.currentObjectStreamClass.forClass(), obj);
                        this.setBlockDataMode(oldmode);
                    } else {
                        this.readFields(obj, this.currentObjectStreamClass);
                    }
                    if (this.currentObjectStreamClass.hasWriteMethod()) {
                        if (dump) {
                            this.dumpElement("ENDBLOCKDATA? ");
                        }
                        try {
                            byte writeMarker = this.realInputStream.readByte();
                            while (writeMarker != 120) {
                                this.parseContent(writeMarker, shared);
                                writeMarker = this.realInputStream.readByte();
                            }
                            if (dump) {
                                this.dumpElementln("yes");
                            }
                        }
                        catch (EOFException e) {
                            throw (IOException)new IOException("No end of block data seen for class with readObject (ObjectInputStream) method.").initCause(e);
                        }
                    }
                    ++i;
                }
                this.currentObject = prevObject;
                this.currentObjectStreamClass = prevObjectStreamClass;
                ret_val = this.processResolution(osc, obj, handle, shared);
                if (this.currentObjectValidators != null) {
                    this.invokeValidators();
                }
                this.currentObjectValidators = prevObjectValidators;
                break;
            }
            case 121: {
                if (dump) {
                    this.dumpElementln("RESET");
                }
                this.clearHandles();
                ret_val = this.readObject();
                break;
            }
            case 123: {
                if (dump) {
                    this.dumpElement("EXCEPTION=");
                }
                Exception e = (Exception)this.readObject();
                if (dump) {
                    this.dumpElementln(e.toString());
                }
                this.clearHandles();
                throw new WriteAbortedException("Exception thrown during writing of stream", e);
            }
            case 126: {
                if (dump) {
                    this.dumpElementln("ENUM=");
                }
                ObjectStreamClass osc = (ObjectStreamClass)this.readObject();
                int enumHandle = this.assignNewHandle(null, shared);
                String constantName = (String)this.readObject();
                if (dump) {
                    this.dumpElementln("CONSTANT NAME = " + constantName);
                }
                Class<?> clazz = osc.forClass();
                Object instance = Enum.valueOf(clazz, constantName);
                this.rememberHandle(instance, shared, enumHandle);
                ret_val = instance;
                break;
            }
            default: {
                throw new IOException("Unknown marker on stream: " + marker);
            }
        }
        return ret_val;
    }

    private void checkTypeConsistency(String name, ObjectStreamField[] fields1, ObjectStreamField[] fields2) throws InvalidClassException {
        int nonPrimitive = 0;
        nonPrimitive = 0;
        while (nonPrimitive < fields1.length && fields1[nonPrimitive].isPrimitive()) {
            ++nonPrimitive;
        }
        if (nonPrimitive == fields1.length) {
            return;
        }
        int i = 0;
        while (i < fields2.length && nonPrimitive < fields1.length) {
            ObjectStreamField f1 = fields1[nonPrimitive];
            ObjectStreamField f2 = fields2[i];
            if (!f2.isPrimitive()) break;
            int compVal = f1.getName().compareTo(f2.getName());
            if (compVal < 0) {
                ++nonPrimitive;
                continue;
            }
            if (compVal > 0) {
                ++i;
                continue;
            }
            throw new InvalidClassException("invalid field type for " + f2.getName() + " in class " + name);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected ObjectStreamClass readClassDescriptor() throws ClassNotFoundException, IOException {
        block22: {
            if (ObjectInputStream.dump) {
                this.dumpElement("CLASSDESC NAME=");
            }
            name = this.realInputStream.readUTF();
            if (ObjectInputStream.dump) {
                this.dumpElement(String.valueOf(name) + "; UID=");
            }
            uid = this.realInputStream.readLong();
            if (ObjectInputStream.dump) {
                this.dumpElement(String.valueOf(Long.toHexString(uid)) + "; FLAGS=");
            }
            flags = this.realInputStream.readByte();
            if (ObjectInputStream.dump) {
                this.dumpElement(String.valueOf(Integer.toHexString(flags)) + "; FIELD COUNT=");
            }
            field_count = this.realInputStream.readShort();
            if (ObjectInputStream.dump) {
                this.dumpElementln(Short.toString((short)field_count));
            }
            fields = new ObjectStreamField[field_count];
            osc = new ObjectStreamClass(name, uid, flags, fields);
            this.assignNewHandle(osc, true);
            i = 0;
            while (i < field_count) {
                if (ObjectInputStream.dump) {
                    this.dumpElement("  TYPE CODE=");
                }
                type_code = (char)this.realInputStream.readByte();
                if (ObjectInputStream.dump) {
                    this.dumpElement(String.valueOf(type_code) + "; FIELD NAME=");
                }
                field_name = this.realInputStream.readUTF();
                if (ObjectInputStream.dump) {
                    this.dumpElementln(field_name);
                }
                class_name = type_code == 'L' || type_code == '[' ? (String)this.readObject() : String.valueOf(type_code);
                fields[i] = new ObjectStreamField(field_name, class_name);
                ++i;
            }
            clazz = this.resolveClass(osc);
            loader = clazz.getClassLoader();
            i = 0;
            while (i < field_count) {
                fields[i].resolveType(loader);
                ++i;
            }
            oldmode = this.setBlockDataMode(true);
            osc.setClass(clazz, this.lookupClass(clazz.getSuperclass()));
            this.classLookupTable.put(clazz, osc);
            this.setBlockDataMode(oldmode);
            first_nonserial = clazz.getSuperclass();
            if (first_nonserial != null) ** GOTO lbl51
            first_nonserial = clazz;
            break block22;
lbl-1000:
            // 1 sources

            {
                first_nonserial = first_nonserial.getSuperclass();
lbl51:
                // 2 sources

                ** while (Serializable.class.isAssignableFrom(first_nonserial))
            }
        }
        local_constructor_class = first_nonserial;
        osc.firstNonSerializableParentConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Constructor c;
                block3: {
                    try {
                        c = local_constructor_class.getDeclaredConstructor(new Class[0]);
                        if (!Modifier.isPrivate(c.getModifiers())) break block3;
                        return null;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        return null;
                    }
                }
                return c;
            }
        });
        osc.realClassIsSerializable = Serializable.class.isAssignableFrom(clazz);
        osc.realClassIsExternalizable = Externalizable.class.isAssignableFrom(clazz);
        stream_fields = osc.fields;
        real_fields = ObjectStreamClass.lookupForClassObject(clazz).fields;
        fieldmapping = new ObjectStreamField[2 * Math.max(stream_fields.length, real_fields.length)];
        stream_idx = 0;
        real_idx = 0;
        map_idx = 0;
        this.checkTypeConsistency(name, real_fields, stream_fields);
        this.checkTypeConsistency(name, stream_fields, real_fields);
        while (stream_idx < stream_fields.length || real_idx < real_fields.length) {
            stream_field = null;
            real_field = null;
            if (stream_idx == stream_fields.length) {
                real_field = real_fields[real_idx++];
            } else if (real_idx == real_fields.length) {
                stream_field = stream_fields[stream_idx++];
            } else {
                comp_val = real_fields[real_idx].compareTo(stream_fields[stream_idx]);
                if (comp_val < 0) {
                    real_field = real_fields[real_idx++];
                } else if (comp_val > 0) {
                    stream_field = stream_fields[stream_idx++];
                } else {
                    stream_field = stream_fields[stream_idx++];
                    real_field = real_fields[real_idx++];
                    if (stream_field.getType() != real_field.getType()) {
                        throw new InvalidClassException("invalid field type for " + real_field.getName() + " in class " + name);
                    }
                }
            }
            if (map_idx == fieldmapping.length) {
                newfieldmapping = new ObjectStreamField[fieldmapping.length + 2];
                System.arraycopy(fieldmapping, 0, newfieldmapping, 0, fieldmapping.length);
                fieldmapping = newfieldmapping;
            }
            fieldmapping[map_idx++] = stream_field;
            fieldmapping[map_idx++] = real_field;
        }
        osc.fieldMapping = fieldmapping;
        return osc;
    }

    public void defaultReadObject() throws ClassNotFoundException, IOException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("defaultReadObject called by non-active class and/or object");
        }
        if (this.fieldsAlreadyRead) {
            throw new NotActiveException("defaultReadObject called but fields already read from stream (by defaultReadObject or readFields)");
        }
        boolean oldmode = this.setBlockDataMode(false);
        this.readFields(this.currentObject, this.currentObjectStreamClass);
        this.setBlockDataMode(oldmode);
        this.fieldsAlreadyRead = true;
    }

    public void registerValidation(ObjectInputValidation validator, int priority) throws InvalidObjectException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("registerValidation called by non-active class and/or object");
        }
        if (validator == null) {
            throw new InvalidObjectException("attempt to add a null ObjectInputValidation object");
        }
        if (this.currentObjectValidators == null) {
            this.currentObjectValidators = new TreeSet();
        }
        this.currentObjectValidators.add(new ValidatorAndPriority(validator, priority));
    }

    protected Class<?> resolveClass(ObjectStreamClass osc) throws ClassNotFoundException, IOException {
        String name = osc.getName();
        try {
            return Class.forName(name, true, this.currentLoader());
        }
        catch (ClassNotFoundException x) {
            if (name.equals("void")) {
                return Void.TYPE;
            }
            if (name.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (name.equals("byte")) {
                return Byte.TYPE;
            }
            if (name.equals("char")) {
                return Character.TYPE;
            }
            if (name.equals("short")) {
                return Short.TYPE;
            }
            if (name.equals("int")) {
                return Integer.TYPE;
            }
            if (name.equals("long")) {
                return Long.TYPE;
            }
            if (name.equals("float")) {
                return Float.TYPE;
            }
            if (name.equals("double")) {
                return Double.TYPE;
            }
            throw x;
        }
    }

    private ClassLoader currentLoader() {
        return VMStackWalker.firstNonNullClassLoader();
    }

    private ObjectStreamClass lookupClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ObjectStreamClass oclazz = this.classLookupTable.get(clazz);
        if (oclazz == null) {
            return ObjectStreamClass.lookup(clazz);
        }
        return oclazz;
    }

    private ObjectStreamClass[] hierarchy(Class clazz) {
        ObjectStreamClass osc = this.lookupClass(clazz);
        return osc == null ? new ObjectStreamClass[]{} : osc.hierarchy();
    }

    protected Object resolveObject(Object obj) throws IOException {
        return obj;
    }

    protected Class<?> resolveProxyClass(String[] intfs) throws IOException, ClassNotFoundException {
        int i;
        ClassLoader cl = this.currentLoader();
        Class[] clss = new Class[intfs.length];
        if (cl == null) {
            i = 0;
            while (i < intfs.length) {
                clss[i] = Class.forName(intfs[i]);
                ++i;
            }
            cl = ClassLoader.getSystemClassLoader();
        } else {
            i = 0;
            while (i < intfs.length) {
                clss[i] = Class.forName(intfs[i], false, cl);
                ++i;
            }
        }
        try {
            return Proxy.getProxyClass(cl, clss);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    protected boolean enableResolveObject(boolean enable) throws SecurityException {
        SecurityManager sm;
        if (enable && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SerializablePermission("enableSubstitution"));
        }
        boolean old_val = this.resolveEnabled;
        this.resolveEnabled = enable;
        return old_val;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        if (dump) {
            this.dumpElement("STREAM MAGIC ");
        }
        if (this.realInputStream.readShort() != -21267) {
            throw new StreamCorruptedException("Invalid stream magic number");
        }
        if (dump) {
            this.dumpElementln("STREAM VERSION ");
        }
        if (this.realInputStream.readShort() != 5) {
            throw new StreamCorruptedException("Invalid stream version number");
        }
    }

    @Override
    public int read() throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition >= this.blockDataBytes) {
                this.readNextBlock();
            }
            return this.blockData[this.blockDataPosition++] & 0xFF;
        }
        return this.realInputStream.read();
    }

    @Override
    public int read(byte[] data, int offset, int length) throws IOException {
        if (this.readDataFromBlock) {
            int remain = this.blockDataBytes - this.blockDataPosition;
            if (remain == 0) {
                this.readNextBlock();
                remain = this.blockDataBytes - this.blockDataPosition;
            }
            length = Math.min(length, remain);
            System.arraycopy(this.blockData, this.blockDataPosition, data, offset, length);
            this.blockDataPosition += length;
            return length;
        }
        return this.realInputStream.read(data, offset, length);
    }

    @Override
    public int available() throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition >= this.blockDataBytes) {
                this.readNextBlock();
            }
            return this.blockDataBytes - this.blockDataPosition;
        }
        return this.realInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.realInputStream.close();
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 1) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        boolean value = this.dataInputStream.readBoolean();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    @Override
    public byte readByte() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 1) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        byte value = this.dataInputStream.readByte();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 1) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        int value = this.dataInputStream.readUnsignedByte();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    @Override
    public short readShort() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 2) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        short value = this.dataInputStream.readShort();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 2) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        int value = this.dataInputStream.readUnsignedShort();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    @Override
    public char readChar() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 2) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        char value = this.dataInputStream.readChar();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    @Override
    public int readInt() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 4) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        int value = this.dataInputStream.readInt();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    @Override
    public long readLong() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 8) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        long value = this.dataInputStream.readLong();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    @Override
    public float readFloat() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 4) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        float value = this.dataInputStream.readFloat();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    @Override
    public double readDouble() throws IOException {
        boolean switchmode = true;
        boolean oldmode = this.readDataFromBlock;
        if (!oldmode || this.blockDataBytes - this.blockDataPosition >= 8) {
            switchmode = false;
        }
        if (switchmode) {
            oldmode = this.setBlockDataMode(true);
        }
        double value = this.dataInputStream.readDouble();
        if (switchmode) {
            this.setBlockDataMode(oldmode);
        }
        return value;
    }

    @Override
    public void readFully(byte[] data) throws IOException {
        this.dataInputStream.readFully(data);
    }

    @Override
    public void readFully(byte[] data, int offset, int size) throws IOException {
        this.dataInputStream.readFully(data, offset, size);
    }

    @Override
    public int skipBytes(int len) throws IOException {
        return this.dataInputStream.skipBytes(len);
    }

    @Override
    public String readLine() throws IOException {
        return this.dataInputStream.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.dataInputStream.readUTF();
    }

    public GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("readFields called by non-active class and/or object");
        }
        if (this.prereadFields != null) {
            return this.prereadFields;
        }
        if (this.fieldsAlreadyRead) {
            throw new NotActiveException("readFields called but fields already read from stream (by defaultReadObject or readFields)");
        }
        final ObjectStreamClass clazz = this.currentObjectStreamClass;
        final byte[] prim_field_data = new byte[clazz.primFieldSize];
        final Object[] objs = new Object[clazz.objectFieldCount];
        boolean oldmode = this.setBlockDataMode(false);
        this.readFully(prim_field_data);
        int i = 0;
        while (i < objs.length) {
            objs[i] = this.readObject();
            ++i;
        }
        this.setBlockDataMode(oldmode);
        this.prereadFields = new GetField(){

            public ObjectStreamClass getObjectStreamClass() {
                return clazz;
            }

            public boolean defaulted(String name) throws IOException, IllegalArgumentException {
                ObjectStreamField f = clazz.getField(name);
                if (f != null) {
                    return f.isPersistent() && !f.isToSet();
                }
                try {
                    return clazz.forClass().getDeclaredField(name) != null;
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            public boolean get(String name, boolean defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Boolean.TYPE);
                if (field == null) {
                    return defvalue;
                }
                return prim_field_data[field.getOffset()] != 0;
            }

            public char get(String name, char defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Character.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return (char)((prim_field_data[off++] & 0xFF) << 8 | prim_field_data[off] & 0xFF);
            }

            public byte get(String name, byte defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Byte.TYPE);
                if (field == null) {
                    return defvalue;
                }
                return prim_field_data[field.getOffset()];
            }

            public short get(String name, short defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Short.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return (short)((prim_field_data[off++] & 0xFF) << 8 | prim_field_data[off] & 0xFF);
            }

            public int get(String name, int defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Integer.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return (prim_field_data[off++] & 0xFF) << 24 | (prim_field_data[off++] & 0xFF) << 16 | (prim_field_data[off++] & 0xFF) << 8 | prim_field_data[off] & 0xFF;
            }

            public long get(String name, long defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Long.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return ((long)prim_field_data[off++] & 0xFFL) << 56 | ((long)prim_field_data[off++] & 0xFFL) << 48 | ((long)prim_field_data[off++] & 0xFFL) << 40 | ((long)prim_field_data[off++] & 0xFFL) << 32 | (long)((prim_field_data[off++] & 0xFF) << 24) | (long)((prim_field_data[off++] & 0xFF) << 16) | (long)((prim_field_data[off++] & 0xFF) << 8) | (long)(prim_field_data[off] & 0xFF);
            }

            public float get(String name, float defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Float.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return Float.intBitsToFloat((prim_field_data[off++] & 0xFF) << 24 | (prim_field_data[off++] & 0xFF) << 16 | (prim_field_data[off++] & 0xFF) << 8 | prim_field_data[off] & 0xFF);
            }

            public double get(String name, double defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Double.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return Double.longBitsToDouble(((long)prim_field_data[off++] & 0xFFL) << 56 | ((long)prim_field_data[off++] & 0xFFL) << 48 | ((long)prim_field_data[off++] & 0xFFL) << 40 | ((long)prim_field_data[off++] & 0xFFL) << 32 | (long)((prim_field_data[off++] & 0xFF) << 24) | (long)((prim_field_data[off++] & 0xFF) << 16) | (long)((prim_field_data[off++] & 0xFF) << 8) | (long)(prim_field_data[off] & 0xFF));
            }

            public Object get(String name, Object defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, defvalue == null ? null : defvalue.getClass());
                if (field == null) {
                    return defvalue;
                }
                return objs[field.getOffset()];
            }

            private ObjectStreamField getField(String name, Class type) throws IllegalArgumentException {
                Class<?> field_type;
                boolean illegal;
                ObjectStreamField field;
                block19: {
                    ObjectStreamField objectStreamField;
                    block20: {
                        field = clazz.getField(name);
                        illegal = false;
                        field_type = field.getType();
                        if (type != field_type && (type != null || field_type.isPrimitive())) break block19;
                        objectStreamField = field;
                        if (!illegal && field != null && !field.isToSet() && field.isPersistent()) {
                            return null;
                        }
                        try {
                            Field f = clazz.forClass().getDeclaredField(name);
                            if (Modifier.isTransient(f.getModifiers())) {
                                throw new IllegalArgumentException("no such field (non transient) " + name);
                            }
                            if (field == null && f.getType() != type) {
                                throw new IllegalArgumentException("Invalid requested type for field " + name);
                            }
                        }
                        catch (NoSuchFieldException e) {
                            if (field != null) break block20;
                            throw new IllegalArgumentException(e);
                        }
                    }
                    return objectStreamField;
                }
                try {
                    try {
                        illegal = true;
                        throw new IllegalArgumentException("Field requested is of type " + field_type.getName() + ", but requested type was " + (type == null ? "Object" : type.getName()));
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (IllegalArgumentException e) {
                        throw e;
                    }
                    return null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block22: {
                        if (!illegal && field != null && !field.isToSet() && field.isPersistent()) {
                            return null;
                        }
                        try {
                            Field f = clazz.forClass().getDeclaredField(name);
                            if (Modifier.isTransient(f.getModifiers())) {
                                throw new IllegalArgumentException("no such field (non transient) " + name);
                            }
                            if (field == null && f.getType() != type) {
                                throw new IllegalArgumentException("Invalid requested type for field " + name);
                            }
                        }
                        catch (NoSuchFieldException e) {
                            if (field != null) break block22;
                            throw new IllegalArgumentException(e);
                        }
                    }
                }
            }
        };
        this.fieldsAlreadyRead = true;
        return this.prereadFields;
    }

    protected ObjectInputStream() throws IOException, SecurityException {
        SecurityManager sec_man = System.getSecurityManager();
        if (sec_man != null) {
            sec_man.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.useSubclassMethod = true;
    }

    protected Object readObjectOverride() throws ClassNotFoundException, IOException, OptionalDataException {
        throw new IOException("Subclass of ObjectInputStream must implement readObjectOverride");
    }

    private int assignNewHandle(Object obj, boolean shared) {
        int handle = this.nextOID;
        this.nextOID = handle + 1;
        this.rememberHandle(obj, shared, handle);
        return handle;
    }

    private void rememberHandle(Object obj, boolean shared, int handle) {
        this.handles.put(handle, new Pair<Boolean, Object>(shared, obj));
    }

    private Object lookupHandle(int handle) throws ObjectStreamException {
        Pair<Boolean, Object> result = this.handles.get(handle);
        if (result == null) {
            throw new StreamCorruptedException("The handle, " + Integer.toHexString(handle) + ", is invalid.");
        }
        if (!result.getLeft().booleanValue()) {
            throw new InvalidObjectException("The handle, " + Integer.toHexString(handle) + ", is not shared.");
        }
        return result.getRight();
    }

    private Object processResolution(ObjectStreamClass osc, Object obj, int handle, boolean shared) throws IOException {
        block18: {
            if (osc != null && obj instanceof Serializable) {
                try {
                    Method m = osc.readResolveMethod;
                    if (m != null) {
                        obj = m.invoke(obj, new Object[0]);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException exception) {
                    Throwable cause = exception.getCause();
                    if (cause instanceof ObjectStreamException) {
                        throw (ObjectStreamException)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (!(cause instanceof Error)) break block18;
                    throw (Error)cause;
                }
            }
        }
        if (this.resolveEnabled) {
            obj = this.resolveObject(obj);
        }
        this.rememberHandle(obj, shared, handle);
        if (!shared) {
            if (obj instanceof byte[]) {
                return ((byte[])obj).clone();
            }
            if (obj instanceof short[]) {
                return ((short[])obj).clone();
            }
            if (obj instanceof int[]) {
                return ((int[])obj).clone();
            }
            if (obj instanceof long[]) {
                return ((long[])obj).clone();
            }
            if (obj instanceof char[]) {
                return ((char[])obj).clone();
            }
            if (obj instanceof boolean[]) {
                return ((boolean[])obj).clone();
            }
            if (obj instanceof float[]) {
                return ((float[])obj).clone();
            }
            if (obj instanceof double[]) {
                return ((double[])obj).clone();
            }
            if (obj instanceof Object[]) {
                return ((Object[])obj).clone();
            }
        }
        return obj;
    }

    private void clearHandles() {
        this.handles.clear();
        this.nextOID = 0x7E0000;
    }

    private void readNextBlock() throws IOException {
        byte marker = this.realInputStream.readByte();
        while (marker == 121) {
            if (dump) {
                this.dumpElementln("RESET");
            }
            this.clearHandles();
            marker = this.realInputStream.readByte();
        }
        this.readNextBlock(marker);
    }

    private void readNextBlock(byte marker) throws IOException {
        if (marker == 119) {
            if (dump) {
                this.dumpElement("BLOCK DATA SIZE=");
            }
            this.blockDataBytes = this.realInputStream.readUnsignedByte();
            if (dump) {
                this.dumpElementln(Integer.toString(this.blockDataBytes));
            }
        } else if (marker == 122) {
            if (dump) {
                this.dumpElement("BLOCK DATA LONG SIZE=");
            }
            this.blockDataBytes = this.realInputStream.readInt();
            if (dump) {
                this.dumpElementln(Integer.toString(this.blockDataBytes));
            }
        } else {
            throw new EOFException("Attempt to read primitive data, but no data block is active.");
        }
        if (this.blockData.length < this.blockDataBytes) {
            this.blockData = new byte[this.blockDataBytes];
        }
        this.realInputStream.readFully(this.blockData, 0, this.blockDataBytes);
        this.blockDataPosition = 0;
    }

    private void readArrayElements(Object array, Class clazz) throws ClassNotFoundException, IOException {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                boolean[] cast_array = (boolean[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readBoolean();
                    ++i;
                }
                return;
            }
            if (clazz == Byte.TYPE) {
                byte[] cast_array = (byte[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readByte();
                    ++i;
                }
                return;
            }
            if (clazz == Character.TYPE) {
                char[] cast_array = (char[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readChar();
                    ++i;
                }
                return;
            }
            if (clazz == Double.TYPE) {
                double[] cast_array = (double[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readDouble();
                    ++i;
                }
                return;
            }
            if (clazz == Float.TYPE) {
                float[] cast_array = (float[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readFloat();
                    ++i;
                }
                return;
            }
            if (clazz == Integer.TYPE) {
                int[] cast_array = (int[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readInt();
                    ++i;
                }
                return;
            }
            if (clazz == Long.TYPE) {
                long[] cast_array = (long[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readLong();
                    ++i;
                }
                return;
            }
            if (clazz == Short.TYPE) {
                short[] cast_array = (short[])array;
                int i = 0;
                while (i < cast_array.length) {
                    cast_array[i] = this.realInputStream.readShort();
                    ++i;
                }
                return;
            }
        } else {
            Object[] cast_array = (Object[])array;
            int i = 0;
            while (i < cast_array.length) {
                cast_array[i] = this.readObject();
                ++i;
            }
        }
    }

    private void readFields(Object obj, ObjectStreamClass stream_osc) throws ClassNotFoundException, IOException {
        ObjectStreamField[] fields = stream_osc.fieldMapping;
        int i = 0;
        while (i < fields.length) {
            char type;
            String field_name;
            boolean set_value;
            ObjectStreamField stream_field = fields[i];
            ObjectStreamField real_field = fields[i + 1];
            boolean read_value = stream_field != null && stream_field.getOffset() >= 0 && stream_field.isToSet();
            boolean bl = set_value = real_field != null && real_field.isToSet();
            if (stream_field != null) {
                field_name = stream_field.getName();
                type = stream_field.getTypeCode();
            } else {
                field_name = real_field.getName();
                type = real_field.getTypeCode();
            }
            switch (type) {
                case 'Z': {
                    boolean value;
                    boolean bl2 = value = read_value ? this.realInputStream.readBoolean() : false;
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setBooleanField(obj, value);
                    break;
                }
                case 'B': {
                    byte value;
                    byte by = value = read_value ? this.realInputStream.readByte() : (byte)0;
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setByteField(obj, value);
                    break;
                }
                case 'C': {
                    char value;
                    char c = value = read_value ? this.realInputStream.readChar() : (char)'\u0000';
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setCharField(obj, value);
                    break;
                }
                case 'D': {
                    double value;
                    double d = value = read_value ? this.realInputStream.readDouble() : 0.0;
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setDoubleField(obj, value);
                    break;
                }
                case 'F': {
                    float value;
                    float f = value = read_value ? this.realInputStream.readFloat() : 0.0f;
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setFloatField(obj, value);
                    break;
                }
                case 'I': {
                    int value;
                    int n = value = read_value ? this.realInputStream.readInt() : 0;
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setIntField(obj, value);
                    break;
                }
                case 'J': {
                    long value;
                    long l = value = read_value ? this.realInputStream.readLong() : 0L;
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setLongField(obj, value);
                    break;
                }
                case 'S': {
                    short value;
                    short s = value = read_value ? this.realInputStream.readShort() : (short)0;
                    if (dump && read_value && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value);
                    }
                    if (!set_value) break;
                    real_field.setShortField(obj, value);
                    break;
                }
                case 'L': 
                case '[': {
                    Object value;
                    Object object = value = read_value ? this.readObject() : null;
                    if (!set_value) break;
                    real_field.setObjectField(obj, value);
                    break;
                }
                default: {
                    throw new InternalError("Invalid type code: " + type);
                }
            }
            i += 2;
        }
    }

    private boolean setBlockDataMode(boolean on) {
        boolean oldmode = this.readDataFromBlock;
        this.readDataFromBlock = on;
        this.dataInputStream = on ? this.blockDataInput : this.realInputStream;
        return oldmode;
    }

    private Object newObject(Class real_class, Constructor constructor) throws ClassNotFoundException, IOException {
        if (constructor == null) {
            throw new InvalidClassException("Missing accessible no-arg base class constructor for " + real_class.getName());
        }
        try {
            return VMObjectInputStream.allocateObject(real_class, constructor.getDeclaringClass(), constructor);
        }
        catch (InstantiationException e) {
            throw (ClassNotFoundException)new ClassNotFoundException("Instance of " + real_class + " could not be created").initCause(e);
        }
    }

    private void invokeValidators() throws InvalidObjectException {
        try {
            for (ValidatorAndPriority vap : this.currentObjectValidators) {
                ObjectInputValidation validator = vap.validator;
                validator.validateObject();
            }
        }
        finally {
            this.currentObjectValidators = null;
        }
    }

    private void callReadMethod(Method readObject, Class klass, Object obj) throws ClassNotFoundException, IOException {
        try {
            readObject.invoke(obj, this);
        }
        catch (InvocationTargetException x) {
            Throwable exception = x.getTargetException();
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exception;
            }
            throw (IOException)new IOException("Exception thrown from readObject() on " + klass).initCause(x);
        }
        catch (Exception x) {
            throw (IOException)new IOException("Failure invoking readObject() on " + klass).initCause(x);
        }
        this.prereadFields = null;
    }

    private void dumpElement(String msg) {
        System.out.print(msg);
    }

    private void dumpElementln(String msg) {
        System.out.println(msg);
        int i = 0;
        while (i < this.depth) {
            System.out.print(" ");
            ++i;
        }
        System.out.print(Thread.currentThread() + ": ");
    }

    private void dumpElementln(String msg, Object obj) {
        try {
            System.out.print(msg);
            if (Proxy.isProxyClass(obj.getClass())) {
                System.out.println(obj.getClass());
            } else {
                System.out.println(obj);
            }
        }
        catch (Exception exception) {}
        int i = 0;
        while (i < this.depth) {
            System.out.print(" ");
            ++i;
        }
        System.out.print(Thread.currentThread() + ": ");
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException, IllegalArgumentException;

        public abstract boolean get(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract char get(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract byte get(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract short get(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract int get(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract long get(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract float get(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract double get(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract Object get(String var1, Object var2) throws IOException, IllegalArgumentException;
    }

    private static final class ValidatorAndPriority
    implements Comparable {
        int priority;
        ObjectInputValidation validator;

        ValidatorAndPriority(ObjectInputValidation validator, int priority) {
            this.priority = priority;
            this.validator = validator;
        }

        public int compareTo(Object o) {
            ValidatorAndPriority vap = (ValidatorAndPriority)o;
            return this.priority - vap.priority;
        }
    }
}

