/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;

public class ICC_ProfileGray
extends ICC_Profile {
    private static final long serialVersionUID = -1124721290732002649L;
    private transient float[] whitePoint = this.getXYZData(0x77747074);

    ICC_ProfileGray(int cspace) {
        super(cspace);
    }

    ICC_ProfileGray(byte[] data) {
        super(data);
    }

    public float[] getMediaWhitePoint() {
        float[] wp = new float[]{this.whitePoint[0], this.whitePoint[1], this.whitePoint[2]};
        return wp;
    }

    public float getGamma() {
        short[] data = this.getCurve(1800688195);
        if (data == null) {
            throw new IllegalArgumentException("Couldn't read Gray TRC data.");
        }
        if (data.length != 1) {
            throw new ProfileDataException("TRC is a table, not a gamma value.");
        }
        double gamma = (double)(data[0] & 0xFFFF) / 256.0;
        return (float)gamma;
    }

    public short[] getTRC() {
        short[] data = this.getCurve(1800688195);
        if (data == null) {
            throw new IllegalArgumentException("Couldn't read Gray TRC data.");
        }
        if (data.length <= 1) {
            throw new ProfileDataException("Gamma value, not a TRC table.");
        }
        return data;
    }
}

