/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGChunk;
import gnu.javax.imageio.png.PNGException;

public class PNGPhys
extends PNGChunk {
    long x;
    long y;
    double ratio;
    boolean usesRatio;

    protected PNGPhys(int type, byte[] data, int crc) throws PNGException {
        super(type, data, crc);
        if (data.length < 9) {
            throw new PNGException("Unexpected size of pHYS chunk.");
        }
        this.x = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        this.y = (data[4] & 0xFF) << 24 | (data[5] & 0xFF) << 16 | (data[6] & 0xFF) << 8 | data[7] & 0xFF;
        if (data[8] == 0) {
            this.ratio = (double)this.x / (double)this.y;
            this.usesRatio = true;
        }
    }

    public PNGPhys(double ratio) {
        super(1883789683);
        this.ratio = ratio;
        this.usesRatio = true;
        if (ratio < 1.0) {
            this.y = -1L;
            this.x = (long)(4.294967295E9 * ratio);
        } else {
            this.x = -1L;
            this.y = (long)(4.294967295E9 * ratio);
        }
        this.makeData();
    }

    public PNGPhys(int x, int y) {
        super(1883789683);
        this.usesRatio = false;
        this.x = x;
        this.y = y;
        this.makeData();
    }

    private void makeData() {
        this.data = new byte[9];
        byte[] a = PNGPhys.getInt((int)this.x);
        byte[] b = PNGPhys.getInt((int)this.y);
        this.data[0] = a[0];
        this.data[1] = a[1];
        this.data[2] = a[2];
        this.data[3] = a[3];
        this.data[4] = b[0];
        this.data[5] = b[1];
        this.data[6] = b[2];
        this.data[7] = b[3];
        this.data[7] = this.usesRatio ? 0 : -1;
    }

    public String toString() {
        String s = "PNG Physical pixel size chunk.";
        if (this.usesRatio) {
            return String.valueOf(s) + " Aspect ratio (x/y): " + this.ratio;
        }
        return String.valueOf(s) + " " + this.x + " by " + this.y + " pixels per meter. (x, y).";
    }
}

