/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.prng;

import gnu.java.security.prng.BasePRNG;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.mac.IMac;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PBKDF2
extends BasePRNG
implements Cloneable {
    private byte[] in;
    private int iterationCount;
    private byte[] salt;
    private IMac mac;
    private long count;

    public PBKDF2(IMac mac) {
        super("PBKDF2-" + mac.name());
        this.mac = mac;
        this.iterationCount = -1;
    }

    public void setup(Map attributes) {
        byte[] macKeyMaterial;
        char[] password;
        HashMap<String, Object> macAttrib = new HashMap<String, Object>();
        macAttrib.put("gnu.crypto.hmac.pkcs5", Boolean.TRUE);
        byte[] s = (byte[])attributes.get("gnu.crypto.pbe.salt");
        if (s == null) {
            if (this.salt == null) {
                throw new IllegalArgumentException("no salt specified");
            }
        } else {
            this.salt = s;
        }
        if ((password = (char[])attributes.get("gnu.crypto.pbe.password")) != null) {
            String encoding = (String)attributes.get("gnu.crypto.pbe.password.encoding");
            encoding = encoding == null || encoding.trim().length() == 0 ? "UTF-8" : encoding.trim();
            try {
                macKeyMaterial = new String(password).getBytes(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalArgumentException("Unknown or unsupported encoding: " + encoding, uee);
            }
        } else {
            macKeyMaterial = (byte[])attributes.get("gnu.crypto.mac.key.material");
        }
        if (macKeyMaterial != null) {
            macAttrib.put("gnu.crypto.mac.key.material", macKeyMaterial);
        } else if (!this.initialised) {
            throw new IllegalArgumentException("Neither password nor key-material were specified");
        }
        try {
            this.mac.init(macAttrib);
        }
        catch (Exception x) {
            throw new IllegalArgumentException(x.getMessage());
        }
        Integer ic = (Integer)attributes.get("gnu.crypto.pbe.iteration.count");
        if (ic != null) {
            this.iterationCount = ic;
        }
        if (this.iterationCount <= 0) {
            throw new IllegalArgumentException("bad iteration count");
        }
        this.count = 0L;
        this.buffer = new byte[this.mac.macSize()];
        try {
            this.fillBlock();
        }
        catch (LimitReachedException x) {
            throw new Error(x.getMessage());
        }
    }

    public void fillBlock() throws LimitReachedException {
        if (++this.count > 0xFFFFFFFFL) {
            throw new LimitReachedException();
        }
        Arrays.fill(this.buffer, (byte)0);
        int limit = this.salt.length;
        this.in = new byte[limit + 4];
        System.arraycopy(this.salt, 0, this.in, 0, this.salt.length);
        this.in[limit++] = (byte)(this.count >>> 24);
        this.in[limit++] = (byte)(this.count >>> 16);
        this.in[limit++] = (byte)(this.count >>> 8);
        this.in[limit] = (byte)this.count;
        int i = 0;
        while (i < this.iterationCount) {
            this.mac.reset();
            this.mac.update(this.in, 0, this.in.length);
            this.in = this.mac.digest();
            int j = 0;
            while (j < this.buffer.length) {
                int n = j;
                this.buffer[n] = (byte)(this.buffer[n] ^ this.in[j]);
                ++j;
            }
            ++i;
        }
    }
}

