/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import java.util.logging.Logger;

class IdentityDBCmd
extends Command {
    private static final Logger log = Logger.getLogger(IdentityDBCmd.class.getName());
    protected String _idbFileName;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;

    IdentityDBCmd() {
    }

    public void setFile(String pathName) {
        this._idbFileName = pathName;
    }

    public void setStoretype(String type) {
        this._ksType = type;
    }

    public void setKeystore(String url) {
        this._ksURL = url;
    }

    public void setStorepass(String password) {
        this._ksPassword = password;
    }

    public void setProvider(String className) {
        this._providerClassName = className;
    }

    void setup() throws Exception {
        this.setInputStreamParam(this._idbFileName);
        this.setKeyStoreParams(true, this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        if (Configuration.DEBUG) {
            log.fine("-identitydb handler will use the following options:");
            log.fine("  -file=" + this._idbFileName);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser result = new ClasspathToolParser("identitydb", true);
        result.setHeader(Messages.getString("IdentityDBCmd.7"));
        result.setFooter(Messages.getString("IdentityDBCmd.8"));
        OptionGroup options = new OptionGroup(Messages.getString("IdentityDBCmd.9"));
        options.add(new Option("file", Messages.getString("IdentityDBCmd.10"), Messages.getString("IdentityDBCmd.11")){

            public void parsed(String argument) throws OptionException {
                IdentityDBCmd.this._idbFileName = argument;
            }
        });
        options.add(new Option("storetype", Messages.getString("IdentityDBCmd.12"), Messages.getString("IdentityDBCmd.13")){

            public void parsed(String argument) throws OptionException {
                IdentityDBCmd.this._ksType = argument;
            }
        });
        options.add(new Option("keystore", Messages.getString("IdentityDBCmd.14"), Messages.getString("IdentityDBCmd.15")){

            public void parsed(String argument) throws OptionException {
                IdentityDBCmd.this._ksURL = argument;
            }
        });
        options.add(new Option("storepass", Messages.getString("IdentityDBCmd.16"), Messages.getString("IdentityDBCmd.17")){

            public void parsed(String argument) throws OptionException {
                IdentityDBCmd.this._ksPassword = argument;
            }
        });
        options.add(new Option("provider", Messages.getString("IdentityDBCmd.18"), Messages.getString("IdentityDBCmd.19")){

            public void parsed(String argument) throws OptionException {
                IdentityDBCmd.this._providerClassName = argument;
            }
        });
        options.add(new Option("v", Messages.getString("IdentityDBCmd.20")){

            public void parsed(String argument) throws OptionException {
                IdentityDBCmd.this.verbose = true;
            }
        });
        result.add(options);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", result);
        }
        return result;
    }
}

