/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.undo.AbstractUndoableEdit;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.FontSizeLocator;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class FontSizeHandle
extends LocatorHandle {
    private float oldSize;
    private float newSize;
    private Object restoreData;

    public FontSizeHandle(TextHolderFigure textHolderFigure) {
        super(textHolderFigure, new FontSizeLocator());
    }

    public FontSizeHandle(TextHolderFigure textHolderFigure, Locator locator) {
        super(textHolderFigure, locator);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        this.drawDiamond(graphics2D, this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_STROKE_COLOR));
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(9);
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle rectangle = new Rectangle(this.getLocation());
        int n = this.getHandlesize();
        rectangle.x -= n / 2;
        rectangle.y -= n / 2;
        rectangle.width = rectangle.height = n;
        return rectangle;
    }

    @Override
    public void trackStart(Point point, int n) {
        TextHolderFigure textHolderFigure = (TextHolderFigure)this.getOwner();
        this.oldSize = this.newSize = textHolderFigure.getFontSize();
        this.restoreData = textHolderFigure.getAttributesRestoreData();
    }

    @Override
    public void trackStep(Point point, Point point2, int n) {
        TextHolderFigure textHolderFigure = (TextHolderFigure)this.getOwner();
        Point2D.Double double_ = this.view.viewToDrawing(point);
        Point2D.Double double_2 = this.view.viewToDrawing(point2);
        if (textHolderFigure.get(AttributeKeys.TRANSFORM) != null) {
            try {
                textHolderFigure.get(AttributeKeys.TRANSFORM).inverseTransform(double_, double_);
                textHolderFigure.get(AttributeKeys.TRANSFORM).inverseTransform(double_2, double_2);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
        this.newSize = (float)Math.max(1.0, (double)this.oldSize + double_2.y - double_.y);
        textHolderFigure.willChange();
        textHolderFigure.setFontSize(this.newSize);
        textHolderFigure.changed();
    }

    @Override
    public void trackEnd(Point point, Point point2, int n) {
        final TextHolderFigure textHolderFigure = (TextHolderFigure)this.getOwner();
        final Object object = this.restoreData;
        float f = this.newSize;
        AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                return resourceBundleUtil.getString("attribute.fontSize.text");
            }

            @Override
            public void undo() {
                super.undo();
                textHolderFigure.willChange();
                textHolderFigure.restoreAttributesTo(object);
                textHolderFigure.changed();
            }

            @Override
            public void redo() {
                super.redo();
                textHolderFigure.willChange();
                textHolderFigure.setFontSize(FontSizeHandle.this.newSize);
                textHolderFigure.changed();
            }
        };
        this.fireUndoableEditHappened(abstractUndoableEdit);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        final TextHolderFigure textHolderFigure = (TextHolderFigure)this.getOwner();
        this.oldSize = this.newSize = textHolderFigure.getFontSize();
        switch (keyEvent.getKeyCode()) {
            case 38: {
                if (this.newSize > 1.0f) {
                    this.newSize -= 1.0f;
                }
                keyEvent.consume();
                break;
            }
            case 40: {
                this.newSize += 1.0f;
                keyEvent.consume();
                break;
            }
            case 37: {
                keyEvent.consume();
                break;
            }
            case 39: {
                keyEvent.consume();
            }
        }
        if (this.newSize != this.oldSize) {
            this.restoreData = textHolderFigure.getAttributesRestoreData();
            textHolderFigure.willChange();
            textHolderFigure.setFontSize(this.newSize);
            textHolderFigure.changed();
            final Object object = this.restoreData;
            float f = this.newSize;
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    return resourceBundleUtil.getString("attribute.fontSize");
                }

                @Override
                public void undo() {
                    super.undo();
                    textHolderFigure.willChange();
                    textHolderFigure.restoreAttributesTo(object);
                    textHolderFigure.changed();
                }

                @Override
                public void redo() {
                    super.redo();
                    textHolderFigure.willChange();
                    textHolderFigure.setFontSize(FontSizeHandle.this.newSize);
                    textHolderFigure.changed();
                }
            };
            this.fireUndoableEditHappened(abstractUndoableEdit);
        }
    }

    @Override
    public String getToolTipText(Point point) {
        return ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels").getString("handle.fontSize.toolTipText");
    }
}

