/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class FigureAttributes
implements Cloneable,
Serializable {
    private Hashtable fMap = new Hashtable();
    private static final long serialVersionUID = -6886355144423666716L;
    private int figureAttributesSerializedDataVersion = 1;

    public Object get(String string) {
        return this.fMap.get(string);
    }

    public void set(String string, Object object) {
        this.fMap.put(string, object);
    }

    public boolean hasDefined(String string) {
        return this.fMap.containsKey(string);
    }

    public Object clone() {
        try {
            FigureAttributes figureAttributes = (FigureAttributes)super.clone();
            figureAttributes.fMap = (Hashtable)this.fMap.clone();
            return figureAttributes;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        String string = storableInput.readString();
        if (!string.toLowerCase().equals("attributes")) {
            throw new IOException("Attributes expected");
        }
        this.fMap = new Hashtable();
        int n = storableInput.readInt();
        for (int i = 0; i < n; ++i) {
            String string2 = storableInput.readString();
            String string3 = storableInput.readString();
            Object object = null;
            if (string3.equals("Color")) {
                object = new Color(storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
            } else if (string3.equals("Boolean")) {
                object = new Boolean(storableInput.readString());
            } else if (string3.equals("String")) {
                object = storableInput.readString();
            } else if (string3.equals("Int")) {
                object = new Integer(storableInput.readInt());
            } else if (string3.equals("Storable")) {
                object = storableInput.readStorable();
            } else if (string3.equals("UNKNOWN")) continue;
            this.fMap.put(string2, object);
        }
    }

    public void write(StorableOutput storableOutput) {
        storableOutput.writeString("attributes");
        storableOutput.writeInt(this.fMap.size());
        Enumeration enumeration = this.fMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            storableOutput.writeString(string);
            Object v = this.fMap.get(string);
            if (v instanceof String) {
                storableOutput.writeString("String");
                storableOutput.writeString((String)v);
                continue;
            }
            if (v instanceof Color) {
                storableOutput.writeString("Color");
                storableOutput.writeInt(((Color)v).getRed());
                storableOutput.writeInt(((Color)v).getGreen());
                storableOutput.writeInt(((Color)v).getBlue());
                continue;
            }
            if (v instanceof Boolean) {
                storableOutput.writeString("Boolean");
                if (((Boolean)v).booleanValue()) {
                    storableOutput.writeString("TRUE");
                    continue;
                }
                storableOutput.writeString("FALSE");
                continue;
            }
            if (v instanceof Integer) {
                storableOutput.writeString("Int");
                storableOutput.writeInt((Integer)v);
                continue;
            }
            if (v instanceof Storable) {
                storableOutput.writeString("Storable");
                storableOutput.writeStorable((Storable)v);
                continue;
            }
            System.out.println(v);
            storableOutput.writeString("UNKNOWN");
        }
    }
}

