/*
 * Decompiled with CFR 0.152.
 */
package com.pff;

import com.pff.PSTDescriptorItem;
import com.pff.PSTException;
import com.pff.PSTNodeInputStream;
import com.pff.PSTObject;
import com.pff.PSTTable;
import com.pff.PSTTableBCItem;
import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PSTTableBC
extends PSTTable {
    private HashMap<Integer, PSTTableBCItem> items = new HashMap();
    private StringBuilder descBuffer = new StringBuilder();
    private boolean isDescNotYetInitiated = false;

    PSTTableBC(PSTNodeInputStream in) throws PSTException, IOException {
        super(in, new HashMap<Integer, PSTDescriptorItem>());
        if (this.tableTypeByte != -68) {
            throw new PSTException("unable to create PSTTableBC, table does not appear to be a bc!");
        }
        PSTTable.NodeInfo keyTableInfoNodeInfo = this.getNodeInfo(this.hidRoot);
        byte[] keyTableInfo = new byte[keyTableInfoNodeInfo.length()];
        keyTableInfoNodeInfo.in.seek(keyTableInfoNodeInfo.startOffset);
        keyTableInfoNodeInfo.in.read(keyTableInfo);
        this.numberOfKeys = keyTableInfo.length / (this.sizeOfItemKey + this.sizeOfItemValue);
        this.descBuffer.append("Number of entries: " + this.numberOfKeys + "\n");
        int offset = 0;
        for (int x = 0; x < this.numberOfKeys; ++x) {
            PSTTableBCItem item = new PSTTableBCItem();
            item.itemIndex = x;
            item.entryType = (int)PSTObject.convertLittleEndianBytesToLong(keyTableInfo, offset + 0, offset + 2);
            item.entryValueType = (int)PSTObject.convertLittleEndianBytesToLong(keyTableInfo, offset + 2, offset + 4);
            item.entryValueReference = (int)PSTObject.convertLittleEndianBytesToLong(keyTableInfo, offset + 4, offset + 8);
            switch (item.entryValueType) {
                case 2: {
                    item.entryValueReference &= 0xFFFF;
                }
                case 1: 
                case 3: 
                case 4: 
                case 10: {
                    item.isExternalValueReference = true;
                    break;
                }
                case 11: {
                    item.entryValueReference &= 0xFF;
                    item.isExternalValueReference = true;
                    break;
                }
                default: {
                    item.isExternalValueReference = true;
                    PSTTable.NodeInfo nodeInfoNodeInfo = this.getNodeInfo(item.entryValueReference);
                    if (nodeInfoNodeInfo == null) break;
                    byte[] nodeInfo = new byte[nodeInfoNodeInfo.length()];
                    nodeInfoNodeInfo.in.seek(nodeInfoNodeInfo.startOffset);
                    nodeInfoNodeInfo.in.read(nodeInfo);
                    item.data = nodeInfo;
                    item.isExternalValueReference = false;
                }
            }
            offset += 8;
            this.items.put(item.entryType, item);
        }
        this.releaseRawData();
    }

    public HashMap<Integer, PSTTableBCItem> getItems() {
        return this.items;
    }

    public String toString() {
        if (this.isDescNotYetInitiated) {
            this.isDescNotYetInitiated = false;
            for (Integer curItem : this.items.keySet()) {
                this.descBuffer.append(this.items.get(curItem).toString() + "\n\n");
            }
        }
        return this.description + this.descBuffer.toString();
    }
}

