/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import org.rrd4j.core.RrdByteArrayBackend;

public class RrdBerkeleyDbBackend
extends RrdByteArrayBackend {
    private final Database rrdDatabase;
    private volatile boolean dirty = false;

    protected RrdBerkeleyDbBackend(String path, Database rrdDatabase) {
        super(path);
        this.rrdDatabase = rrdDatabase;
    }

    protected RrdBerkeleyDbBackend(byte[] buffer, String path, Database rrdDatabase) {
        super(path);
        this.buffer = buffer;
        this.rrdDatabase = rrdDatabase;
    }

    @Override
    protected synchronized void write(long offset, byte[] bytes) throws IOException {
        super.write(offset, bytes);
        this.dirty = true;
    }

    @Override
    public void close() throws IOException {
        if (this.dirty) {
            DatabaseEntry theKey = new DatabaseEntry(this.getPath().getBytes("UTF-8"));
            DatabaseEntry theData = new DatabaseEntry(this.buffer);
            try {
                this.rrdDatabase.put(null, theKey, theData);
            }
            catch (DatabaseException de) {
                throw new IOException(de.getMessage());
            }
        }
    }
}

