/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.DateMathParser;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocExpirationUpdateProcessorFactory
extends UpdateRequestProcessorFactory
implements SolrCoreAware {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DEF_TTL_KEY = "_ttl_";
    private static final String EXP_FIELD_NAME_CONF = "expirationFieldName";
    private static final String TTL_FIELD_NAME_CONF = "ttlFieldName";
    private static final String TTL_PARAM_NAME_CONF = "ttlParamName";
    private static final String DEL_CHAIN_NAME_CONF = "autoDeleteChainName";
    private static final String DEL_PERIOD_SEC_CONF = "autoDeletePeriodSeconds";
    private SolrCore core;
    private ScheduledThreadPoolExecutor executor;
    private String expireField = null;
    private String ttlField = null;
    private String ttlParam = null;
    private String deleteChainName = null;
    private long deletePeriodSeconds = -1L;
    private volatile boolean previouslyInChargeOfDeletes = true;
    private static final Comparator<Slice> COMPARE_SLICES_BY_NAME = (a, b) -> a.getName().compareTo(b.getName());

    private SolrException confErr(String msg) {
        return this.confErr(msg, null);
    }

    private SolrException confErr(String msg, SolrException root) {
        return new SolrException(SolrException.ErrorCode.SERVER_ERROR, this.getClass().getSimpleName() + ": " + msg, (Throwable)root);
    }

    private String removeArgStr(NamedList args, String arg, String def, String errMsg) {
        if (args.indexOf(arg, 0) < 0) {
            return def;
        }
        Object tmp = args.remove(arg);
        if (null == tmp) {
            return null;
        }
        if (tmp instanceof String) {
            return tmp.toString();
        }
        throw this.confErr(arg + " " + errMsg);
    }

    @Override
    public void init(NamedList args) {
        this.deleteChainName = this.removeArgStr(args, DEL_CHAIN_NAME_CONF, null, "must be a <str> or <null/> for default chain");
        this.ttlField = this.removeArgStr(args, TTL_FIELD_NAME_CONF, DEF_TTL_KEY, "must be a <str> or <null/> to disable");
        this.ttlParam = this.removeArgStr(args, TTL_PARAM_NAME_CONF, DEF_TTL_KEY, "must be a <str> or <null/> to disable");
        this.expireField = this.removeArgStr(args, EXP_FIELD_NAME_CONF, null, "must be a <str>");
        if (null == this.expireField) {
            throw this.confErr("expirationFieldName must be configured");
        }
        Object tmp = args.remove(DEL_PERIOD_SEC_CONF);
        if (null != tmp) {
            if (!(tmp instanceof Number)) {
                throw this.confErr("autoDeletePeriodSeconds must be an <int> or <long>");
            }
            this.deletePeriodSeconds = ((Number)tmp).longValue();
        }
        super.init(args);
    }

    @Override
    public void inform(SolrCore core) {
        this.core = core;
        if (null == core.getLatestSchema().getFieldTypeNoEx(this.expireField)) {
            throw this.confErr("expirationFieldName does not exist in schema: " + this.expireField);
        }
        if (0L < this.deletePeriodSeconds) {
            try {
                UpdateRequestProcessorChain updateRequestProcessorChain = core.getUpdateProcessingChain(this.deleteChainName);
            }
            catch (SolrException e) {
                throw this.confErr("autoDeleteChainName does not exist: " + this.deleteChainName, e);
            }
            this.initDeleteExpiredDocsScheduler(core);
        }
    }

    private void initDeleteExpiredDocsScheduler(SolrCore core) {
        this.executor = new ScheduledThreadPoolExecutor(1, new DefaultSolrThreadFactory("autoExpireDocs"), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                log.warn("Skipping execution of '{}' using '{}'", (Object)r, (Object)e);
            }
        });
        core.addCloseHook(new CloseHook(){

            @Override
            public void postClose(SolrCore core) {
                if (DocExpirationUpdateProcessorFactory.this.executor.isTerminating()) {
                    log.info("Waiting for close of DocExpiration Executor");
                    ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)DocExpirationUpdateProcessorFactory.this.executor);
                }
            }

            @Override
            public void preClose(SolrCore core) {
                log.info("Triggering Graceful close of DocExpiration Executor");
                DocExpirationUpdateProcessorFactory.this.executor.shutdown();
            }
        });
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        long initialDelay = this.deletePeriodSeconds;
        this.executor.scheduleAtFixedRate(new DeleteExpiredDocsRunnable(this), this.deletePeriodSeconds, this.deletePeriodSeconds, TimeUnit.SECONDS);
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        String defaultTtl;
        String string = defaultTtl = null == this.ttlParam ? null : req.getParams().get(this.ttlParam);
        if (null == this.ttlField && null == defaultTtl) {
            return next;
        }
        return new TTLUpdateProcessor(defaultTtl, this.expireField, this.ttlField, next);
    }

    private boolean iAmInChargeOfPeriodicDeletes() {
        ZkController zk = this.core.getCoreContainer().getZkController();
        if (null == zk) {
            return true;
        }
        CloudDescriptor desc = this.core.getCoreDescriptor().getCloudDescriptor();
        String col = desc.getCollectionName();
        DocCollection docCollection = zk.getClusterState().getCollection(col);
        if (docCollection.getActiveSlicesArr().length == 0) {
            log.error("Collection {} has no active Slices?", (Object)col);
            return false;
        }
        ArrayList<Slice> slices = new ArrayList<Slice>(Arrays.asList(docCollection.getActiveSlicesArr()));
        Collections.sort(slices, COMPARE_SLICES_BY_NAME);
        Replica firstSliceLeader = ((Slice)slices.get(0)).getLeader();
        if (null == firstSliceLeader) {
            log.warn("Slice in charge of periodic deletes for {} does not currently have a leader", (Object)col);
            return false;
        }
        String leaderInCharge = firstSliceLeader.getName();
        String myCoreNodeName = desc.getCoreNodeName();
        boolean inChargeOfDeletesRightNow = leaderInCharge.equals(myCoreNodeName);
        if (this.previouslyInChargeOfDeletes && !inChargeOfDeletesRightNow) {
            log.info("Not currently in charge of periodic deletes for this collection, will not trigger delete or log again until this changes");
        }
        this.previouslyInChargeOfDeletes = inChargeOfDeletesRightNow;
        return inChargeOfDeletesRightNow;
    }

    private static final class DeleteExpiredDocsRunnable
    implements Runnable {
        final DocExpirationUpdateProcessorFactory factory;
        final SolrCore core;
        final String deleteChainName;
        final String expireField;

        public DeleteExpiredDocsRunnable(DocExpirationUpdateProcessorFactory factory) {
            this.factory = factory;
            this.core = factory.core;
            this.deleteChainName = factory.deleteChainName;
            this.expireField = factory.expireField;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try (LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.factory.core, Collections.emptyMap());){
                SolrQueryResponse rsp = new SolrQueryResponse();
                SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
                try {
                    if (!this.factory.iAmInChargeOfPeriodicDeletes()) {
                        return;
                    }
                    log.info("Beginning periodic deletion of expired docs");
                    UpdateRequestProcessorChain chain = this.core.getUpdateProcessingChain(this.deleteChainName);
                    UpdateRequestProcessor proc = chain.createProcessor(req, rsp);
                    if (null == proc) {
                        log.warn("No active processors, skipping automatic deletion of expired docs using chain: {}", (Object)this.deleteChainName);
                        return;
                    }
                    try {
                        DeleteUpdateCommand del = new DeleteUpdateCommand(req);
                        del.setQuery("{!cache=false}" + this.expireField + ":[* TO " + SolrRequestInfo.getRequestInfo().getNOW().toInstant() + "]");
                        proc.processDelete(del);
                        CommitUpdateCommand commit = new CommitUpdateCommand(req, false);
                        commit.softCommit = true;
                        commit.openSearcher = true;
                        proc.processCommit(commit);
                    }
                    finally {
                        try {
                            proc.finish();
                        }
                        finally {
                            proc.close();
                        }
                    }
                    log.info("Finished periodic deletion of expired docs");
                    return;
                }
                catch (IOException ioe) {
                    log.error("IOException in periodic deletion of expired docs: " + ioe.getMessage(), (Throwable)ioe);
                    return;
                }
                catch (RuntimeException re) {
                    log.error("Runtime error in periodic deletion of expired docs: " + re.getMessage(), (Throwable)re);
                    return;
                }
                finally {
                    SolrRequestInfo.clearRequestInfo();
                }
            }
        }
    }

    private static final class TTLUpdateProcessor
    extends UpdateRequestProcessor {
        final String defaultTtl;
        final String expireField;
        final String ttlField;

        public TTLUpdateProcessor(String defaultTtl, String expireField, String ttlField, UpdateRequestProcessor next) {
            super(next);
            this.defaultTtl = defaultTtl;
            this.expireField = expireField;
            this.ttlField = ttlField;
        }

        @Override
        public void processAdd(AddUpdateCommand cmd) throws IOException {
            String math;
            SolrInputDocument doc = cmd.getSolrInputDocument();
            String string = math = doc.containsKey((Object)this.ttlField) ? doc.getFieldValue(this.ttlField).toString() : this.defaultTtl;
            if (null != math) {
                try {
                    DateMathParser dmp = new DateMathParser();
                    doc.addField(this.expireField, (Object)dmp.parseMath(math));
                }
                catch (ParseException pe) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse ttl as date math: " + math, (Throwable)pe);
                }
            }
            super.processAdd(cmd);
        }
    }
}

