/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.Arrays;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.SlotAcc;

abstract class IntSlotAcc
extends SlotAcc {
    int[] result;
    int initialValue;

    public IntSlotAcc(FacetContext fcontext, int numSlots, int initialValue) {
        super(fcontext);
        this.initialValue = initialValue;
        this.result = new int[numSlots];
        if (initialValue != 0) {
            this.reset();
        }
    }

    @Override
    public int compare(int slotA, int slotB) {
        return Integer.compare(this.result[slotA], this.result[slotB]);
    }

    @Override
    public Object getValue(int slot) {
        return this.result[slot];
    }

    @Override
    public void reset() {
        Arrays.fill(this.result, this.initialValue);
    }

    @Override
    public void resize(SlotAcc.Resizer resizer) {
        this.result = resizer.resize(this.result, this.initialValue);
    }
}

