/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.cloud.CloudUtil;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.SolrCloseableLatch;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateShardCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public CreateShardCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        SolrCloseableLatch countDownLatch;
        String collectionName;
        block6: {
            collectionName = message.getStr("collection");
            String sliceName = message.getStr("shard");
            boolean waitForFinalState = message.getBool("waitForFinalState", false);
            log.info("Create shard invoked: {}", (Object)message);
            if (collectionName == null || sliceName == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'collection' and 'shard' are required parameters");
            }
            DocCollection collection = clusterState.getCollection(collectionName);
            ZkStateReader zkStateReader = this.ocmh.zkStateReader;
            AtomicReference<PolicyHelper.SessionWrapper> sessionWrapper = new AtomicReference<PolicyHelper.SessionWrapper>();
            try {
                List<ReplicaPosition> positions = CreateShardCmd.buildReplicaPositions(this.ocmh.cloudManager, clusterState, collectionName, message, sessionWrapper);
                Overseer.getStateUpdateQueue(zkStateReader.getZkClient()).offer(Utils.toJSON((Object)message));
                this.ocmh.waitForNewShard(collectionName, sliceName);
                String async = message.getStr("async");
                countDownLatch = new SolrCloseableLatch(positions.size(), (SolrCloseable)this.ocmh);
                for (ReplicaPosition position : positions) {
                    String nodeName = position.node;
                    String coreName = Assign.buildSolrCoreName(this.ocmh.cloudManager.getDistribStateManager(), collection, sliceName, position.type);
                    log.info("Creating replica " + coreName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + nodeName);
                    ZkNodeProps addReplicasProps = new ZkNodeProps(new String[]{"collection", collectionName, "shard", sliceName, "type", position.type.name(), "node", nodeName, "name", coreName, "waitForFinalState", Boolean.toString(waitForFinalState)});
                    HashMap<String, Object> propertyParams = new HashMap<String, Object>();
                    this.ocmh.addPropertyParams(message, propertyParams);
                    addReplicasProps = addReplicasProps.plus(propertyParams);
                    if (async != null) {
                        addReplicasProps.getProperties().put("async", async);
                    }
                    NamedList addResult = new NamedList();
                    this.ocmh.addReplica(zkStateReader.getClusterState(), addReplicasProps, addResult, () -> {
                        countDownLatch.countDown();
                        Object addResultFailure = addResult.get("failure");
                        if (addResultFailure != null) {
                            SimpleOrderedMap failure = (SimpleOrderedMap)results.get("failure");
                            if (failure == null) {
                                failure = new SimpleOrderedMap();
                                results.add("failure", (Object)failure);
                            }
                            failure.addAll((NamedList)addResultFailure);
                        } else {
                            SimpleOrderedMap success = (SimpleOrderedMap)results.get("success");
                            if (success == null) {
                                success = new SimpleOrderedMap();
                                results.add("success", (Object)success);
                            }
                            success.addAll((NamedList)addResult.get("success"));
                        }
                    });
                }
                if (sessionWrapper.get() == null) break block6;
            }
            catch (Throwable throwable) {
                if (sessionWrapper.get() != null) {
                    ((PolicyHelper.SessionWrapper)sessionWrapper.get()).release();
                }
                throw throwable;
            }
            sessionWrapper.get().release();
        }
        log.debug("Waiting for create shard action to complete");
        countDownLatch.await(5L, TimeUnit.MINUTES);
        log.debug("Finished waiting for create shard action to complete");
        log.info("Finished create command on all shards for collection: " + collectionName);
    }

    public static List<ReplicaPosition> buildReplicaPositions(SolrCloudManager cloudManager, ClusterState clusterState, String collectionName, ZkNodeProps message, AtomicReference<PolicyHelper.SessionWrapper> sessionWrapper) throws IOException, InterruptedException {
        ArrayList<ReplicaPosition> positions;
        String sliceName = message.getStr("shard");
        DocCollection collection = clusterState.getCollection(collectionName);
        int numNrtReplicas = message.getInt("nrtReplicas", message.getInt("replicationFactor", collection.getInt("nrtReplicas", collection.getInt("replicationFactor", Integer.valueOf(1)))));
        int numPullReplicas = message.getInt("pullReplicas", collection.getInt("pullReplicas", Integer.valueOf(0)));
        int numTlogReplicas = message.getInt("tlogReplicas", collection.getInt("tlogReplicas", Integer.valueOf(0)));
        int totalReplicas = numNrtReplicas + numPullReplicas + numTlogReplicas;
        if (numNrtReplicas + numTlogReplicas <= 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "nrtReplicas + tlogReplicas must be greater than 0");
        }
        Object createNodeSetStr = message.get("createNodeSet");
        boolean usePolicyFramework = CloudUtil.usePolicyFramework(collection, cloudManager);
        if (usePolicyFramework) {
            if (collection.getPolicyName() != null) {
                message.getProperties().put("policy", collection.getPolicyName());
            }
            positions = Assign.identifyNodes(cloudManager, clusterState, Assign.getLiveOrLiveAndCreateNodeSetList(clusterState.getLiveNodes(), message, OverseerCollectionMessageHandler.RANDOM), collection.getName(), message, Collections.singletonList(sliceName), numNrtReplicas, numTlogReplicas, numPullReplicas);
            sessionWrapper.set(PolicyHelper.getLastSessionWrapper((boolean)true));
        } else {
            List<Assign.ReplicaCount> sortedNodeList = Assign.getNodesForNewReplicas(clusterState, collection.getName(), sliceName, totalReplicas, createNodeSetStr, cloudManager);
            int i = 0;
            positions = new ArrayList();
            for (Map.Entry e : ImmutableMap.of((Object)Replica.Type.NRT, (Object)numNrtReplicas, (Object)Replica.Type.TLOG, (Object)numTlogReplicas, (Object)Replica.Type.PULL, (Object)numPullReplicas).entrySet()) {
                for (int j = 0; j < (Integer)e.getValue(); ++j) {
                    positions.add(new ReplicaPosition(sliceName, j + 1, (Replica.Type)e.getKey(), sortedNodeList.get((int)(i % sortedNodeList.size())).nodeName));
                    ++i;
                }
            }
        }
        return positions;
    }
}

