/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.lucene.util.Version;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.backup.BackupManager;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.core.snapshots.CollectionSnapshotMetaData;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.handler.component.ShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public BackupCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        String strategy;
        String collectionName = message.getStr("collection");
        String backupName = message.getStr("name");
        String repo = message.getStr("repository");
        Instant startTime = Instant.now();
        CoreContainer cc = this.ocmh.overseer.getCoreContainer();
        BackupRepository repository = cc.newBackupRepository(Optional.ofNullable(repo));
        BackupManager backupMgr = new BackupManager(repository, this.ocmh.zkStateReader);
        URI location = repository.createURI(message.getStr("location"));
        URI backupPath = repository.resolve(location, backupName);
        if (repository.exists(backupPath)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The backup directory already exists: " + backupPath);
        }
        repository.createDirectory(backupPath);
        switch (strategy = message.getStr("indexBackup", "copy-files")) {
            case "copy-files": {
                this.copyIndexFiles(backupPath, message, results);
                break;
            }
        }
        log.info("Starting to backup ZK data for backupName={}", (Object)backupName);
        String configName = this.ocmh.zkStateReader.readConfigName(collectionName);
        backupMgr.downloadConfigDir(location, backupName, configName);
        DocCollection collectionState = this.ocmh.zkStateReader.getClusterState().getCollection(collectionName);
        backupMgr.writeCollectionState(location, backupName, collectionName, collectionState);
        Properties properties = new Properties();
        properties.put("backupName", backupName);
        properties.put("collection", collectionName);
        properties.put("collection.configName", configName);
        properties.put("startTime", startTime.toString());
        properties.put("index.version", Version.LATEST.toString());
        backupMgr.writeBackupProperties(location, backupName, properties);
        backupMgr.downloadCollectionProperties(location, backupName, collectionName);
        log.info("Completed backing up ZK data for backupName={}", (Object)backupName);
    }

    private Replica selectReplicaWithSnapshot(CollectionSnapshotMetaData snapshotMeta, Slice slice) {
        Replica r;
        List<CollectionSnapshotMetaData.CoreSnapshotMetaData> snapshots = snapshotMeta.getReplicaSnapshotsForShard(slice.getName());
        Optional<CollectionSnapshotMetaData.CoreSnapshotMetaData> leaderCore = snapshots.stream().filter(x -> x.isLeader()).findFirst();
        if (leaderCore.isPresent()) {
            log.info("Replica {} was the leader when snapshot {} was created.", (Object)leaderCore.get().getCoreName(), (Object)snapshotMeta.getName());
            r = slice.getReplica(leaderCore.get().getCoreName());
            if (r != null && !r.getState().equals((Object)Replica.State.DOWN)) {
                return r;
            }
        }
        if (!(r = slice.getReplicas().stream().filter(x -> x.getState() != Replica.State.DOWN && snapshotMeta.isSnapshotExists(slice.getName(), (Replica)x)).findFirst()).isPresent()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to find any live replica with a snapshot named " + snapshotMeta.getName() + " for shard " + slice.getName());
        }
        return r.get();
    }

    private void copyIndexFiles(URI backupPath, ZkNodeProps request, NamedList results) throws Exception {
        String collectionName = request.getStr("collection");
        String backupName = request.getStr("name");
        String asyncId = request.getStr("async");
        String repoName = request.getStr("repository");
        ShardHandler shardHandler = this.ocmh.shardHandlerFactory.getShardHandler();
        HashMap<String, String> requestMap = new HashMap<String, String>();
        String commitName = request.getStr("commitName");
        Optional<Object> snapshotMeta = Optional.empty();
        if (commitName != null) {
            SolrZkClient zkClient = this.ocmh.zkStateReader.getZkClient();
            snapshotMeta = SolrSnapshotManager.getCollectionLevelSnapshot(zkClient, collectionName, commitName);
            if (!snapshotMeta.isPresent()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot with name " + commitName + " does not exist for collection " + collectionName);
            }
            if (((CollectionSnapshotMetaData)snapshotMeta.get()).getStatus() != CollectionSnapshotMetaData.SnapshotStatus.Successful) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot with name " + commitName + " for collection " + collectionName + " has not completed successfully. The status is " + (Object)((Object)((CollectionSnapshotMetaData)snapshotMeta.get()).getStatus()));
            }
        }
        log.info("Starting backup of collection={} with backupName={} at location={}", new Object[]{collectionName, backupName, backupPath});
        Collection<Object> shardsToConsider = Collections.emptySet();
        if (snapshotMeta.isPresent()) {
            shardsToConsider = ((CollectionSnapshotMetaData)snapshotMeta.get()).getShards();
        }
        for (Slice slice : this.ocmh.zkStateReader.getClusterState().getCollection(collectionName).getActiveSlices()) {
            Replica replica = null;
            if (snapshotMeta.isPresent()) {
                if (!shardsToConsider.contains(slice.getName())) {
                    log.warn("Skipping the backup for shard {} since it wasn't part of the collection {} when snapshot {} was created.", new Object[]{slice.getName(), collectionName, ((CollectionSnapshotMetaData)snapshotMeta.get()).getName()});
                    continue;
                }
                replica = this.selectReplicaWithSnapshot((CollectionSnapshotMetaData)snapshotMeta.get(), slice);
            } else {
                replica = slice.getLeader();
                if (replica == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No 'leader' replica available for shard " + slice.getName() + " of collection " + collectionName);
                }
            }
            String coreName = replica.getStr("core");
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.BACKUPCORE.toString()});
            params.set("name", new String[]{slice.getName()});
            params.set("repository", new String[]{repoName});
            params.set("location", new String[]{backupPath.toASCIIString()});
            params.set("core", new String[]{coreName});
            if (snapshotMeta.isPresent()) {
                params.set("commitName", new String[]{((CollectionSnapshotMetaData)snapshotMeta.get()).getName()});
            }
            this.ocmh.sendShardRequest(replica.getNodeName(), params, shardHandler, asyncId, requestMap);
            log.debug("Sent backup request to core={} for backupName={}", (Object)coreName, (Object)backupName);
        }
        log.debug("Sent backup requests to all shard leaders for backupName={}", (Object)backupName);
        this.ocmh.processResponses(results, shardHandler, true, "Could not backup all shards", asyncId, requestMap);
    }
}

