/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudUtil {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void checkSharedFSFailoverReplaced(CoreContainer cc, CoreDescriptor desc) {
        if (!cc.isSharedFs(desc)) {
            return;
        }
        ZkController zkController = cc.getZkController();
        String thisCnn = zkController.getCoreNodeName(desc);
        String thisBaseUrl = zkController.getBaseUrl();
        log.debug("checkSharedFSFailoverReplaced running for coreNodeName={} baseUrl={}", (Object)thisCnn, (Object)thisBaseUrl);
        DocCollection docCollection = zkController.getClusterState().getCollectionOrNull(desc.getCloudDescriptor().getCollectionName());
        if (docCollection != null && docCollection.getSlicesMap() != null) {
            Map slicesMap = docCollection.getSlicesMap();
            for (Slice slice : slicesMap.values()) {
                for (Replica replica : slice.getReplicas()) {
                    String cnn = replica.getName();
                    String baseUrl = replica.getStr("base_url");
                    log.debug("compare against coreNodeName={} baseUrl={}", (Object)cnn, (Object)baseUrl);
                    if (thisCnn == null || !thisCnn.equals(cnn) || thisBaseUrl.equals(baseUrl)) continue;
                    if (cc.getLoadedCoreNames().contains(desc.getName())) {
                        cc.unload(desc.getName());
                    }
                    try {
                        FileUtils.deleteDirectory((File)desc.getInstanceDir().toFile());
                    }
                    catch (IOException e) {
                        SolrException.log((Logger)log, (String)("Failed to delete instance dir for core:" + desc.getName() + " dir:" + desc.getInstanceDir()));
                    }
                    log.error("", (Throwable)new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Will not load SolrCore " + desc.getName() + " because it has been replaced due to failover."));
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Will not load SolrCore " + desc.getName() + " because it has been replaced due to failover.");
                }
            }
        }
    }

    public static boolean replicaExists(ClusterState clusterState, String collection, String shard, String coreNodeName) {
        Slice slice;
        DocCollection docCollection = clusterState.getCollectionOrNull(collection);
        if (docCollection != null && (slice = docCollection.getSlice(shard)) != null) {
            return slice.getReplica(coreNodeName) != null;
        }
        return false;
    }

    public static String unifiedResourcePath(SolrResourceLoader loader) {
        return loader instanceof ZkSolrResourceLoader ? ((ZkSolrResourceLoader)loader).getConfigSetZkPath() + "/" : loader.getConfigDir() + File.separator;
    }

    public static Map<String, byte[]> getTrustedKeys(SolrZkClient zk, String dir) {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        try {
            List children = zk.getChildren("/keys/" + dir, null, true);
            for (String key : children) {
                if (!key.endsWith(".der")) continue;
                result.put(key, zk.getData("/keys/" + dir + "/" + key, null, null, true));
            }
        }
        catch (KeeperException.NoNodeException e) {
            log.info("Error fetching key names");
            return Collections.EMPTY_MAP;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to read crypto keys", (Throwable)e);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to read crypto keys", (Throwable)e);
        }
        return result;
    }

    public static boolean usePolicyFramework(DocCollection collection, SolrCloudManager cloudManager) throws IOException, InterruptedException {
        AutoScalingConfig autoScalingConfig = cloudManager.getDistribStateManager().getAutoScalingConfig();
        return !autoScalingConfig.getPolicy().getClusterPolicy().isEmpty() || collection.getPolicyName() != null;
    }
}

