/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.IndexBuilder;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.TableBuilder;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.impl.TableMutator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableCreator
extends TableMutator {
    private String _name;
    private List<ColumnBuilder> _columns;
    private List<IndexBuilder> _indexes;
    private final List<TableMutator.IndexDataState> _indexDataStates = new ArrayList<TableMutator.IndexDataState>();
    private final Map<ColumnBuilder, TableMutator.ColumnState> _columnStates = new IdentityHashMap<ColumnBuilder, TableMutator.ColumnState>();
    private final List<ColumnBuilder> _lvalCols = new ArrayList<ColumnBuilder>();
    private int _tdefPageNumber = -1;
    private int _umapPageNumber = -1;
    private int _indexCount;
    private int _logicalIndexCount;

    public TableCreator(DatabaseImpl database) {
        super(database);
    }

    public String getName() {
        return this._name;
    }

    @Override
    String getTableName() {
        return this.getName();
    }

    @Override
    public int getTdefPageNumber() {
        return this._tdefPageNumber;
    }

    public int getUmapPageNumber() {
        return this._umapPageNumber;
    }

    public List<ColumnBuilder> getColumns() {
        return this._columns;
    }

    public List<IndexBuilder> getIndexes() {
        return this._indexes;
    }

    public boolean hasIndexes() {
        return !this._indexes.isEmpty();
    }

    public int getIndexCount() {
        return this._indexCount;
    }

    public int getLogicalIndexCount() {
        return this._logicalIndexCount;
    }

    @Override
    public TableMutator.IndexDataState getIndexDataState(IndexBuilder idx) {
        for (TableMutator.IndexDataState idxDataState : this._indexDataStates) {
            for (IndexBuilder curIdx : idxDataState.getIndexes()) {
                if (idx != curIdx) continue;
                return idxDataState;
            }
        }
        throw new IllegalStateException(this.withErrorContext("could not find state for index"));
    }

    public List<TableMutator.IndexDataState> getIndexDataStates() {
        return this._indexDataStates;
    }

    @Override
    public TableMutator.ColumnState getColumnState(ColumnBuilder col) {
        return this._columnStates.get(col);
    }

    public List<ColumnBuilder> getLongValueColumns() {
        return this._lvalCols;
    }

    @Override
    short getColumnNumber(String colName) {
        for (ColumnBuilder col : this._columns) {
            if (!col.getName().equalsIgnoreCase(colName)) continue;
            return col.getColumnNumber();
        }
        return -1;
    }

    public short countNonLongVariableLength() {
        short rtn = 0;
        for (ColumnBuilder col : this._columns) {
            if (!col.isVariableLength() || col.getType().isLongValue()) continue;
            rtn = (short)(rtn + 1);
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableImpl createTable(TableBuilder table) throws IOException {
        this._name = table.getName();
        this._columns = table.getColumns();
        this._indexes = table.getIndexes();
        if (this._indexes == null) {
            this._indexes = Collections.emptyList();
        }
        this.validate();
        short columnNumber = 0;
        for (ColumnBuilder col : this._columns) {
            short s = columnNumber;
            columnNumber = (short)(columnNumber + 1);
            col.setColumnNumber(s);
            if (!col.getType().isLongValue()) continue;
            this._lvalCols.add(col);
            this._columnStates.put(col, new TableMutator.ColumnState());
        }
        if (this.hasIndexes()) {
            for (IndexBuilder idx : this._indexes) {
                idx.setIndexNumber(this._logicalIndexCount++);
                this.findIndexDataState(idx);
            }
        }
        this.getPageChannel().startExclusiveWrite();
        try {
            this._tdefPageNumber = this.reservePageNumber();
            this._umapPageNumber = this.reservePageNumber();
            TableImpl.writeTableDefinition(this);
            this.getDatabase().addNewTable(this._name, this._tdefPageNumber, DatabaseImpl.TYPE_TABLE, null, null);
            TableImpl newTable = this.getDatabase().getTable(this._name);
            boolean addedProps = false;
            Map<String, PropertyMap.Property> props = table.getProperties();
            if (props != null) {
                newTable.getProperties().putAll(props.values());
                addedProps = true;
            }
            for (ColumnBuilder cb : this._columns) {
                Map<String, PropertyMap.Property> colProps = cb.getProperties();
                if (colProps == null) continue;
                newTable.getColumn(cb.getName()).getProperties().putAll(colProps.values());
                addedProps = true;
            }
            if (addedProps) {
                newTable.getProperties().save();
            }
            TableImpl tableImpl = newTable;
            return tableImpl;
        }
        finally {
            this.getPageChannel().finishWrite();
        }
    }

    private TableMutator.IndexDataState findIndexDataState(IndexBuilder idx) {
        for (TableMutator.IndexDataState idxDataState : this._indexDataStates) {
            if (!TableCreator.sameIndexData(idxDataState.getFirstIndex(), idx)) continue;
            idxDataState.addIndex(idx);
            return idxDataState;
        }
        TableMutator.IndexDataState idxDataState = new TableMutator.IndexDataState();
        idxDataState.setIndexDataNumber(this._indexCount++);
        idxDataState.addIndex(idx);
        this._indexDataStates.add(idxDataState);
        return idxDataState;
    }

    private void validate() throws IOException {
        this.getDatabase().validateNewTableName(this._name);
        if (this._columns == null || this._columns.isEmpty()) {
            throw new IllegalArgumentException(this.withErrorContext("Cannot create table with no columns"));
        }
        if (this._columns.size() > this.getFormat().MAX_COLUMNS_PER_TABLE) {
            throw new IllegalArgumentException(this.withErrorContext("Cannot create table with more than " + this.getFormat().MAX_COLUMNS_PER_TABLE + " columns"));
        }
        HashSet<String> colNames = new HashSet<String>();
        for (ColumnBuilder column : this._columns) {
            this.validateColumn(colNames, column);
        }
        List<ColumnBuilder> autoCols = this.getAutoNumberColumns();
        if (autoCols.size() > 1) {
            EnumSet<DataType> autoTypes = EnumSet.noneOf(DataType.class);
            for (ColumnBuilder c : autoCols) {
                this.validateAutoNumberColumn(autoTypes, c);
            }
        }
        if (this.hasIndexes()) {
            if (this._indexes.size() > this.getFormat().MAX_INDEXES_PER_TABLE) {
                throw new IllegalArgumentException(this.withErrorContext("Cannot create table with more than " + this.getFormat().MAX_INDEXES_PER_TABLE + " indexes"));
            }
            HashSet<String> idxNames = new HashSet<String>();
            boolean[] foundPk = new boolean[1];
            for (IndexBuilder index : this._indexes) {
                this.validateIndex(colNames, idxNames, foundPk, index);
            }
        }
    }

    private List<ColumnBuilder> getAutoNumberColumns() {
        ArrayList<ColumnBuilder> autoCols = new ArrayList<ColumnBuilder>(1);
        for (ColumnBuilder c : this._columns) {
            if (!c.isAutoNumber()) continue;
            autoCols.add(c);
        }
        return autoCols;
    }

    private static boolean sameIndexData(IndexBuilder idx1, IndexBuilder idx2) {
        if (idx1.getFlags() != idx2.getFlags()) {
            return false;
        }
        if (idx1.getColumns().size() != idx2.getColumns().size()) {
            return false;
        }
        for (int i = 0; i < idx1.getColumns().size(); ++i) {
            IndexBuilder.Column col2;
            IndexBuilder.Column col1 = idx1.getColumns().get(i);
            if (TableCreator.sameIndexData(col1, col2 = idx2.getColumns().get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean sameIndexData(IndexBuilder.Column col1, IndexBuilder.Column col2) {
        return col1.getName().equals(col2.getName()) && col1.getFlags() == col2.getFlags();
    }

    @Override
    protected String withErrorContext(String msg) {
        return msg + "(Table=" + this.getName() + ")";
    }
}

