/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.statistics;

import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyLegacyInterpreterUsagesCollector
extends AbstractProjectsUsagesCollector {
    private static final String GROUP_ID = "py-interpreter";

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            PyLegacyInterpreterUsagesCollector.$$$reportNull$$$0(0);
        }
        HashSet<UsageDescriptor> result2 = new HashSet<UsageDescriptor>();
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk pythonSdk2 = PythonSdkType.findPythonSdk(m);
            if (pythonSdk2 == null) continue;
            String versionString = pythonSdk2.getVersionString();
            if (StringUtil.isEmpty((String)versionString)) {
                versionString = "unknown version";
            }
            if (PythonSdkType.isRemote(pythonSdk2)) {
                versionString = versionString + " (" + PyLegacyInterpreterUsagesCollector.getRemoteSuffix(pythonSdk2) + ")";
            }
            if (PythonSdkType.isVirtualEnv(pythonSdk2)) {
                versionString = versionString + " [virtualenv]";
            }
            if (PythonSdkType.isConda(pythonSdk2)) {
                versionString = versionString + " [condavenv]";
            }
            result2.add(new UsageDescriptor(versionString, 1));
        }
        HashSet<UsageDescriptor> hashSet = result2;
        if (hashSet == null) {
            PyLegacyInterpreterUsagesCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    private static String getRemoteSuffix(@NotNull Sdk pythonSdk2) {
        if (pythonSdk2 == null) {
            PyLegacyInterpreterUsagesCollector.$$$reportNull$$$0(2);
        }
        String string = pythonSdk2.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase ? "Remote " + ((PyRemoteSdkAdditionalDataBase)pythonSdk2.getSdkAdditionalData()).getRemoteConnectionType().getName() : "";
        if (string == null) {
            PyLegacyInterpreterUsagesCollector.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create(GROUP_ID);
        if (groupDescriptor == null) {
            PyLegacyInterpreterUsagesCollector.$$$reportNull$$$0(4);
        }
        return groupDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/statistics/PyLegacyInterpreterUsagesCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/statistics/PyLegacyInterpreterUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectUsages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSuffix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectUsages";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSuffix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

