/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.WinRegistryService;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WinPythonSdkFlavor
extends CPythonSdkFlavor {
    private static final String[] REG_ROOTS = new String[]{"HKEY_LOCAL_MACHINE", "HKEY_CURRENT_USER"};
    private static final Map<String, String> REGISTRY_MAP = ImmutableMap.of((Object)"Python", (Object)"python.exe", (Object)"IronPython", (Object)"ipy.exe");
    private static volatile Set<String> ourRegistryCache;
    @NotNull
    private final WinRegistryService myWinRegService;

    WinPythonSdkFlavor(@NotNull WinRegistryService winRegistryService) {
        if (winRegistryService == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(0);
        }
        this.myWinRegService = winRegistryService;
    }

    @Override
    public Collection<String> suggestHomePaths(@Nullable Module module2) {
        TreeSet<String> candidates = new TreeSet<String>();
        this.findInCandidatePaths(candidates, "python.exe", "jython.bat", "pypy.exe");
        WinPythonSdkFlavor.findInstallations(candidates, "python.exe", PythonHelpersLocator.getHelpersRoot().getParent());
        return candidates;
    }

    private void findInCandidatePaths(Set<String> candidates, String ... exe_names) {
        for (String name : exe_names) {
            WinPythonSdkFlavor.findInstallations(candidates, name, "C:\\", "C:\\Program Files\\");
            WinPythonSdkFlavor.findInPath(candidates, name);
            this.findInRegistry(candidates);
        }
    }

    void findInRegistry(@NotNull Collection<String> candidates) {
        if (candidates == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(1);
        }
        WinPythonSdkFlavor.fillRegistryCache(this.myWinRegService);
        candidates.addAll(ourRegistryCache);
    }

    private static void findInstallations(Set<String> candidates, String exe_name, String ... roots) {
        for (String root : roots) {
            WinPythonSdkFlavor.findSubdirInstallations(candidates, root, FileUtil.getNameWithoutExtension((String)exe_name), exe_name);
        }
    }

    public static void findInPath(Collection<String> candidates, String exeName) {
        String path = System.getenv("PATH");
        if (path == null) {
            return;
        }
        for (String pathEntry : StringUtil.split((String)path, (String)";")) {
            File f;
            if (pathEntry.startsWith("\"") && pathEntry.endsWith("\"")) {
                if (pathEntry.length() < 2) continue;
                pathEntry = pathEntry.substring(1, pathEntry.length() - 1);
            }
            if (!(f = new File(pathEntry, exeName)).exists()) continue;
            candidates.add(FileUtil.toSystemDependentName((String)f.getPath()));
        }
    }

    private static void fillRegistryCache(@NotNull WinRegistryService registryService) {
        if (registryService == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(2);
        }
        if (ourRegistryCache != null) {
            return;
        }
        ourRegistryCache = new HashSet<String>();
        for (String regRoot : REG_ROOTS) {
            for (Map.Entry<String, String> entry : REGISTRY_MAP.entrySet()) {
                String productId = entry.getKey();
                String exePath = entry.getValue();
                String companiesPath = String.format("%s\\SOFTWARE\\%s", regRoot, productId);
                String companiesPathWow = String.format("%s\\SOFTWARE\\Wow6432Node\\%s", regRoot, productId);
                for (String path : new String[]{companiesPath, companiesPathWow}) {
                    List<String> companies = registryService.listBranches(path);
                    for (String company : companies) {
                        String pathToCompany = path + '\\' + company;
                        List<String> versions = registryService.listBranches(pathToCompany);
                        for (String version : versions) {
                            File interpreter;
                            String folder = registryService.getDefaultKey(pathToCompany + '\\' + version + "\\InstallPath");
                            if (folder == null || !(interpreter = new File(folder, exePath)).exists()) continue;
                            ourRegistryCache.add(FileUtil.toSystemDependentName((String)interpreter.getPath()));
                        }
                    }
                }
            }
        }
    }

    private static void findSubdirInstallations(Collection<String> candidates, String rootDir, String dir_prefix, String exe_name) {
        VirtualFile rootVDir = LocalFileSystem.getInstance().findFileByPath(rootDir);
        if (rootVDir != null) {
            if (rootVDir instanceof NewVirtualFile) {
                ((NewVirtualFile)rootVDir).markDirty();
            }
            rootVDir.refresh(true, false);
            for (VirtualFile dir : rootVDir.getChildren()) {
                VirtualFile python_exe;
                if (!dir.isDirectory() || !dir.getName().toLowerCase().startsWith(dir_prefix) || (python_exe = dir.findChild(exe_name)) == null) continue;
                candidates.add(FileUtil.toSystemDependentName((String)python_exe.getPath()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "winRegistryService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registryService";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/sdk/flavors/WinPythonSdkFlavor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findInRegistry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fillRegistryCache";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

