/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move.moduleMembers;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.AbstractMemberSelectionTable;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.RowIcon;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.refactoring.move.PyBaseMoveDialog;
import com.jetbrains.python.refactoring.move.PyMoveRefactoringUtil;
import com.jetbrains.python.refactoring.move.moduleMembers.PyModuleMemberInfo;
import com.jetbrains.python.refactoring.move.moduleMembers.PyModuleMemberInfoModel;
import com.jetbrains.python.refactoring.move.moduleMembers.PyMoveModuleMembersHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMoveModuleMembersDialog
extends PyBaseMoveDialog {
    @NonNls
    private static final String BULK_MOVE_TABLE_VISIBLE = "python.move.module.members.dialog.show.table";
    private final TopLevelSymbolsSelectionTable myMemberSelectionTable;
    private final PyModuleMemberInfoModel myModuleMemberModel;
    private final boolean mySeveralElementsSelected;

    public PyMoveModuleMembersDialog(@NotNull Project project, @NotNull List<PsiNamedElement> elements, @NotNull String source, @NotNull String destination) {
        String description;
        boolean tableIsVisible;
        if (project == null) {
            PyMoveModuleMembersDialog.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            PyMoveModuleMembersDialog.$$$reportNull$$$0(1);
        }
        if (source == null) {
            PyMoveModuleMembersDialog.$$$reportNull$$$0(2);
        }
        if (destination == null) {
            PyMoveModuleMembersDialog.$$$reportNull$$$0(3);
        }
        super(project, source, destination);
        assert (!elements.isEmpty());
        PsiNamedElement firstElement = elements.get(0);
        this.setTitle(PyBundle.message("refactoring.move.module.members.dialog.title", new Object[0]));
        PyFile pyFile = (PyFile)firstElement.getContainingFile();
        this.myModuleMemberModel = new PyModuleMemberInfoModel(pyFile);
        List<PyModuleMemberInfo> symbolsInfos = PyMoveModuleMembersDialog.collectModuleMemberInfos(this.myModuleMemberModel.myPyFile);
        for (PyModuleMemberInfo info : symbolsInfos) {
            info.setChecked(elements.contains(info.getMember()));
        }
        this.myModuleMemberModel.memberInfoChanged(new MemberInfoChange(symbolsInfos));
        this.myMemberSelectionTable = new TopLevelSymbolsSelectionTable(symbolsInfos, this.myModuleMemberModel);
        this.myMemberSelectionTable.addMemberInfoChangeListener(this.myModuleMemberModel);
        this.myMemberSelectionTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                PyMoveModuleMembersDialog.this.validateButtons();
            }
        });
        this.mySeveralElementsSelected = elements.size() > 1;
        boolean bl = tableIsVisible = this.mySeveralElementsSelected || PropertiesComponent.getInstance().getBoolean(BULK_MOVE_TABLE_VISIBLE);
        if (!tableIsVisible && elements.size() == 1) {
            String name = PyMoveRefactoringUtil.getPresentableName(firstElement);
            description = firstElement instanceof PyFunction ? PyBundle.message("refactoring.move.module.members.dialog.description.function", name) : (firstElement instanceof PyClass ? PyBundle.message("refactoring.move.module.members.dialog.description.class", name) : PyBundle.message("refactoring.move.module.members.dialog.description.variable", name));
        } else {
            description = PyBundle.message("refactoring.move.module.members.dialog.description.selection", new Object[0]);
        }
        this.myDescription.setText(description);
        HideableDecorator decorator = new HideableDecorator(this.myExtraPanel, PyBundle.message("refactoring.move.module.members.dialog.table.title", new Object[0]), true){

            @Override
            protected void on() {
                super.on();
                PyMoveModuleMembersDialog.this.myDescription.setText(PyBundle.message("refactoring.move.module.members.dialog.description.selection", new Object[0]));
                PropertiesComponent.getInstance().setValue(PyMoveModuleMembersDialog.BULK_MOVE_TABLE_VISIBLE, true);
            }

            @Override
            protected void off() {
                super.off();
                PropertiesComponent.getInstance().setValue(PyMoveModuleMembersDialog.BULK_MOVE_TABLE_VISIBLE, false);
            }
        };
        decorator.setOn(tableIsVisible);
        decorator.setContentComponent((JComponent)new JBScrollPane((Component)((Object)this.myMemberSelectionTable)){

            public Dimension getMinimumSize() {
                return new Dimension((int)super.getMinimumSize().getWidth(), 0);
            }
        });
        this.init();
    }

    @Override
    protected void setUpDialog() {
        super.setUpDialog();
        this.enlargeDialogHeightIfNecessary();
    }

    private void enlargeDialogHeightIfNecessary() {
        if (this.mySeveralElementsSelected && !PropertiesComponent.getInstance((Project)this.getProject()).getBoolean(BULK_MOVE_TABLE_VISIBLE)) {
            DialogWrapperPeer peer = this.getPeer();
            Dimension realSize = peer.getSize();
            double preferredHeight = peer.getPreferredSize().getHeight();
            if (realSize.getHeight() < preferredHeight) {
                peer.setSize((int)realSize.getWidth(), (int)preferredHeight);
            }
        }
    }

    @Override
    @Nullable
    protected String getDimensionServiceKey() {
        return "#com.jetbrains.python.refactoring.move.PyMoveModuleMembersDialog";
    }

    @Override
    protected String getHelpId() {
        return "python.reference.moveModuleMembers";
    }

    @Override
    protected boolean areButtonsValid() {
        return !this.myMemberSelectionTable.getSelectedMemberInfos().isEmpty();
    }

    @NotNull
    public List<PyElement> getSelectedTopLevelSymbols() {
        Collection selectedMembers = this.myMemberSelectionTable.getSelectedMemberInfos();
        List selectedElements = ContainerUtil.map(selectedMembers, MemberInfoBase::getMember);
        List list2 = ContainerUtil.sorted((Collection)selectedElements, (e1, e2) -> PyPsiUtils.isBefore((PsiElement)e1, (PsiElement)e2) ? -1 : 1);
        if (list2 == null) {
            PyMoveModuleMembersDialog.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    private static List<PyModuleMemberInfo> collectModuleMemberInfos(@NotNull PyFile pyFile) {
        if (pyFile == null) {
            PyMoveModuleMembersDialog.$$$reportNull$$$0(5);
        }
        List<PyElement> moduleMembers = PyMoveModuleMembersHelper.getTopLevelModuleMembers(pyFile);
        List list2 = ContainerUtil.mapNotNull(moduleMembers, PyModuleMemberInfo::new);
        if (list2 == null) {
            PyMoveModuleMembersDialog.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/move/moduleMembers/PyMoveModuleMembersDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/move/moduleMembers/PyMoveModuleMembersDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTopLevelSymbols";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectModuleMemberInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectModuleMemberInfos";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class TopLevelSymbolsSelectionTable
    extends AbstractMemberSelectionTable<PyElement, PyModuleMemberInfo> {
        public TopLevelSymbolsSelectionTable(Collection<PyModuleMemberInfo> memberInfos, @Nullable MemberInfoModel<PyElement, PyModuleMemberInfo> memberInfoModel) {
            super(memberInfos, memberInfoModel, null);
        }

        @Override
        @Nullable
        protected Object getAbstractColumnValue(PyModuleMemberInfo memberInfo) {
            return null;
        }

        @Override
        protected boolean isAbstractColumnEditable(int rowIndex) {
            return false;
        }

        @Override
        protected void setVisibilityIcon(PyModuleMemberInfo memberInfo, RowIcon icon) {
        }

        @Override
        protected Icon getOverrideIcon(PyModuleMemberInfo memberInfo) {
            return null;
        }
    }
}

