/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibDocumentationLinkProvider;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevDocumentationProvider;
import com.jetbrains.python.documentation.DocumentationBuilderKit;
import com.jetbrains.python.documentation.PyDocumentationBuilder;
import com.jetbrains.python.documentation.PyDocumentationLink;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.PyTypeModelBuilder;
import com.jetbrains.python.documentation.PythonDocumentationLinkProvider;
import com.jetbrains.python.documentation.PythonDocumentationMap;
import com.jetbrains.python.documentation.PythonDocumentationQuickInfoProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.toolbox.ChainIterable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class PythonDocumentationProvider
extends AbstractDocumentationProvider
implements ExternalDocumentationProvider {
    private static final int RETURN_TYPE_WRAPPING_THRESHOLD = 80;
    private static final String BULLET_POINT = "\u2022";

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, @NotNull PsiElement originalElement) {
        if (originalElement == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(0);
        }
        for (PythonDocumentationQuickInfoProvider point : (PythonDocumentationQuickInfoProvider[])PythonDocumentationQuickInfoProvider.EP_NAME.getExtensions()) {
            String info = point.getQuickInfo(originalElement);
            if (info == null) continue;
            return info;
        }
        TypeEvalContext context = TypeEvalContext.userInitiated(originalElement.getProject(), originalElement.getContainingFile());
        if (element instanceof PyFunction) {
            String clsName;
            PyFunction function = (PyFunction)element;
            ChainIterable<String> result2 = new ChainIterable<String>();
            PyClass cls = function.getContainingClass();
            if (cls != null && (clsName = cls.getName()) != null) {
                result2.addItem("class ").addItem(clsName).addItem("\n");
            }
            result2.add(PythonDocumentationProvider.describeDecorators(function, Function.identity(), DocumentationBuilderKit.TO_ONE_LINE_AND_ESCAPE, ", ", "\n")).add(PythonDocumentationProvider.describeFunction(function, originalElement, context, true));
            String docStringSummary = PythonDocumentationProvider.getDocStringSummary(function);
            if (docStringSummary != null) {
                result2.addItem("\n").addItem(docStringSummary);
            }
            return result2.toString();
        }
        if (element instanceof PyClass) {
            PyClass cls = (PyClass)element;
            ChainIterable<String> result3 = new ChainIterable<String>();
            result3.add(PythonDocumentationProvider.describeDecorators(cls, Function.identity(), DocumentationBuilderKit.TO_ONE_LINE_AND_ESCAPE, ", ", "\n")).add(PythonDocumentationProvider.describeClass(cls, Function.identity(), DocumentationBuilderKit.TO_ONE_LINE_AND_ESCAPE, false, false, context));
            String docStringSummary = PythonDocumentationProvider.getDocStringSummary(cls);
            if (docStringSummary != null) {
                result3.addItem("\n").addItem(docStringSummary);
            } else {
                Optional.ofNullable(cls.findInitOrNew(false, context)).map(PythonDocumentationProvider::getDocStringSummary).ifPresent(summary -> result3.addItem("\n").addItem((String)summary));
            }
            return result3.toString();
        }
        if (element instanceof PyExpression) {
            return PythonDocumentationProvider.describeExpression((PyExpression)element, originalElement, DocumentationBuilderKit.ESCAPE_ONLY, context);
        }
        return null;
    }

    @Nullable
    private static String getDocStringSummary(@NotNull PyDocStringOwner owner) {
        PyStringLiteralExpression docStringExpression;
        if (owner == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(1);
        }
        if ((docStringExpression = PyDocumentationBuilder.getEffectiveDocStringExpression(owner)) != null) {
            StructuredDocString docString = DocStringUtil.parse(docStringExpression.getStringValue(), docStringExpression);
            return docString.getSummary();
        }
        return null;
    }

    @NotNull
    static ChainIterable<String> describeFunction(@NotNull PyFunction function, @Nullable PsiElement original, @NotNull TypeEvalContext context, boolean forTooltip) {
        List<PyFunction> overloads;
        if (function == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(3);
        }
        ChainIterable<String> result2 = new ChainIterable<String>(PythonDocumentationProvider.describeFunctionWithTypes(function, context, forTooltip));
        if (PythonDocumentationProvider.showOverloads(function, original, context) && !(overloads = PyiUtil.getOverloads(function, context)).isEmpty()) {
            result2.addItem("\nPossible types:\n");
            boolean first = true;
            for (PyFunction overload : overloads) {
                if (!first) {
                    result2.addItem("\n");
                }
                result2.addItem(BULLET_POINT).addItem(" ");
                PythonDocumentationProvider.describeTypeWithLinks(context.getType(overload), context, function, result2);
                first = false;
            }
        }
        ChainIterable<String> chainIterable = result2;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(4);
        }
        return chainIterable;
    }

    private static boolean showOverloads(@NotNull PyFunction definition, @Nullable PsiElement original, @NotNull TypeEvalContext context) {
        if (definition == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(6);
        }
        if (!PyiUtil.isOverload(definition, context)) {
            return true;
        }
        PyFunction containing = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)original, PyFunction.class, (boolean)false, (Class[])new Class[]{PyStatementList.class, PyParameterList.class});
        return containing == null || containing != original && containing.getNameIdentifier() != original;
    }

    @NotNull
    static ChainIterable<String> describeTarget(@NotNull PyTargetExpression target2, @NotNull TypeEvalContext context) {
        if (target2 == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(8);
        }
        ChainIterable<String> result2 = new ChainIterable<String>();
        result2.addItem(StringUtil.escapeXml((String)StringUtil.notNullize((String)target2.getName())));
        result2.addItem(": ");
        PythonDocumentationProvider.describeTypeWithLinks(context.getType(target2), context, target2, result2);
        PyExpression value = target2.findAssignedValue();
        if (value != null) {
            result2.addItem(" = ");
            String initializerText = value.getText();
            int index = initializerText.indexOf("\n");
            if (index < 0) {
                result2.addItem(StringUtil.escapeXml((String)initializerText));
            } else {
                result2.addItem(StringUtil.escapeXml((String)initializerText.substring(0, index))).addItem("...");
            }
        }
        ChainIterable<String> chainIterable = result2;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(9);
        }
        return chainIterable;
    }

    @NotNull
    static ChainIterable<String> describeParameter(@NotNull PyNamedParameter parameter, @NotNull TypeEvalContext context) {
        if (parameter == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(11);
        }
        ChainIterable<String> result2 = new ChainIterable<String>();
        result2.addItem(StringUtil.escapeXml((String)StringUtil.notNullize((String)parameter.getName())));
        result2.addItem(": ");
        PythonDocumentationProvider.describeTypeWithLinks(context.getType(parameter), context, parameter, result2);
        ChainIterable<String> chainIterable = result2;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(12);
        }
        return chainIterable;
    }

    @NotNull
    private static String describeFunctionWithTypes(@NotNull PyFunction function, @NotNull TypeEvalContext context, boolean forTooltip) {
        if (function == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(14);
        }
        StringBuilder result2 = new StringBuilder();
        if (function.isAsync()) {
            result2.append("async ");
        }
        result2.append("def ");
        String funcName = StringUtil.notNullize((String)function.getName(), (String)"<unnamed>");
        int firstParamOffset = result2.length() + funcName.length();
        int lastLineOffset = 0;
        if (forTooltip) {
            result2.append(PythonDocumentationProvider.escaped(funcName));
        } else {
            PythonDocumentationProvider.appendWithTags(result2, PythonDocumentationProvider.escaped(funcName), "b");
        }
        result2.append("(");
        ++firstParamOffset;
        boolean first = true;
        boolean firstIsSelf = false;
        List parameters2 = function.getParameters(context);
        for (PyCallableParameter parameter : parameters2) {
            String defaultValue;
            if (!first) {
                result2.append(",");
                if (forTooltip || firstIsSelf && parameters2.size() == 2) {
                    result2.append(" ");
                } else {
                    result2.append("\n");
                    lastLineOffset = result2.length();
                    StringUtil.repeatSymbol((Appendable)result2, (char)' ', (int)firstParamOffset);
                }
            } else {
                firstIsSelf = parameter.isSelf();
            }
            String paramName = parameter.getName();
            PyType paramType = parameter.getType(context);
            boolean showType = true;
            if (parameter.isPositionalContainer()) {
                paramName = "*" + StringUtil.notNullize((String)paramName, (String)"args");
                PyTupleType tupleType = PyUtil.as(paramType, PyTupleType.class);
                if (tupleType != null) {
                    paramType = tupleType.getIteratedItemType();
                }
            } else if (parameter.isKeywordContainer()) {
                paramName = "**" + StringUtil.notNullize((String)paramName, (String)"kwargs");
                PyCollectionType genericType = PyUtil.as(paramType, PyCollectionType.class);
                if (genericType != null && genericType.getPyClass() == PyBuiltinCache.getInstance(function).getClass("dict")) {
                    List<PyType> typeParams = genericType.getElementTypes();
                    paramType = typeParams.size() == 2 ? typeParams.get(1) : null;
                }
            } else if (parameter.getParameter() instanceof PySingleStarParameter) {
                paramName = "*";
                showType = false;
            } else {
                paramName = StringUtil.notNullize((String)paramName, (String)"<unnamed>");
                PyNamedParameter named = PyUtil.as(parameter.getParameter(), PyNamedParameter.class);
                showType = !parameter.isSelf() || named != null && new PyTypingTypeProvider().getParameterType(named, function, context) != null;
            }
            result2.append(PythonDocumentationProvider.escaped(paramName));
            if (showType) {
                result2.append(": ");
                result2.append(PythonDocumentationProvider.formatTypeWithLinks(paramType, function, context));
            }
            if ((defaultValue = parameter.getDefaultValueText()) != null) {
                result2.append(showType ? " = " : "=");
                result2.append(PythonDocumentationProvider.escaped(defaultValue));
            }
            first = false;
        }
        result2.append(")");
        if (!forTooltip && StringUtil.stripHtml((String)result2.substring(lastLineOffset), (boolean)false).length() > 80) {
            result2.append("\n ");
        }
        result2.append(PythonDocumentationProvider.escaped(" -> ")).append(PythonDocumentationProvider.formatTypeWithLinks(context.getReturnType(function), function, context));
        String string = result2.toString();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    private static String describeExpression(@NotNull PyExpression expression, @NotNull PsiElement originalElement, @NotNull Function<String, String> escaper, @NotNull TypeEvalContext context) {
        String name;
        if (expression == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(16);
        }
        if (originalElement == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(17);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(18);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(19);
        }
        if ((name = expression.getName()) != null) {
            PyFunction function;
            StringBuilder result2 = new StringBuilder(expression instanceof PyNamedParameter ? "parameter" : "variable");
            result2.append(String.format(" \"%s\"", name));
            if (expression instanceof PyNamedParameter && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, PyFunction.class)) != null) {
                result2.append(" of ").append(function.getContainingClass() == null ? "function" : "method").append(String.format(" \"%s\"", function.getName()));
            }
            if (originalElement instanceof PyTypedElement) {
                String typeName = PythonDocumentationProvider.getTypeName(context.getType((PyTypedElement)originalElement), context);
                result2.append("\n").append(String.format("Inferred type: %s", typeName));
            }
            return escaper.apply(result2.toString());
        }
        return null;
    }

    @NotNull
    public static String getTypeName(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(20);
        }
        String string = PythonDocumentationProvider.buildTypeModel(type, context).asString();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static String getTypeHint(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(22);
        }
        String string = PythonDocumentationProvider.buildTypeModel(type, context).asPep484TypeHint();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(23);
        }
        return string;
    }

    public static void describeTypeWithLinks(@Nullable PyType type, @NotNull TypeEvalContext context, @NotNull PsiElement anchor2, @NotNull ChainIterable<String> body) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(24);
        }
        if (anchor2 == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(25);
        }
        if (body == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(26);
        }
        PythonDocumentationProvider.buildTypeModel(type, context).toBodyWithLinks(body, anchor2);
    }

    @NotNull
    public static String getTypeDescription(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(27);
        }
        String string = PythonDocumentationProvider.buildTypeModel(type, context).asDescription();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static PyTypeModelBuilder.TypeModel buildTypeModel(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(29);
        }
        PyTypeModelBuilder.TypeModel typeModel = new PyTypeModelBuilder(context).build(type, true);
        if (typeModel == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(30);
        }
        return typeModel;
    }

    @NotNull
    static ChainIterable<String> describeDecorators(@NotNull PyDecoratable decoratable, @NotNull Function<String, String> escapedCalleeMapper, @NotNull Function<String, String> escaper, @NotNull String separator, @NotNull String suffix) {
        if (decoratable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(31);
        }
        if (escapedCalleeMapper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(32);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(33);
        }
        if (separator == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(34);
        }
        if (suffix == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(35);
        }
        ChainIterable<String> result2 = new ChainIterable<String>();
        PyDecoratorList decoratorList = decoratable.getDecoratorList();
        if (decoratorList != null) {
            boolean first = true;
            for (PyDecorator decorator : decoratorList.getDecorators()) {
                if (!first) {
                    result2.addItem(separator);
                }
                result2.add(PythonDocumentationProvider.describeDecorator(decorator, escapedCalleeMapper, escaper));
                first = false;
            }
        }
        if (!result2.isEmpty()) {
            result2.addItem(suffix);
        }
        ChainIterable<String> chainIterable = result2;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(36);
        }
        return chainIterable;
    }

    @NotNull
    static ChainIterable<String> describeClass(@NotNull PyClass cls, @NotNull Function<String, String> escapedNameMapper, @NotNull Function<String, String> escaper, boolean link, boolean linkAncestors, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(37);
        }
        if (escapedNameMapper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(38);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(39);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(40);
        }
        ChainIterable<String> result2 = new ChainIterable<String>();
        String name = escapedNameMapper.apply(escaper.apply(cls.getName()));
        result2.addItem(escaper.apply("class "));
        result2.addItem(link ? PyDocumentationLink.toContainingClass(name) : name);
        PyExpression[] superClasses = cls.getSuperClassExpressions();
        if (superClasses.length > 0) {
            result2.addItem(escaper.apply("("));
            boolean isNotFirst = false;
            for (PyExpression superClass : superClasses) {
                if (isNotFirst) {
                    result2.addItem(escaper.apply(", "));
                } else {
                    isNotFirst = true;
                }
                result2.addItem(PythonDocumentationProvider.describeSuperClass(superClass, escaper, linkAncestors, context));
            }
            result2.addItem(escaper.apply(")"));
        }
        ChainIterable<String> chainIterable = result2;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(41);
        }
        return chainIterable;
    }

    @NotNull
    private static String describeSuperClass(@NotNull PyExpression expression, @NotNull Function<String, String> escaper, boolean link, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(42);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(43);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(44);
        }
        if (link) {
            PyCallExpression callExpression;
            PyExpression callee;
            if (expression instanceof PyReferenceExpression) {
                PyReferenceExpression referenceExpression = (PyReferenceExpression)expression;
                if (!referenceExpression.isQualified()) {
                    PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
                    for (ResolveResult result2 : referenceExpression.getReference(resolveContext).multiResolve(false)) {
                        String qualifiedName;
                        PsiElement element = result2.getElement();
                        if (!(element instanceof PyClass) || (qualifiedName = ((PyClass)element).getQualifiedName()) == null) continue;
                        String string = PyDocumentationLink.toPossibleClass(escaper.apply(expression.getText()), qualifiedName, element, context);
                        if (string == null) {
                            PythonDocumentationProvider.$$$reportNull$$$0(45);
                        }
                        return string;
                    }
                }
            } else if (expression instanceof PySubscriptionExpression) {
                PyExpression operand = ((PySubscriptionExpression)expression).getOperand();
                PyExpression indexExpression = ((PySubscriptionExpression)expression).getIndexExpression();
                if (indexExpression != null) {
                    String string = PythonDocumentationProvider.describeSuperClass(operand, escaper, true, context) + escaper.apply("[") + PythonDocumentationProvider.describeSuperClass(indexExpression, escaper, true, context) + escaper.apply("]");
                    if (string == null) {
                        PythonDocumentationProvider.$$$reportNull$$$0(46);
                    }
                    return string;
                }
            } else if (expression instanceof PyKeywordArgument) {
                String keyword = ((PyKeywordArgument)expression).getKeyword();
                PyExpression valueExpression = ((PyKeywordArgument)expression).getValueExpression();
                if ("metaclass".equals(keyword) && valueExpression != null) {
                    String string = escaper.apply("metaclass=") + PythonDocumentationProvider.describeSuperClass(valueExpression, escaper, true, context);
                    if (string == null) {
                        PythonDocumentationProvider.$$$reportNull$$$0(47);
                    }
                    return string;
                }
            } else if (PyClassImpl.isSixWithMetaclassCall(expression) && (callee = (callExpression = (PyCallExpression)expression).getCallee()) != null) {
                String string = StreamEx.of((Object[])callExpression.getArguments()).map(argument -> {
                    if (escaper == null) {
                        PythonDocumentationProvider.$$$reportNull$$$0(69);
                    }
                    if (context == null) {
                        PythonDocumentationProvider.$$$reportNull$$$0(70);
                    }
                    return PythonDocumentationProvider.describeSuperClass(argument, escaper, true, context);
                }).joining((CharSequence)escaper.apply(", "), (CharSequence)escaper.apply(callee.getText() + "("), (CharSequence)escaper.apply(")"));
                if (string == null) {
                    PythonDocumentationProvider.$$$reportNull$$$0(48);
                }
                return string;
            }
        }
        String string = escaper.apply(expression.getText());
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    private static Iterable<String> describeDecorator(@NotNull PyDecorator decorator, @NotNull Function<String, String> escapedCalleeMapper, @NotNull Function<String, String> escaper) {
        if (decorator == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(50);
        }
        if (escapedCalleeMapper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(51);
        }
        if (escaper == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(52);
        }
        ChainIterable<String> result2 = new ChainIterable<String>();
        result2.addItem(escaper.apply("@")).addItem(escapedCalleeMapper.apply(escaper.apply(PyUtil.getReadableRepr((PsiElement)decorator.getCallee(), false))));
        PyArgumentList argumentList = decorator.getArgumentList();
        if (argumentList != null) {
            result2.addItem(escaper.apply(PyUtil.getReadableRepr((PsiElement)argumentList, false)));
        }
        ChainIterable<String> chainIterable = result2;
        if (chainIterable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(53);
        }
        return chainIterable;
    }

    public String generateDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(54);
        }
        if (PydevConsoleRunner.isInPydevConsole(element) || originalElement != null && PydevConsoleRunner.isInPydevConsole(originalElement)) {
            return PydevDocumentationProvider.createDoc(element, originalElement);
        }
        return new PyDocumentationBuilder(element, originalElement).build();
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, @NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(55);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(56);
        }
        return PyDocumentationLink.elementForLink(link, context, TypeEvalContext.userInitiated(context.getProject(), context.getContainingFile()));
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String url = PythonDocumentationProvider.getOnlyUrlFor(element, originalElement);
        return url == null ? null : Collections.singletonList(url);
    }

    @Nullable
    public static String getOnlyUrlFor(PsiElement element, PsiElement originalElement) {
        String url;
        PyClass containingClass;
        Object namedElement;
        Sdk sdk;
        PsiFileSystemItem file2;
        Object object = file2 = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
        if (file2 == null) {
            return null;
        }
        if ("__init__.py".equals(file2.getName())) {
            file2 = file2.getParent();
            assert (file2 != null);
        }
        if ((sdk = PyBuiltinCache.findSdkForFile(file2)) == null) {
            return null;
        }
        QualifiedName qName = QualifiedNameFinder.findCanonicalImportPath(element, originalElement);
        if (qName == null) {
            return null;
        }
        PythonDocumentationMap map2 = PythonDocumentationMap.getInstance();
        String pyVersion = PythonDocumentationProvider.pyVersion(sdk.getVersionString());
        PsiNamedElement psiNamedElement = namedElement = element instanceof PsiNamedElement && !(element instanceof PsiFileSystemItem) ? (PsiNamedElement)element : null;
        if (namedElement instanceof PyFunction && "__init__".equals(namedElement.getName()) && (containingClass = ((PyFunction)namedElement).getContainingClass()) != null) {
            namedElement = containingClass;
        }
        if ((url = map2.urlFor(qName, (PsiNamedElement)namedElement, pyVersion)) != null) {
            return url;
        }
        for (PythonDocumentationLinkProvider provider : (PythonDocumentationLinkProvider[])Extensions.getExtensions(PythonDocumentationLinkProvider.EP_NAME)) {
            String providerUrl = provider.getExternalDocumentationUrl(element, originalElement);
            if (providerUrl == null) continue;
            return providerUrl;
        }
        return null;
    }

    @Nullable
    public static String pyVersion(@Nullable String versionString) {
        String version;
        int dot;
        String prefix = "Python ";
        if (versionString != null && versionString.startsWith("Python ") && (dot = (version = versionString.substring("Python ".length())).indexOf(46)) > 0) {
            if ((dot = version.indexOf(46, dot + 1)) > 0) {
                return version.substring(0, dot);
            }
            return version;
        }
        return null;
    }

    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        return (String)ApplicationManager.getApplication().runReadAction(() -> {
            PyStdlibDocumentationLinkProvider stdlibDocumentationLinkProvider;
            String url;
            PyClass containingClass;
            Object namedElement;
            Sdk sdk;
            PsiFileSystemItem file2;
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module2 != null && !PyDocumentationSettings.getInstance(module2).isRenderExternalDocumentation()) {
                return null;
            }
            Object object = file2 = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
            if (file2 instanceof PyiFile) {
                return null;
            }
            if (file2 == null) {
                return null;
            }
            if ("__init__.py".equals(file2.getName())) {
                file2 = file2.getParent();
                assert (file2 != null);
            }
            if ((sdk = PyBuiltinCache.findSdkForFile(file2)) == null) {
                return null;
            }
            QualifiedName moduleQName = QualifiedNameFinder.findCanonicalImportPath(element, element);
            if (moduleQName == null) {
                return null;
            }
            PsiNamedElement psiNamedElement = namedElement = element instanceof PsiNamedElement && !(element instanceof PsiFileSystemItem) ? (PsiNamedElement)element : null;
            if (namedElement instanceof PyFunction && "__init__".equals(namedElement.getName()) && (containingClass = ((PyFunction)namedElement).getContainingClass()) != null) {
                namedElement = containingClass;
            }
            if ((url = (stdlibDocumentationLinkProvider = (PyStdlibDocumentationLinkProvider)Extensions.findExtension(PythonDocumentationLinkProvider.EP_NAME, PyStdlibDocumentationLinkProvider.class)).getExternalDocumentationUrl(element, element)) == null) {
                return null;
            }
            try {
                Document document = Jsoup.parse((URL)new URL(url), (int)1000);
                String elementId = namedElement != null ? moduleQName + "." + namedElement.getName() : "module-" + moduleQName;
                document.select("a.headerlink").remove();
                Elements parents = document.getElementsByAttributeValue("id", elementId).parents();
                if (parents.isEmpty()) {
                    Elements moduleElement = document.getElementsByAttributeValue("id", "module-" + moduleQName.toString());
                    if (moduleElement != null) {
                        return moduleElement.toString();
                    }
                    return document.toString();
                }
                return ((Element)parents.get(0)).toString();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        });
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return PythonDocumentationProvider.getOnlyUrlFor(element, originalElement) != null;
    }

    public boolean canPromptToConfigureDocumentation(@NotNull PsiElement element) {
        PsiFile containingFile;
        if (element == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(57);
        }
        if ((containingFile = element.getContainingFile()) instanceof PyFile) {
            QualifiedName qName;
            Project project = element.getProject();
            VirtualFile vFile = containingFile.getVirtualFile();
            if (vFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(vFile) && (qName = QualifiedNameFinder.findCanonicalImportPath(element, element)) != null && qName.getComponentCount() > 0) {
                return true;
            }
        }
        return false;
    }

    public void promptToConfigureDocumentation(@NotNull PsiElement element) {
        if (element == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(58);
        }
        Project project = element.getProject();
        QualifiedName qName = QualifiedNameFinder.findCanonicalImportPath(element, element);
        if (qName != null && qName.getComponentCount() > 0) {
            ApplicationManager.getApplication().invokeLater(() -> {
                int rc = Messages.showOkCancelDialog((Project)project, (String)("No external documentation URL configured for module " + (String)qName.getComponents().get(0) + ".\nWould you like to configure it now?"), (String)"Python External Documentation", (Icon)Messages.getQuestionIcon());
                if (rc == 0) {
                    ShowSettingsUtilImpl.showSettingsDialog(project, "com.jetbrains.python.documentation.PythonDocumentationConfigurable", "");
                }
            }, ModalityState.NON_MODAL);
        }
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file2, @Nullable PsiElement contextElement) {
        if (editor == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(59);
        }
        if (file2 == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(60);
        }
        if (contextElement != null) {
            PyDocStringOwner docstringOwner;
            PsiReference reference;
            PyExpression callee;
            PyExpression expression;
            IElementType elementType = contextElement.getNode().getElementType();
            if (PythonDialectsTokenSetProvider.INSTANCE.getKeywordTokens().contains(elementType)) {
                return contextElement;
            }
            PsiElement parent = contextElement.getParent();
            if (parent instanceof PyArgumentList && (PyTokenTypes.LPAR == elementType || PyTokenTypes.RPAR == elementType) && (expression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyCallExpression.class)) != null && (callee = expression.getCallee()) != null && (reference = callee.getReference()) != null) {
                return reference.resolve();
            }
            expression = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyExpression.class);
            if (expression != null && DocStringUtil.isDocStringExpression(expression) && (docstringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyDocStringOwner.class)) != null) {
                return docstringOwner;
            }
        }
        return super.getCustomDocumentationElement(editor, file2, contextElement);
    }

    private static void appendWithTags(@NotNull StringBuilder result2, @NotNull String escapedContent, String ... tags) {
        if (result2 == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(61);
        }
        if (escapedContent == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(62);
        }
        if (tags == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(63);
        }
        for (String tag : tags) {
            result2.append("<").append(tag).append(">");
        }
        result2.append(escapedContent);
        for (int i = tags.length - 1; i >= 0; --i) {
            result2.append("</").append(tags[i]).append(">");
        }
    }

    @NotNull
    private static String escaped(@NotNull String unescaped) {
        if (unescaped == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(64);
        }
        String string = StringUtil.escapeXml((String)unescaped);
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(65);
        }
        return string;
    }

    @NotNull
    private static String formatTypeWithLinks(@Nullable PyType type, @NotNull PsiElement anchor2, @NotNull TypeEvalContext context) {
        if (anchor2 == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(66);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(67);
        }
        ChainIterable<String> holder = new ChainIterable<String>();
        PythonDocumentationProvider.describeTypeWithLinks(type, context, anchor2, holder);
        String string = holder.toString();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(68);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 15: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 65: 
            case 68: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 15: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 65: 
            case 68: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 29: 
            case 40: 
            case 44: 
            case 56: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 15: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PythonDocumentationProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 16: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: 
            case 33: 
            case 39: 
            case 43: 
            case 52: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escaper";
                break;
            }
            case 25: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratable";
                break;
            }
            case 32: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedCalleeMapper";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedNameMapper";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 54: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedContent";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unescaped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PythonDocumentationProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "describeFunction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "describeTarget";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "describeParameter";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "describeFunctionWithTypes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHint";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDescription";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeModel";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "describeDecorators";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "describeClass";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "describeSuperClass";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "describeDecorator";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "escaped";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypeWithLinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDocStringSummary";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "describeFunction";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 15: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 65: 
            case 68: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showOverloads";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "describeTarget";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "describeParameter";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "describeFunctionWithTypes";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "describeExpression";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTypeHint";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "describeTypeWithLinks";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDescription";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeModel";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "describeDecorators";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "describeClass";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "describeSuperClass";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "describeDecorator";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "generateDoc";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationElementForLink";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "canPromptToConfigureDocumentation";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "promptToConfigureDocumentation";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "appendWithTags";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "escaped";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "formatTypeWithLinks";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$describeSuperClass$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 15: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 65: 
            case 68: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

