/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.stdlib.PyNamedTupleType;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.DocumentationBuilderKit;
import com.jetbrains.python.documentation.PyDocumentationLink;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyDynamicallyEvaluatedType;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.toolbox.ChainIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeModelBuilder {
    private final Map<PyType, TypeModel> myVisited = Maps.newHashMap();
    private final TypeEvalContext myContext;

    PyTypeModelBuilder(TypeEvalContext context) {
        this.myContext = context;
    }

    public TypeModel build(@Nullable PyType type, boolean allowUnions) {
        TypeModel evaluated = this.myVisited.get(type);
        if (evaluated != null) {
            return evaluated;
        }
        if (this.myVisited.containsKey(type)) {
            return NamedType.nameOrAny(type);
        }
        this.myVisited.put(type, null);
        TypeModel result2 = null;
        if (type instanceof PyInstantiableType && ((PyInstantiableType)type).isDefinition()) {
            Object instanceType = ((PyInstantiableType)type).toInstance();
            result2 = type instanceof PyClassType && instanceType.equals(PyBuiltinCache.getInstance((PsiElement)((PyClassType)type).getPyClass()).getTypeType()) ? NamedType.nameOrAny(type) : new ClassObjectType(this.build((PyType)instanceType, allowUnions));
        } else if (type instanceof PyNamedTupleType) {
            result2 = NamedType.nameOrAny(type);
        } else if (type instanceof PyTupleType) {
            PyTupleType tupleType = (PyTupleType)type;
            List<PyType> elementTypes = tupleType.isHomogeneous() ? Collections.singletonList(tupleType.getIteratedItemType()) : tupleType.getElementTypes();
            List elementModels = ContainerUtil.map(elementTypes, elementType -> this.build((PyType)elementType, true));
            result2 = new TupleType(elementModels, tupleType.isHomogeneous());
        } else if (type instanceof PyCollectionType) {
            String name = type.getName();
            List<PyType> elementTypes = ((PyCollectionType)type).getElementTypes();
            ArrayList<TypeModel> elementModels = new ArrayList<TypeModel>();
            for (PyType elementType2 : elementTypes) {
                elementModels.add(this.build(elementType2, true));
            }
            if (!elementModels.isEmpty()) {
                result2 = new CollectionOf(name, elementModels);
            }
        } else if (type instanceof PyUnionType && allowUnions) {
            PyUnionType unionType = (PyUnionType)type;
            Collection<PyType> unionMembers = unionType.getMembers();
            Ref<PyType> optionalType = PyTypeModelBuilder.getOptionalType(unionType);
            if (optionalType != null) {
                result2 = new OptionalType(this.build((PyType)optionalType.get(), true));
            } else if (type instanceof PyDynamicallyEvaluatedType || PyTypeChecker.isUnknown(type, false, this.myContext)) {
                result2 = new UnknownType(this.build(unionType.excludeNull(this.myContext), true));
            } else if (unionMembers.stream().allMatch(t -> t instanceof PyClassType && ((PyClassType)t).isDefinition())) {
                List instanceTypes = ContainerUtil.map(unionMembers, t -> this.build((PyType)((PyClassType)t).toInstance(), allowUnions));
                result2 = new ClassObjectType(new OneOf(instanceTypes));
            } else {
                result2 = new OneOf(Collections2.transform(unionMembers, t -> this.build((PyType)t, false)));
            }
        } else if (type instanceof PyCallableType && !(type instanceof PyClassLikeType)) {
            result2 = this.buildCallable((PyCallableType)type);
        } else if (type instanceof PyGenericType) {
            result2 = new GenericType(type.getName());
        }
        if (result2 == null) {
            result2 = NamedType.nameOrAny(type);
        }
        this.myVisited.put(type, result2);
        return result2;
    }

    @Nullable
    private static Ref<PyType> getOptionalType(@NotNull PyUnionType type) {
        Collection<PyType> members;
        if (type == null) {
            PyTypeModelBuilder.$$$reportNull$$$0(0);
        }
        if ((members = type.getMembers()).size() == 2) {
            boolean foundNone = false;
            PyType optional = null;
            for (PyType member : members) {
                if (PyNoneType.INSTANCE.equals(member)) {
                    foundNone = true;
                    continue;
                }
                if (member == null) continue;
                optional = member;
            }
            if (foundNone) {
                return Ref.create(optional);
            }
        }
        return null;
    }

    private TypeModel buildCallable(@NotNull PyCallableType type) {
        if (type == null) {
            PyTypeModelBuilder.$$$reportNull$$$0(1);
        }
        ArrayList<ParamType> parameterModels = null;
        List<PyCallableParameter> parameters2 = type.getParameters(this.myContext);
        if (parameters2 != null) {
            parameterModels = new ArrayList<ParamType>();
            for (PyCallableParameter parameter : parameters2) {
                parameterModels.add(new ParamType(parameter.getName(), this.build(parameter.getType(this.myContext), true)));
            }
        }
        PyType ret = type.getReturnType(this.myContext);
        TypeModel returnType = this.build(ret, true);
        return new FunctionType(returnType, parameterModels);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "type";
        objectArray2[1] = "com/jetbrains/python/documentation/PyTypeModelBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOptionalType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "buildCallable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class TypeNameVisitor
    implements TypeVisitor {
        private int myDepth = 0;
        private static final int MAX_DEPTH = 6;

        private TypeNameVisitor() {
        }

        @Override
        public void oneOf(OneOf oneOf) {
            ++this.myDepth;
            if (this.maxDepthExceeded()) {
                this.add("...");
                return;
            }
            this.add("Union[");
            this.processList(oneOf.oneOfTypes);
            this.add("]");
            --this.myDepth;
        }

        protected void processList(@NotNull Collection<TypeModel> list2) {
            if (list2 == null) {
                TypeNameVisitor.$$$reportNull$$$0(0);
            }
            boolean first = true;
            for (TypeModel t : list2) {
                if (!first) {
                    this.add(", ");
                } else {
                    first = false;
                }
                t.accept(this);
            }
        }

        protected abstract void add(String var1);

        @Override
        public void collectionOf(CollectionOf collectionOf) {
            ++this.myDepth;
            if (this.maxDepthExceeded()) {
                this.add("...");
                return;
            }
            boolean allTypeParamsAreAny = ContainerUtil.and((Iterable)collectionOf.elementTypes, t -> t == NamedType.ANY);
            if (allTypeParamsAreAny) {
                this.name(collectionOf.collectionName);
            } else {
                this.typingGenericFormat(collectionOf);
            }
            --this.myDepth;
        }

        protected void typingGenericFormat(CollectionOf collectionOf) {
            String name = collectionOf.collectionName;
            this.addType((String)PyTypingTypeProvider.TYPING_COLLECTION_CLASSES.getOrDefault((Object)name, (Object)name));
            if (!collectionOf.elementTypes.isEmpty()) {
                this.add("[");
                this.processList(collectionOf.elementTypes);
                this.add("]");
            }
        }

        protected abstract void addType(String var1);

        @Override
        public void name(String name) {
            this.addType(name);
        }

        @Override
        public void function(FunctionType function) {
            ++this.myDepth;
            if (this.maxDepthExceeded()) {
                this.add("...");
                return;
            }
            this.add("(");
            Collection parameters2 = function.parameters;
            if (parameters2 != null) {
                this.processList(parameters2);
            } else {
                this.add("...");
            }
            this.add(") -> ");
            function.returnType.accept(this);
            --this.myDepth;
        }

        protected boolean maxDepthExceeded() {
            return this.myDepth > 6;
        }

        @Override
        public void param(ParamType param) {
            ++this.myDepth;
            if (this.maxDepthExceeded()) {
                this.add("...");
                return;
            }
            if (param.name != null) {
                this.add(param.name);
            }
            if (param.type != null) {
                if (param.name != null) {
                    this.add(": ");
                }
                param.type.accept(this);
            }
            --this.myDepth;
        }

        @Override
        public void unknown(UnknownType type) {
            type.type.accept(this);
        }

        @Override
        public void optional(OptionalType type) {
            this.add("Optional[");
            type.type.accept(this);
            this.add("]");
        }

        @Override
        public void tuple(TupleType type) {
            this.add("Tuple");
            if (!type.members.isEmpty()) {
                this.add("[");
                this.processList(type.members);
                if (type.homogeneous) {
                    this.add(", ...");
                }
                this.add("]");
            }
        }

        @Override
        public void classObject(ClassObjectType type) {
            this.add("Type[");
            type.classType.accept(this);
            this.add("]");
        }

        @Override
        public void genericType(GenericType type) {
            this.add(type.name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeNameVisitor", "processList"));
        }
    }

    private static class TypeToDescriptionVisitor
    extends TypeNameVisitor {
        @NotNull
        private final StringBuilder myResult = new StringBuilder();

        private TypeToDescriptionVisitor() {
        }

        @Override
        protected void add(String s) {
            this.myResult.append(s);
        }

        @Override
        protected void addType(String name) {
            this.add(name);
        }

        @NotNull
        public String getDescription() {
            String string = this.myResult.toString();
            if (string == null) {
                TypeToDescriptionVisitor.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeToDescriptionVisitor", "getDescription"));
        }
    }

    private static class TypeToBodyWithLinksVisitor
    extends TypeNameVisitor {
        private final ChainIterable<String> myBody;
        private final PsiElement myAnchor;

        public TypeToBodyWithLinksVisitor(ChainIterable<String> body, PsiElement anchor2) {
            this.myBody = body;
            this.myAnchor = anchor2;
        }

        @Override
        protected void add(String s) {
            this.myBody.addItem(DocumentationBuilderKit.combUp(s));
        }

        @Override
        protected void addType(String name) {
            TypeEvalContext context = TypeEvalContext.userInitiated(this.myAnchor.getProject(), this.myAnchor.getContainingFile());
            this.myBody.addItem(PyDocumentationLink.toPossibleClass(name, this.myAnchor, context));
        }
    }

    private static class TypeToPep484TypeHintVisitor
    extends TypeToStringVisitor {
        private TypeToPep484TypeHintVisitor() {
        }

        @Override
        protected boolean maxDepthExceeded() {
            return false;
        }

        @Override
        public void function(FunctionType function) {
            this.add("Callable[");
            Collection parameters2 = function.parameters;
            if (parameters2 != null) {
                this.add("[");
                this.processList(parameters2);
                this.add("]");
            } else {
                this.add("...");
            }
            this.add(", ");
            function.returnType.accept(this);
            this.add("]");
        }

        @Override
        public void param(ParamType param) {
            if (param.type != null) {
                param.type.accept(this);
            } else {
                this.add("Any");
            }
        }

        @Override
        public void collectionOf(CollectionOf collectionOf) {
            this.typingGenericFormat(collectionOf);
        }
    }

    private static class TypeToStringVisitor
    extends TypeNameVisitor {
        private final StringBuilder myStringBuilder = new StringBuilder();

        private TypeToStringVisitor() {
        }

        @Override
        protected void add(String s) {
            this.myStringBuilder.append(s);
        }

        @Override
        protected void addType(String name) {
            this.add(name);
        }

        public String getString() {
            return this.myStringBuilder.toString();
        }

        @Override
        public void unknown(UnknownType type) {
            TypeModel nested = type.type;
            if (nested != null) {
                this.add("Union[");
                nested.accept(this);
                this.add(", Any");
                this.add("]");
            }
        }
    }

    private static interface TypeVisitor {
        public void oneOf(OneOf var1);

        public void collectionOf(CollectionOf var1);

        public void name(String var1);

        public void function(FunctionType var1);

        public void param(ParamType var1);

        public void unknown(UnknownType var1);

        public void optional(OptionalType var1);

        public void tuple(TupleType var1);

        public void classObject(ClassObjectType var1);

        public void genericType(GenericType var1);
    }

    static class GenericType
    extends TypeModel {
        private final String name;

        public GenericType(@Nullable String name) {
            this.name = name;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                GenericType.$$$reportNull$$$0(0);
            }
            visitor2.genericType(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$GenericType", "accept"));
        }
    }

    static class ClassObjectType
    extends TypeModel {
        private final TypeModel classType;

        public ClassObjectType(TypeModel classType) {
            this.classType = classType;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                ClassObjectType.$$$reportNull$$$0(0);
            }
            visitor2.classObject(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$ClassObjectType", "accept"));
        }
    }

    static class ParamType
    extends TypeModel {
        @Nullable
        private final String name;
        @Nullable
        private final TypeModel type;

        private ParamType(@Nullable String name, @Nullable TypeModel type) {
            this.name = name;
            this.type = type;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                ParamType.$$$reportNull$$$0(0);
            }
            visitor2.param(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$ParamType", "accept"));
        }
    }

    static class FunctionType
    extends TypeModel {
        @NotNull
        private final TypeModel returnType;
        @Nullable
        private final Collection<TypeModel> parameters;

        private FunctionType(@Nullable TypeModel returnType, @Nullable Collection<TypeModel> parameters2) {
            this.returnType = returnType != null ? returnType : NamedType.ANY;
            this.parameters = parameters2;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                FunctionType.$$$reportNull$$$0(0);
            }
            visitor2.function(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$FunctionType", "accept"));
        }
    }

    static class TupleType
    extends TypeModel {
        private final List<TypeModel> members;
        private final boolean homogeneous;

        public TupleType(List<TypeModel> members, boolean homogeneous) {
            this.members = members;
            this.homogeneous = homogeneous;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                TupleType.$$$reportNull$$$0(0);
            }
            visitor2.tuple(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$TupleType", "accept"));
        }
    }

    static class OptionalType
    extends TypeModel {
        private final TypeModel type;

        private OptionalType(TypeModel type) {
            this.type = type;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                OptionalType.$$$reportNull$$$0(0);
            }
            visitor2.optional(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$OptionalType", "accept"));
        }
    }

    static class UnknownType
    extends TypeModel {
        private final TypeModel type;

        private UnknownType(TypeModel type) {
            this.type = type;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                UnknownType.$$$reportNull$$$0(0);
            }
            visitor2.unknown(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$UnknownType", "accept"));
        }
    }

    static class NamedType
    extends TypeModel {
        @NotNull
        private static final NamedType ANY = new NamedType("Any");
        @Nullable
        private final String name;

        private NamedType(@Nullable String name) {
            this.name = name;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                NamedType.$$$reportNull$$$0(0);
            }
            visitor2.name(this.name);
        }

        @NotNull
        private static NamedType nameOrAny(@Nullable PyType type) {
            NamedType namedType = type == null ? ANY : new NamedType(type.getName());
            if (namedType == null) {
                NamedType.$$$reportNull$$$0(1);
            }
            return namedType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyTypeModelBuilder$NamedType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyTypeModelBuilder$NamedType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "nameOrAny";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CollectionOf
    extends TypeModel {
        private final String collectionName;
        private final List<TypeModel> elementTypes;

        private CollectionOf(String collectionName, List<TypeModel> elementTypes) {
            this.collectionName = collectionName;
            this.elementTypes = elementTypes;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                CollectionOf.$$$reportNull$$$0(0);
            }
            visitor2.collectionOf(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$CollectionOf", "accept"));
        }
    }

    static class OneOf
    extends TypeModel {
        private final Collection<TypeModel> oneOfTypes;

        private OneOf(Collection<TypeModel> oneOfTypes) {
            this.oneOfTypes = oneOfTypes;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                OneOf.$$$reportNull$$$0(0);
            }
            visitor2.oneOf(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$OneOf", "accept"));
        }
    }

    static abstract class TypeModel {
        TypeModel() {
        }

        abstract void accept(@NotNull TypeVisitor var1);

        @NotNull
        public String asString() {
            TypeToStringVisitor visitor2 = new TypeToStringVisitor();
            this.accept(visitor2);
            String string = visitor2.getString();
            if (string == null) {
                TypeModel.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void toBodyWithLinks(@NotNull ChainIterable<String> body, @NotNull PsiElement anchor2) {
            if (body == null) {
                TypeModel.$$$reportNull$$$0(1);
            }
            if (anchor2 == null) {
                TypeModel.$$$reportNull$$$0(2);
            }
            TypeToBodyWithLinksVisitor visitor2 = new TypeToBodyWithLinksVisitor(body, anchor2);
            this.accept(visitor2);
        }

        @NotNull
        public String asDescription() {
            TypeToDescriptionVisitor visitor2 = new TypeToDescriptionVisitor();
            this.accept(visitor2);
            String string = visitor2.getDescription();
            if (string == null) {
                TypeModel.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String asPep484TypeHint() {
            TypeToPep484TypeHintVisitor visitor2 = new TypeToPep484TypeHintVisitor();
            this.accept(visitor2);
            String string = visitor2.getString();
            if (string == null) {
                TypeModel.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asString";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asDescription";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asPep484TypeHint";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "toBodyWithLinks";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

