/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.actions;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.console.PyCodeExecutor;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.run.PythonRunConfiguration;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExecuteSelectionAction
extends AnAction {
    public static final String EXECUTE_SELECTION_IN_CONSOLE = "Execute Selection in Console";

    public PyExecuteSelectionAction() {
        super(EXECUTE_SELECTION_IN_CONSOLE);
    }

    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor != null) {
            String selectionText = PyExecuteSelectionAction.getSelectionText(editor);
            if (selectionText != null) {
                PyExecuteSelectionAction.showConsoleAndExecuteCode(e, selectionText);
            } else {
                String line = PyExecuteSelectionAction.getLineUnderCaret(editor);
                if (line != null) {
                    PyExecuteSelectionAction.showConsoleAndExecuteCode(e, line.trim());
                    PyExecuteSelectionAction.moveCaretDown(editor);
                }
            }
        }
    }

    private static void moveCaretDown(Editor editor) {
        VisualPosition pos = editor.getCaretModel().getVisualPosition();
        Pair<LogicalPosition, LogicalPosition> lines2 = EditorUtil.calcSurroundingRange(editor, pos, pos);
        int offset = editor.getCaretModel().getOffset();
        LogicalPosition lineStart = (LogicalPosition)lines2.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines2.second;
        int start = editor.logicalPositionToOffset(lineStart);
        int end = editor.logicalPositionToOffset(nextLineStart);
        Document document = editor.getDocument();
        if (nextLineStart.line < document.getLineCount()) {
            int newOffset = end + offset - start;
            int nextLineEndOffset = document.getLineEndOffset(nextLineStart.line);
            if (newOffset >= nextLineEndOffset) {
                newOffset = nextLineEndOffset;
            }
            editor.getCaretModel().moveToOffset(newOffset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public static void showConsoleAndExecuteCode(@NotNull AnActionEvent e, @Nullable String selectionText) {
        if (e == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(0);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        Project project = e.getProject();
        boolean requestFocusToConsole = selectionText == null;
        PyExecuteSelectionAction.findCodeExecutor(e.getDataContext(), (Consumer<PyCodeExecutor>)((Consumer)codeExecutor -> PyExecuteSelectionAction.executeInConsole(codeExecutor, selectionText, editor)), editor, project, requestFocusToConsole);
    }

    public static void selectConsoleAndExecuteCode(@NotNull Project project, @Nullable String selectionText) {
        if (project == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(1);
        }
        DataContext dataContext = DataManager.getInstance().getDataContext();
        PyExecuteSelectionAction.selectConsole(dataContext, project, (Consumer<PyCodeExecutor>)((Consumer)codeExecutor -> PyExecuteSelectionAction.executeInConsole(codeExecutor, selectionText, null)), null, true);
    }

    private static String getLineUnderCaret(Editor editor) {
        VisualPosition caretPos = editor.getCaretModel().getVisualPosition();
        Pair<LogicalPosition, LogicalPosition> lines2 = EditorUtil.calcSurroundingRange(editor, caretPos, caretPos);
        LogicalPosition lineStart = (LogicalPosition)lines2.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines2.second;
        int start = editor.logicalPositionToOffset(lineStart);
        int end = editor.logicalPositionToOffset(nextLineStart);
        if (end <= start) {
            return null;
        }
        return editor.getDocument().getCharsSequence().subSequence(start, end).toString();
    }

    @Nullable
    private static String getSelectionText(@NotNull Editor editor) {
        if (editor == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(2);
        }
        if (editor.getSelectionModel().hasSelection()) {
            SelectionModel model = editor.getSelectionModel();
            return model.getSelectedText();
        }
        return null;
    }

    public void update(AnActionEvent e) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        Presentation presentation = e.getPresentation();
        boolean enabled = false;
        if (PyExecuteSelectionAction.isPython(editor)) {
            String text2 = PyExecuteSelectionAction.getSelectionText(editor);
            if (text2 != null) {
                presentation.setText(EXECUTE_SELECTION_IN_CONSOLE);
            } else {
                text2 = PyExecuteSelectionAction.getLineUnderCaret(editor);
                if (text2 != null) {
                    presentation.setText("Execute Line in Console");
                }
            }
            enabled = !StringUtil.isEmpty((String)text2);
        }
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
    }

    public static boolean isPython(Editor editor) {
        if (editor == null) {
            return false;
        }
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        PsiFile psi = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        return psi instanceof PyFile;
    }

    private static void selectConsole(@NotNull DataContext dataContext, @NotNull Project project, @NotNull Consumer<PyCodeExecutor> consumer, @Nullable Editor editor, boolean requestFocusToConsole) {
        if (dataContext == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(5);
        }
        Collection<RunContentDescriptor> consoles2 = PyExecuteSelectionAction.getConsoles(project);
        ExecutionHelper.selectContentDescriptor(dataContext, project, consoles2, "Select console to execute in", (Consumer<RunContentDescriptor>)((Consumer)descriptor2 -> {
            if (consumer == null) {
                PyExecuteSelectionAction.$$$reportNull$$$0(11);
            }
            if (project == null) {
                PyExecuteSelectionAction.$$$reportNull$$$0(12);
            }
            if (descriptor2 != null && descriptor2.getExecutionConsole() instanceof PyCodeExecutor) {
                ExecutionConsole console = descriptor2.getExecutionConsole();
                consumer.consume((Object)((PyCodeExecutor)console));
                if (console instanceof PythonDebugLanguageConsoleView) {
                    XDebugSession currentSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
                    if (currentSession != null) {
                        ContentManager contentManager = currentSession.getUI().getContentManager();
                        Content content = contentManager.findContent("Console");
                        contentManager.setSelectedContent(content);
                        if (requestFocusToConsole) {
                            ((PythonDebugLanguageConsoleView)console).getPydevConsoleView().requestFocus();
                        } else if (editor != null) {
                            IdeFocusManager.findInstance().requestFocus((Component)editor.getContentComponent(), true);
                        }
                    }
                } else {
                    ToolWindow toolWindow;
                    PythonConsoleToolWindow consoleToolWindow = PythonConsoleToolWindow.getInstance(project);
                    ToolWindow toolWindow2 = toolWindow = consoleToolWindow != null ? consoleToolWindow.getToolWindow() : null;
                    if (toolWindow != null && !toolWindow.isVisible()) {
                        toolWindow.show(null);
                        ContentManager contentManager = toolWindow.getContentManager();
                        Content content = contentManager.findContent(descriptor2.getDisplayName());
                        if (content != null) {
                            contentManager.setSelectedContent(content);
                        }
                    }
                }
            }
        }));
    }

    public static Collection<RunContentDescriptor> getConsoles(Project project) {
        PythonConsoleToolWindow toolWindow = PythonConsoleToolWindow.getInstance(project);
        if (toolWindow != null && toolWindow.getToolWindow().isVisible()) {
            RunContentDescriptor selectedContentDescriptor = toolWindow.getSelectedContentDescriptor();
            return selectedContentDescriptor != null ? Lists.newArrayList((Object[])new RunContentDescriptor[]{selectedContentDescriptor}) : Lists.newArrayList();
        }
        Collection<RunContentDescriptor> descriptors = ExecutionHelper.findRunningConsole(project, (NotNullFunction<RunContentDescriptor, Boolean>)((NotNullFunction)dom -> dom.getExecutionConsole() instanceof PyCodeExecutor && PyExecuteSelectionAction.isAlive(dom)));
        if (descriptors.isEmpty() && toolWindow != null && toolWindow.isInitialized()) {
            return toolWindow.getConsoleContentDescriptors();
        }
        return descriptors;
    }

    private static boolean isAlive(RunContentDescriptor dom) {
        ProcessHandler processHandler2 = dom.getProcessHandler();
        return processHandler2 != null && !processHandler2.isProcessTerminated();
    }

    public static void findCodeExecutor(@NotNull DataContext dataContext, @NotNull Consumer<PyCodeExecutor> consumer, @Nullable Editor editor, @Nullable Project project, boolean requestFocusToConsole) {
        if (dataContext == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(7);
        }
        if (project != null) {
            if (PyExecuteSelectionAction.canFindConsole(project, null)) {
                PyExecuteSelectionAction.selectConsole(dataContext, project, consumer, editor, requestFocusToConsole);
            } else {
                PyExecuteSelectionAction.showConsole(project, consumer);
            }
        }
    }

    private static void showConsole(Project project, Consumer<PyCodeExecutor> consumer) {
        PythonConsoleToolWindow toolWindow = PythonConsoleToolWindow.getInstance(project);
        if (toolWindow != null && toolWindow.getConsoleContentDescriptors().size() > 0) {
            toolWindow.activate(() -> {
                List<RunContentDescriptor> descs = toolWindow.getConsoleContentDescriptors();
                RunContentDescriptor descriptor2 = descs.get(0);
                if (descriptor2 != null && descriptor2.getExecutionConsole() instanceof PyCodeExecutor) {
                    consumer.consume((Object)((PyCodeExecutor)descriptor2.getExecutionConsole()));
                }
            });
        } else {
            PyExecuteSelectionAction.startNewConsoleInstance(project, consumer, null, null);
        }
    }

    public static void startNewConsoleInstance(@NotNull Project project, final @NotNull Consumer<PyCodeExecutor> consumer, @Nullable String runFileText, @Nullable PythonRunConfiguration config) {
        if (project == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(9);
        }
        PythonConsoleRunnerFactory consoleRunnerFactory = PythonConsoleRunnerFactory.getInstance();
        PydevConsoleRunner runner = runFileText == null || config == null ? consoleRunnerFactory.createConsoleRunner(project, null) : consoleRunnerFactory.createConsoleRunnerWithFile(project, null, runFileText, config);
        final PythonConsoleToolWindow toolWindow = PythonConsoleToolWindow.getInstance(project);
        runner.addConsoleListener(new PydevConsoleRunner.ConsoleListener(){

            @Override
            public void handleConsoleInitialized(LanguageConsoleView consoleView) {
                if (consoleView instanceof PyCodeExecutor) {
                    consumer.consume((Object)((PyCodeExecutor)((Object)consoleView)));
                    if (toolWindow != null) {
                        toolWindow.getToolWindow().show(null);
                    }
                }
            }
        });
        runner.run(false);
    }

    public static boolean canFindConsole(@Nullable Project project, @Nullable String sdkHome) {
        if (project != null) {
            Collection<RunContentDescriptor> descriptors = PyExecuteSelectionAction.getConsoles(project);
            if (sdkHome == null) {
                return descriptors.size() > 0;
            }
            for (RunContentDescriptor descriptor2 : descriptors) {
                PythonConsoleView pythonConsole;
                ExecutionConsole console = descriptor2.getExecutionConsole();
                if (!(console instanceof PythonConsoleView) || !(pythonConsole = (PythonConsoleView)console).getText().startsWith(sdkHome)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void executeInConsole(@NotNull PyCodeExecutor codeExecutor, @Nullable String text2, @Nullable Editor editor) {
        if (codeExecutor == null) {
            PyExecuteSelectionAction.$$$reportNull$$$0(10);
        }
        codeExecutor.executeCode(text2, editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeExecutor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/actions/PyExecuteSelectionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showConsoleAndExecuteCode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "selectConsoleAndExecuteCode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectionText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "selectConsole";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findCodeExecutor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "startNewConsoleInstance";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "executeInConsole";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$selectConsole$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

