/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.impl.JsonErrorPriority;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.fixes.AddMissingPropertyFix;
import com.jetbrains.jsonSchema.impl.fixes.RemoveProhibitedPropertyFix;
import com.jetbrains.jsonSchema.impl.fixes.SuggestEnumValuesFix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class JsonValidationError {
    private final String myMessage;
    private final FixableIssueKind myFixableIssueKind;
    private final IssueData myIssueData;
    private final JsonErrorPriority myPriority;

    public IssueData getIssueData() {
        return this.myIssueData;
    }

    public JsonErrorPriority getPriority() {
        return this.myPriority;
    }

    public JsonValidationError(String message, FixableIssueKind fixableIssueKind, IssueData issueData, JsonErrorPriority priority) {
        this.myMessage = message;
        this.myFixableIssueKind = fixableIssueKind;
        this.myIssueData = issueData;
        this.myPriority = priority;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public FixableIssueKind getFixableIssueKind() {
        return this.myFixableIssueKind;
    }

    @Nullable
    public LocalQuickFix createFix() {
        switch (this.myFixableIssueKind) {
            case MissingProperty: {
                return new AddMissingPropertyFix((MissingMultiplePropsIssueData)this.myIssueData);
            }
            case ProhibitedProperty: {
                return new RemoveProhibitedPropertyFix((ProhibitedPropertyIssueData)this.myIssueData);
            }
            case NonEnumValue: {
                return new SuggestEnumValuesFix();
            }
        }
        return null;
    }

    public static class TypeMismatchIssueData
    implements IssueData {
        public final JsonSchemaType[] expectedTypes;

        public TypeMismatchIssueData(JsonSchemaType[] expectedTypes) {
            this.expectedTypes = expectedTypes;
        }
    }

    public static class ProhibitedPropertyIssueData
    implements IssueData {
        public final String propertyName;

        public ProhibitedPropertyIssueData(String propertyName) {
            this.propertyName = propertyName;
        }
    }

    public static class MissingPropertyIssueData
    implements IssueData {
        public final String propertyName;
        public final JsonSchemaType propertyType;
        public final Object defaultValue;
        public final boolean hasEnumItems;

        public MissingPropertyIssueData(String propertyName, JsonSchemaType propertyType, Object defaultValue, boolean hasEnumItems) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.defaultValue = defaultValue;
            this.hasEnumItems = hasEnumItems;
        }
    }

    public static class MissingMultiplePropsIssueData
    implements IssueData {
        public final Collection<MissingPropertyIssueData> myMissingPropertyIssues;

        public MissingMultiplePropsIssueData(Collection<MissingPropertyIssueData> missingPropertyIssues) {
            this.myMissingPropertyIssues = missingPropertyIssues;
        }

        public String getMessage(boolean trimIfNeeded) {
            if (this.myMissingPropertyIssues.size() == 1) {
                return "property '" + this.myMissingPropertyIssues.iterator().next().propertyName + "'";
            }
            ArrayList namesToDisplay = this.myMissingPropertyIssues;
            boolean trimmed = false;
            if (trimIfNeeded && namesToDisplay.size() > 3) {
                namesToDisplay = ContainerUtil.newArrayList();
                Iterator<MissingPropertyIssueData> iterator = this.myMissingPropertyIssues.iterator();
                for (int i = 0; i < 3; ++i) {
                    namesToDisplay.add(iterator.next());
                }
                trimmed = true;
            }
            String allNames = this.myMissingPropertyIssues.stream().map(p -> "'" + p.propertyName + "'").collect(Collectors.joining(", "));
            if (trimmed) {
                allNames = allNames + ", ...";
            }
            return "properties " + allNames;
        }
    }

    public static interface IssueData {
    }

    public static enum FixableIssueKind {
        MissingProperty,
        ProhibitedProperty,
        NonEnumValue,
        ProhibitedType,
        TypeMismatch,
        None;

    }
}

