/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.xml.breadcrumbs.ToggleBreadcrumbsAction;

class ToggleBreadcrumbsSettingsAction
extends ToggleBreadcrumbsAction {
    private final boolean show;
    private final boolean above;

    private ToggleBreadcrumbsSettingsAction(boolean show, boolean above) {
        this.show = show;
        this.above = above;
    }

    @Override
    boolean isSelected(Editor editor) {
        boolean selected = super.isSelected(editor);
        if (!this.show && !selected) {
            return true;
        }
        if (!this.show || !selected) {
            return false;
        }
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        return this.above == settings.isBreadcrumbsAbove();
    }

    @Override
    boolean setSelected(Boolean selected, Editor editor) {
        boolean modified = super.setSelected(null, editor);
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (settings.setBreadcrumbsShown(this.show)) {
            modified = true;
        }
        if (this.show) {
            String languageID;
            if (settings.setBreadcrumbsAbove(this.above)) {
                modified = true;
            }
            if ((languageID = ToggleBreadcrumbsSettingsAction.findLanguageID(editor)) != null && settings.setBreadcrumbsShownFor(languageID, true)) {
                modified = true;
            }
        }
        return modified;
    }

    static final class HideBoth
    extends ToggleBreadcrumbsSettingsAction {
        public HideBoth() {
            super(false, false);
        }
    }

    static final class ShowBelow
    extends ToggleBreadcrumbsSettingsAction {
        public ShowBelow() {
            super(true, false);
        }
    }

    static final class ShowAbove
    extends ToggleBreadcrumbsSettingsAction {
        public ShowAbove() {
            super(true, true);
        }
    }
}

