/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XDebuggerInlayUtil {
    public static void createInlay(@NotNull Project project, @NotNull VirtualFile file2, int offset, String inlayText) {
        if (project == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(1);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            FileEditor editor;
            if (project == null) {
                XDebuggerInlayUtil.$$$reportNull$$$0(4);
            }
            if (file2 == null) {
                XDebuggerInlayUtil.$$$reportNull$$$0(5);
            }
            if ((editor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file2)) instanceof TextEditor) {
                int insertOffset;
                Editor e = ((TextEditor)editor).getEditor();
                CharSequence text2 = e.getDocument().getImmutableCharSequence();
                for (insertOffset = offset; insertOffset < text2.length() && Character.isJavaIdentifierPart(text2.charAt(insertOffset)); ++insertOffset) {
                }
                List existing = e.getInlayModel().getInlineElementsInRange(insertOffset, insertOffset);
                for (Inlay inlay : existing) {
                    if (!(inlay.getRenderer() instanceof MyRenderer)) continue;
                    Disposer.dispose((Disposable)inlay);
                }
                e.getInlayModel().addInlineElement(insertOffset, (EditorCustomElementRenderer)new MyRenderer(inlayText));
            }
        });
    }

    public static void clearInlays(@NotNull Project project) {
        if (project == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(2);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            FileEditor[] editors;
            if (project == null) {
                XDebuggerInlayUtil.$$$reportNull$$$0(3);
            }
            for (FileEditor editor : editors = FileEditorManager.getInstance((Project)project).getAllEditors()) {
                if (!(editor instanceof TextEditor)) continue;
                Editor e = ((TextEditor)editor).getEditor();
                List existing = e.getInlayModel().getInlineElementsInRange(0, e.getDocument().getTextLength());
                for (Inlay inlay : existing) {
                    if (!(inlay.getRenderer() instanceof MyRenderer)) continue;
                    Disposer.dispose((Disposable)inlay);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerInlayUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createInlay";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "clearInlays";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$clearInlays$1";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createInlay$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyRenderer
    implements EditorCustomElementRenderer {
        private final String myText;

        private MyRenderer(String text2) {
            this.myText = "(" + text2 + ")";
        }

        private static FontInfo getFontInfo(@NotNull Editor editor) {
            if (editor == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            EditorColorsScheme colorsScheme = editor.getColorsScheme();
            FontPreferences fontPreferences = colorsScheme.getFontPreferences();
            TextAttributes attributes = editor.getColorsScheme().getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE);
            int fontStyle = attributes == null ? 0 : attributes.getFontType();
            return ComplementaryFontsRegistry.getFontAbleToDisplay(97, fontStyle, fontPreferences, FontInfo.getFontRenderContext(editor.getContentComponent()));
        }

        public int calcWidthInPixels(@NotNull Editor editor) {
            if (editor == null) {
                MyRenderer.$$$reportNull$$$0(1);
            }
            FontInfo fontInfo = MyRenderer.getFontInfo(editor);
            return fontInfo.fontMetrics().stringWidth(this.myText);
        }

        public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
            TextAttributes attributes;
            if (editor == null) {
                MyRenderer.$$$reportNull$$$0(2);
            }
            if (g == null) {
                MyRenderer.$$$reportNull$$$0(3);
            }
            if (r == null) {
                MyRenderer.$$$reportNull$$$0(4);
            }
            if (textAttributes == null) {
                MyRenderer.$$$reportNull$$$0(5);
            }
            if ((attributes = editor.getColorsScheme().getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE)) == null) {
                return;
            }
            Color fgColor = attributes.getForegroundColor();
            if (fgColor == null) {
                return;
            }
            g.setColor(fgColor);
            FontInfo fontInfo = MyRenderer.getFontInfo(editor);
            g.setFont(fontInfo.getFont());
            FontMetrics metrics = fontInfo.fontMetrics();
            g.drawString(this.myText, r.x, r.y + metrics.getAscent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerInlayUtil$MyRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFontInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

