/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GraphLayoutBuilder {
    private static final Logger LOG = Logger.getInstance(GraphLayoutBuilder.class);
    @NotNull
    private final LinearGraph myGraph;
    @NotNull
    private final int[] myLayoutIndex;
    @NotNull
    private final List<Integer> myHeadNodeIndex;
    @NotNull
    private final int[] myStartLayoutIndexForHead;
    private int currentLayoutIndex;

    @NotNull
    public static GraphLayoutImpl build(@NotNull LinearGraph graph, @NotNull Comparator<Integer> headNodeIndexComparator) {
        if (graph == null) {
            GraphLayoutBuilder.$$$reportNull$$$0(0);
        }
        if (headNodeIndexComparator == null) {
            GraphLayoutBuilder.$$$reportNull$$$0(1);
        }
        List<Integer> heads = new ArrayList();
        for (int i = 0; i < graph.nodesCount(); ++i) {
            if (LinearGraphUtils.getUpNodes(graph, i).size() != 0) continue;
            heads.add(i);
        }
        try {
            heads = ContainerUtil.sorted(heads, headNodeIndexComparator);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        GraphLayoutBuilder builder2 = new GraphLayoutBuilder(graph, heads);
        GraphLayoutImpl graphLayoutImpl = builder2.build();
        if (graphLayoutImpl == null) {
            GraphLayoutBuilder.$$$reportNull$$$0(2);
        }
        return graphLayoutImpl;
    }

    private GraphLayoutBuilder(@NotNull LinearGraph graph, @NotNull List<Integer> headNodeIndex) {
        if (graph == null) {
            GraphLayoutBuilder.$$$reportNull$$$0(3);
        }
        if (headNodeIndex == null) {
            GraphLayoutBuilder.$$$reportNull$$$0(4);
        }
        this.currentLayoutIndex = 1;
        this.myGraph = graph;
        this.myLayoutIndex = new int[graph.nodesCount()];
        this.myHeadNodeIndex = headNodeIndex;
        this.myStartLayoutIndexForHead = new int[headNodeIndex.size()];
    }

    private void dfs(int nodeIndex) {
        DfsUtil.walk(nodeIndex, new DfsUtil.NextNode(){

            @Override
            public int fun(int currentNode) {
                boolean firstVisit;
                boolean bl = firstVisit = GraphLayoutBuilder.this.myLayoutIndex[currentNode] == 0;
                if (firstVisit) {
                    ((GraphLayoutBuilder)GraphLayoutBuilder.this).myLayoutIndex[currentNode] = GraphLayoutBuilder.this.currentLayoutIndex;
                }
                int childWithoutLayoutIndex = -1;
                for (int childNodeIndex : LinearGraphUtils.getDownNodes(GraphLayoutBuilder.this.myGraph, currentNode)) {
                    if (GraphLayoutBuilder.this.myLayoutIndex[childNodeIndex] != 0) continue;
                    childWithoutLayoutIndex = childNodeIndex;
                    break;
                }
                if (childWithoutLayoutIndex == -1) {
                    if (firstVisit) {
                        GraphLayoutBuilder.this.currentLayoutIndex++;
                    }
                    return -1;
                }
                return childWithoutLayoutIndex;
            }
        });
    }

    @NotNull
    private GraphLayoutImpl build() {
        for (int i = 0; i < this.myHeadNodeIndex.size(); ++i) {
            int headNodeIndex = this.myHeadNodeIndex.get(i);
            this.myStartLayoutIndexForHead[i] = this.currentLayoutIndex;
            this.dfs(headNodeIndex);
        }
        GraphLayoutImpl graphLayoutImpl = new GraphLayoutImpl(this.myLayoutIndex, this.myHeadNodeIndex, this.myStartLayoutIndexForHead);
        if (graphLayoutImpl == null) {
            GraphLayoutBuilder.$$$reportNull$$$0(5);
        }
        return graphLayoutImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headNodeIndexComparator";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headNodeIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

