/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.RowType;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.actions.ActionController;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNodeType;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.PrintElementManagerImpl;
import com.intellij.vcs.log.graph.impl.facade.SimpleGraphInfo;
import com.intellij.vcs.log.graph.impl.print.PrintElementGeneratorImpl;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.awt.Cursor;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisibleGraphImpl<CommitId>
implements VisibleGraph<CommitId> {
    @NotNull
    private final LinearGraphController myGraphController;
    @NotNull
    private final PermanentGraphInfo<CommitId> myPermanentGraph;
    @NotNull
    private final GraphColorManager<CommitId> myColorManager;
    private PrintElementManagerImpl myPrintElementManager;
    private PrintElementGeneratorImpl myPrintElementGenerator;
    private boolean myShowLongEdges;

    public VisibleGraphImpl(@NotNull LinearGraphController graphController, @NotNull PermanentGraphInfo<CommitId> permanentGraph, @NotNull GraphColorManager<CommitId> colorManager) {
        if (graphController == null) {
            VisibleGraphImpl.$$$reportNull$$$0(0);
        }
        if (permanentGraph == null) {
            VisibleGraphImpl.$$$reportNull$$$0(1);
        }
        if (colorManager == null) {
            VisibleGraphImpl.$$$reportNull$$$0(2);
        }
        this.myShowLongEdges = false;
        this.myGraphController = graphController;
        this.myPermanentGraph = permanentGraph;
        this.myColorManager = colorManager;
        this.updatePrintElementGenerator();
    }

    public int getVisibleCommitCount() {
        return this.myGraphController.getCompiledGraph().nodesCount();
    }

    @NotNull
    public RowInfo<CommitId> getRowInfo(int visibleRow) {
        int nodeId = this.getNodeId(visibleRow);
        assert (nodeId >= 0);
        RowInfoImpl rowInfoImpl = new RowInfoImpl(nodeId, visibleRow);
        if (rowInfoImpl == null) {
            VisibleGraphImpl.$$$reportNull$$$0(3);
        }
        return rowInfoImpl;
    }

    public int getNodeId(int visibleRow) {
        return this.myGraphController.getCompiledGraph().getNodeId(visibleRow);
    }

    @Nullable
    public Integer getVisibleRowIndex(@NotNull CommitId commitId) {
        if (commitId == null) {
            VisibleGraphImpl.$$$reportNull$$$0(4);
        }
        int nodeId = this.myPermanentGraph.getPermanentCommitsInfo().getNodeId(commitId);
        return this.myGraphController.getCompiledGraph().getNodeIndex(nodeId);
    }

    @NotNull
    public ActionController<CommitId> getActionController() {
        ActionControllerImpl actionControllerImpl = new ActionControllerImpl();
        if (actionControllerImpl == null) {
            VisibleGraphImpl.$$$reportNull$$$0(5);
        }
        return actionControllerImpl;
    }

    private void updatePrintElementGenerator() {
        this.myPrintElementManager = new PrintElementManagerImpl(this.myGraphController.getCompiledGraph(), this.myPermanentGraph, this.myColorManager);
        this.myPrintElementGenerator = new PrintElementGeneratorImpl(this.myGraphController.getCompiledGraph(), this.myPrintElementManager, this.myShowLongEdges);
    }

    @NotNull
    public SimpleGraphInfo<CommitId> buildSimpleGraphInfo(int visibleRow, int visibleRange) {
        SimpleGraphInfo<CommitId> simpleGraphInfo = SimpleGraphInfo.build(this.myGraphController.getCompiledGraph(), this.myPermanentGraph.getPermanentGraphLayout(), this.myPermanentGraph.getPermanentCommitsInfo(), this.myPermanentGraph.getLinearGraph().nodesCount(), this.myPermanentGraph.getBranchNodeIds(), visibleRow, visibleRange);
        if (simpleGraphInfo == null) {
            VisibleGraphImpl.$$$reportNull$$$0(6);
        }
        return simpleGraphInfo;
    }

    public int getRecommendedWidth() {
        return this.myPrintElementGenerator.getRecommendedWidth();
    }

    public LinearGraph getLinearGraph() {
        return this.myGraphController.getCompiledGraph();
    }

    @NotNull
    public PermanentGraphInfo<CommitId> getPermanentGraph() {
        PermanentGraphInfo<CommitId> permanentGraphInfo = this.myPermanentGraph;
        if (permanentGraphInfo == null) {
            VisibleGraphImpl.$$$reportNull$$$0(7);
        }
        return permanentGraphInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphController";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraph";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionController";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSimpleGraphInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermanentGraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleRowIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RowInfoImpl
    implements RowInfo<CommitId> {
        private final int myNodeId;
        private final int myVisibleRow;

        public RowInfoImpl(int nodeId, int visibleRow) {
            this.myNodeId = nodeId;
            this.myVisibleRow = visibleRow;
        }

        @NotNull
        public CommitId getCommit() {
            Object CommitId2 = VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(this.myNodeId);
            if (CommitId2 == null) {
                RowInfoImpl.$$$reportNull$$$0(0);
            }
            return CommitId2;
        }

        @NotNull
        public CommitId getOneOfHeads() {
            int headNodeId = VisibleGraphImpl.this.myPermanentGraph.getPermanentGraphLayout().getOneOfHeadNodeIndex(this.myNodeId);
            Object CommitId2 = VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(headNodeId);
            if (CommitId2 == null) {
                RowInfoImpl.$$$reportNull$$$0(1);
            }
            return CommitId2;
        }

        @NotNull
        public Collection<? extends PrintElement> getPrintElements() {
            Collection<PrintElementWithGraphElement> collection = VisibleGraphImpl.this.myPrintElementGenerator.getPrintElements(this.myVisibleRow);
            if (collection == null) {
                RowInfoImpl.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @NotNull
        public RowType getRowType() {
            GraphNodeType nodeType = VisibleGraphImpl.this.myGraphController.getCompiledGraph().getGraphNode(this.myVisibleRow).getType();
            switch (nodeType) {
                case USUAL: {
                    RowType rowType = RowType.NORMAL;
                    if (rowType == null) {
                        RowInfoImpl.$$$reportNull$$$0(3);
                    }
                    return rowType;
                }
                case UNMATCHED: {
                    RowType rowType = RowType.UNMATCHED;
                    if (rowType == null) {
                        RowInfoImpl.$$$reportNull$$$0(4);
                    }
                    return rowType;
                }
            }
            throw new UnsupportedOperationException("Unsupported node type: " + (Object)((Object)nodeType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$RowInfoImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommit";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOneOfHeads";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrintElements";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRowType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class LinearGraphActionImpl
    implements LinearGraphController.LinearGraphAction {
        @Nullable
        private final PrintElementWithGraphElement myAffectedElement;
        @NotNull
        private final GraphAction.Type myType;

        public LinearGraphActionImpl(@Nullable PrintElementWithGraphElement affectedElement, @NotNull GraphAction.Type type) {
            if (type == null) {
                LinearGraphActionImpl.$$$reportNull$$$0(0);
            }
            this.myAffectedElement = affectedElement;
            this.myType = type;
        }

        @Override
        @Nullable
        public PrintElementWithGraphElement getAffectedElement() {
            return this.myAffectedElement;
        }

        @NotNull
        public GraphAction.Type getType() {
            GraphAction.Type type = this.myType;
            if (type == null) {
                LinearGraphActionImpl.$$$reportNull$$$0(1);
            }
            return type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$LinearGraphActionImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$LinearGraphActionImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class GraphAnswerImpl<CommitId>
    implements GraphAnswer<CommitId> {
        @Nullable
        private final Cursor myCursor;
        @Nullable
        private final CommitId myCommitToJump;
        @Nullable
        private final Runnable myUpdater;
        private final boolean myDoJump;

        private GraphAnswerImpl(@Nullable Cursor cursor, @Nullable CommitId commitToJump, @Nullable Runnable updater, boolean doJump) {
            this.myCursor = cursor;
            this.myCommitToJump = commitToJump;
            this.myUpdater = updater;
            this.myDoJump = doJump;
        }

        @Nullable
        public Cursor getCursorToSet() {
            return this.myCursor;
        }

        @Nullable
        public CommitId getCommitToJump() {
            return this.myCommitToJump;
        }

        @Nullable
        public Runnable getGraphUpdater() {
            return this.myUpdater;
        }

        public boolean doJump() {
            return this.myDoJump;
        }
    }

    private class ActionControllerImpl
    implements ActionController<CommitId> {
        private ActionControllerImpl() {
        }

        @Nullable
        private Integer convertToNodeId(@Nullable Integer nodeIndex) {
            if (nodeIndex == null) {
                return null;
            }
            return VisibleGraphImpl.this.getNodeId(nodeIndex);
        }

        @Nullable
        private GraphAnswer<CommitId> performArrowAction(@NotNull LinearGraphController.LinearGraphAction action) {
            PrintElementWithGraphElement affectedElement;
            if (action == null) {
                ActionControllerImpl.$$$reportNull$$$0(0);
            }
            if (!((affectedElement = action.getAffectedElement()) instanceof EdgePrintElement)) {
                return null;
            }
            EdgePrintElement edgePrintElement = (EdgePrintElement)affectedElement;
            if (!edgePrintElement.hasArrow()) {
                return null;
            }
            GraphElement graphElement = affectedElement.getGraphElement();
            if (!(graphElement instanceof GraphEdge)) {
                return null;
            }
            GraphEdge edge = (GraphEdge)graphElement;
            Integer targetId = null;
            if (edge.getType() == GraphEdgeType.NOT_LOAD_COMMIT) {
                assert (edgePrintElement.getType().equals((Object)EdgePrintElement.Type.DOWN));
                targetId = edge.getTargetId();
            }
            if (edge.getType().isNormalEdge()) {
                targetId = edgePrintElement.getType().equals((Object)EdgePrintElement.Type.DOWN) ? this.convertToNodeId(edge.getDownNodeIndex()) : this.convertToNodeId(edge.getUpNodeIndex());
            }
            if (targetId == null) {
                return null;
            }
            if (action.getType() == GraphAction.Type.MOUSE_OVER) {
                VisibleGraphImpl.this.myPrintElementManager.setSelectedElement(affectedElement);
                return new GraphAnswerImpl(LinearGraphUtils.getCursor(true), VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(targetId), null, false);
            }
            if (action.getType() == GraphAction.Type.MOUSE_CLICK) {
                return new GraphAnswerImpl(LinearGraphUtils.getCursor(false), VisibleGraphImpl.this.myPermanentGraph.getPermanentCommitsInfo().getCommitId(targetId), null, true);
            }
            return null;
        }

        @NotNull
        public GraphAnswer<CommitId> performAction(@NotNull GraphAction graphAction) {
            if (graphAction == null) {
                ActionControllerImpl.$$$reportNull$$$0(1);
            }
            VisibleGraphImpl.this.myPrintElementManager.setSelectedElements(Collections.emptySet());
            LinearGraphController.LinearGraphAction action = this.convert(graphAction);
            GraphAnswer graphAnswer = this.performArrowAction(action);
            if (graphAnswer != null) {
                GraphAnswer graphAnswer2 = graphAnswer;
                if (graphAnswer2 == null) {
                    ActionControllerImpl.$$$reportNull$$$0(2);
                }
                return graphAnswer2;
            }
            LinearGraphController.LinearGraphAnswer answer = VisibleGraphImpl.this.myGraphController.performLinearGraphAction(action);
            if (answer.getSelectedNodeIds() != null) {
                VisibleGraphImpl.this.myPrintElementManager.setSelectedElements(answer.getSelectedNodeIds());
            }
            if (answer.getGraphChanges() != null) {
                VisibleGraphImpl.this.updatePrintElementGenerator();
            }
            GraphAnswer graphAnswer3 = this.convert(answer);
            if (graphAnswer3 == null) {
                ActionControllerImpl.$$$reportNull$$$0(3);
            }
            return graphAnswer3;
        }

        public boolean areLongEdgesHidden() {
            return !VisibleGraphImpl.this.myShowLongEdges;
        }

        public void setLongEdgesHidden(boolean longEdgesHidden) {
            VisibleGraphImpl.this.myShowLongEdges = !longEdgesHidden;
            VisibleGraphImpl.this.updatePrintElementGenerator();
        }

        @NotNull
        private LinearGraphController.LinearGraphAction convert(@NotNull GraphAction graphAction) {
            if (graphAction == null) {
                ActionControllerImpl.$$$reportNull$$$0(4);
            }
            PrintElementWithGraphElement printElement = null;
            PrintElement affectedElement = graphAction.getAffectedElement();
            if (affectedElement != null) {
                if (affectedElement instanceof PrintElementWithGraphElement) {
                    printElement = (PrintElementWithGraphElement)affectedElement;
                } else {
                    printElement = (PrintElementWithGraphElement)ContainerUtil.find(VisibleGraphImpl.this.myPrintElementGenerator.getPrintElements(affectedElement.getRowIndex()), it -> it.equals(affectedElement));
                    if (printElement == null) {
                        throw new IllegalStateException("Not found graphElement for this printElement: " + affectedElement);
                    }
                }
            }
            LinearGraphActionImpl linearGraphActionImpl = new LinearGraphActionImpl(printElement, graphAction.getType());
            if (linearGraphActionImpl == null) {
                ActionControllerImpl.$$$reportNull$$$0(5);
            }
            return linearGraphActionImpl;
        }

        private GraphAnswer<CommitId> convert(@NotNull LinearGraphController.LinearGraphAnswer answer) {
            if (answer == null) {
                ActionControllerImpl.$$$reportNull$$$0(6);
            }
            Runnable graphUpdater = answer.getGraphUpdater();
            return new GraphAnswerImpl(answer.getCursorToSet(), null, graphUpdater == null ? null : () -> {
                graphUpdater.run();
                VisibleGraphImpl.this.updatePrintElementGenerator();
            }, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graphAction";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "answer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "performAction";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "performArrowAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "performAction";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "convert";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

