/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import org.jetbrains.annotations.NotNull;

public class VirtualDomParentStrategy
implements DomParentStrategy {
    private final DomInvocationHandler myParentHandler;
    private long myModCount;
    private final PsiFile myModificationTracker;

    public VirtualDomParentStrategy(@NotNull DomInvocationHandler parentHandler) {
        if (parentHandler == null) {
            VirtualDomParentStrategy.$$$reportNull$$$0(0);
        }
        this.myParentHandler = parentHandler;
        this.myModificationTracker = parentHandler.getFile();
        this.myModCount = this.getModCount();
    }

    private long getModCount() {
        return this.myModificationTracker.getModificationStamp();
    }

    @Override
    @NotNull
    public DomInvocationHandler getParentHandler() {
        DomInvocationHandler domInvocationHandler = this.myParentHandler;
        if (domInvocationHandler == null) {
            VirtualDomParentStrategy.$$$reportNull$$$0(1);
        }
        return domInvocationHandler;
    }

    @Override
    public XmlElement getXmlElement() {
        return null;
    }

    @Override
    @NotNull
    public synchronized DomParentStrategy refreshStrategy(DomInvocationHandler handler2) {
        long modCount = this.getModCount();
        if (modCount != this.myModCount) {
            if (!this.myParentHandler.isValid()) {
                VirtualDomParentStrategy virtualDomParentStrategy = this;
                if (virtualDomParentStrategy == null) {
                    VirtualDomParentStrategy.$$$reportNull$$$0(2);
                }
                return virtualDomParentStrategy;
            }
            XmlElement xmlElement = handler2.recomputeXmlElement(this.myParentHandler);
            if (xmlElement != null) {
                PhysicalDomParentStrategy physicalDomParentStrategy = new PhysicalDomParentStrategy(xmlElement, DomManagerImpl.getDomManager(xmlElement.getProject()));
                if (physicalDomParentStrategy == null) {
                    VirtualDomParentStrategy.$$$reportNull$$$0(3);
                }
                return physicalDomParentStrategy;
            }
            this.myModCount = modCount;
        }
        VirtualDomParentStrategy virtualDomParentStrategy = this;
        if (virtualDomParentStrategy == null) {
            VirtualDomParentStrategy.$$$reportNull$$$0(4);
        }
        return virtualDomParentStrategy;
    }

    @Override
    @NotNull
    public DomParentStrategy setXmlElement(@NotNull XmlElement element) {
        if (element == null) {
            VirtualDomParentStrategy.$$$reportNull$$$0(5);
        }
        PhysicalDomParentStrategy physicalDomParentStrategy = new PhysicalDomParentStrategy(element, DomManagerImpl.getDomManager(element.getProject()));
        if (physicalDomParentStrategy == null) {
            VirtualDomParentStrategy.$$$reportNull$$$0(6);
        }
        return physicalDomParentStrategy;
    }

    @Override
    @NotNull
    public synchronized DomParentStrategy clearXmlElement() {
        this.myModCount = this.getModCount();
        VirtualDomParentStrategy virtualDomParentStrategy = this;
        if (virtualDomParentStrategy == null) {
            VirtualDomParentStrategy.$$$reportNull$$$0(7);
        }
        return virtualDomParentStrategy;
    }

    @Override
    public synchronized String checkValidity() {
        if (this.getModCount() == this.myModCount) {
            return null;
        }
        return "mod count changed";
    }

    @Override
    public XmlFile getContainingFile(DomInvocationHandler handler2) {
        return DomImplUtil.getFile(handler2);
    }

    @Override
    public boolean isPhysical() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualDomParentStrategy)) {
            return false;
        }
        VirtualDomParentStrategy that = (VirtualDomParentStrategy)o;
        return this.myParentHandler.equals((Object)that.myParentHandler);
    }

    public int hashCode() {
        return this.myParentHandler.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/VirtualDomParentStrategy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/VirtualDomParentStrategy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshStrategy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setXmlElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "clearXmlElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setXmlElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

