/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependenciesToolWindow;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class DependenciesHandlerBase {
    protected final Project myProject;
    private final List<AnalysisScope> myScopes;
    private final Set<PsiFile> myExcluded;

    public DependenciesHandlerBase(Project project, List<AnalysisScope> scopes, Set<PsiFile> excluded) {
        this.myScopes = scopes;
        this.myExcluded = excluded;
        this.myProject = project;
    }

    public void analyze() {
        final ArrayList builders2 = new ArrayList();
        Object task2 = this.canStartInBackground() ? new Task.Backgroundable(this.myProject, this.getProgressTitle(), true, new PerformAnalysisInBackgroundOption(this.myProject)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(false);
                DependenciesHandlerBase.this.perform(builders2);
            }

            public void onSuccess() {
                DependenciesHandlerBase.this.onSuccess(builders2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/packageDependencies/actions/DependenciesHandlerBase$1", "run"));
            }
        } : new Task.Modal(this.myProject, this.getProgressTitle(), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(false);
                DependenciesHandlerBase.this.perform(builders2);
            }

            public void onSuccess() {
                DependenciesHandlerBase.this.onSuccess(builders2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/packageDependencies/actions/DependenciesHandlerBase$2", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    protected boolean canStartInBackground() {
        return true;
    }

    protected boolean shouldShowDependenciesPanel(List<DependenciesBuilder> builders2) {
        return true;
    }

    protected abstract String getProgressTitle();

    protected abstract String getPanelDisplayName(AnalysisScope var1);

    protected abstract DependenciesBuilder createDependenciesBuilder(AnalysisScope var1);

    private void perform(List<DependenciesBuilder> builders2) {
        try {
            PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
            for (AnalysisScope scope : this.myScopes) {
                builders2.add(this.createDependenciesBuilder(scope));
            }
            for (DependenciesBuilder builder2 : builders2) {
                builder2.analyze();
            }
            snapshot.logResponsivenessSinceCreation("Dependency analysis");
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)this.myProject).showDumbModeNotification("Analyze dependencies is not available until indices are ready");
            throw new ProcessCanceledException();
        }
    }

    private void onSuccess(List<DependenciesBuilder> builders2) {
        SwingUtilities.invokeLater(() -> {
            if (this.shouldShowDependenciesPanel(builders2)) {
                String displayName = this.getPanelDisplayName(builders2);
                DependenciesPanel panel2 = new DependenciesPanel(this.myProject, builders2, this.myExcluded);
                Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel2, displayName, false);
                content.setDisposer((Disposable)panel2);
                panel2.setContent(content);
                DependenciesToolWindow.getInstance(this.myProject).addContent(content);
            }
        });
    }

    protected String getPanelDisplayName(List<DependenciesBuilder> builders2) {
        return this.getPanelDisplayName(builders2.get(0).getScope());
    }
}

