/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class LineStatusActionBase
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (project == null || editor == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(editor.getDocument());
        if (!(tracker != null && tracker.isValid() && tracker.isAvailableAt(editor) && this.isEnabled(tracker, editor))) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (!LineStatusActionBase.isSomeChangeSelected(editor, tracker)) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getRequiredData(CommonDataKeys.EDITOR);
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(editor.getDocument());
        assert (tracker != null);
        this.doAction(tracker, editor);
    }

    private static boolean isSomeChangeSelected(@NotNull Editor editor, @NotNull LineStatusTrackerBase<?> tracker) {
        List carets;
        if (editor == null) {
            LineStatusActionBase.$$$reportNull$$$0(0);
        }
        if (tracker == null) {
            LineStatusActionBase.$$$reportNull$$$0(1);
        }
        if ((carets = editor.getCaretModel().getAllCarets()).size() != 1) {
            return true;
        }
        Caret caret = (Caret)carets.get(0);
        if (caret.hasSelection()) {
            return true;
        }
        if (caret.getOffset() == editor.getDocument().getTextLength() && tracker.getRangeForLine(editor.getDocument().getLineCount()) != null) {
            return true;
        }
        return tracker.getRangeForLine(caret.getLogicalPosition().line) != null;
    }

    protected boolean isEnabled(@NotNull LineStatusTrackerBase<?> tracker, @NotNull Editor editor) {
        if (tracker == null) {
            LineStatusActionBase.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            LineStatusActionBase.$$$reportNull$$$0(3);
        }
        return true;
    }

    protected abstract void doAction(@NotNull LineStatusTrackerBase<?> var1, @NotNull Editor var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSomeChangeSelected";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

