/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ShowChangeMarkerAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        Data data = ShowChangeMarkerAction.getDataFromContext(e);
        boolean isEnabled = data != null && data.tracker.isValid() && data.tracker.isAvailableAt(data.editor) && this.getTargetRange(data.tracker, data.editor) != null;
        e.getPresentation().setEnabled(isEnabled);
        e.getPresentation().setVisible(data != null || e.isFromActionToolbar());
    }

    public void actionPerformed(AnActionEvent e) {
        Data data = ShowChangeMarkerAction.getDataFromContext(e);
        if (data == null) {
            return;
        }
        Range targetRange = this.getTargetRange(data.tracker, data.editor);
        if (targetRange == null) {
            return;
        }
        this.moveToRange(data.tracker, data.editor, targetRange);
    }

    @Nullable
    private static Data getDataFromContext(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(editor.getDocument());
        if (tracker == null) {
            return null;
        }
        return new Data(tracker, editor);
    }

    protected void moveToRange(@NotNull LineStatusTracker<?> tracker, @NotNull Editor editor, @NotNull Range range2) {
        if (tracker == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(1);
        }
        if (range2 == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(2);
        }
        tracker.scrollAndShowHint(range2, editor);
    }

    @Nullable
    private Range getTargetRange(@NotNull LineStatusTracker<?> tracker, @NotNull Editor editor) {
        if (tracker == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(4);
        }
        int line = editor.getCaretModel().getLogicalPosition().line;
        return this.getTargetRange(tracker, line);
    }

    @Nullable
    protected abstract Range getTargetRange(@NotNull LineStatusTracker<?> var1, int var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "moveToRange";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Data {
        @NotNull
        private final LineStatusTracker<?> tracker;
        @NotNull
        private final Editor editor;

        public Data(@NotNull LineStatusTracker<?> tracker, @NotNull Editor editor) {
            if (tracker == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                Data.$$$reportNull$$$0(1);
            }
            this.tracker = tracker;
            this.editor = editor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tracker";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction$Data";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Current
    extends ShowChangeMarkerAction {
        @Override
        protected Range getTargetRange(@NotNull LineStatusTracker<?> tracker, int line) {
            if (tracker == null) {
                Current.$$$reportNull$$$0(0);
            }
            return tracker.getRangeForLine(line);
        }

        @Override
        protected void moveToRange(@NotNull LineStatusTracker<?> tracker, @NotNull Editor editor, @NotNull Range range2) {
            if (tracker == null) {
                Current.$$$reportNull$$$0(1);
            }
            if (editor == null) {
                Current.$$$reportNull$$$0(2);
            }
            if (range2 == null) {
                Current.$$$reportNull$$$0(3);
            }
            tracker.showHint(range2, editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction$Current";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTargetRange";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveToRange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Prev
    extends ShowChangeMarkerAction {
        @Override
        protected Range getTargetRange(@NotNull LineStatusTracker<?> tracker, int line) {
            if (tracker == null) {
                Prev.$$$reportNull$$$0(0);
            }
            return tracker.getPrevRange(line);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction$Prev", "getTargetRange"));
        }
    }

    public static class Next
    extends ShowChangeMarkerAction {
        @Override
        protected Range getTargetRange(@NotNull LineStatusTracker<?> tracker, int line) {
            if (tracker == null) {
                Next.$$$reportNull$$$0(0);
            }
            return tracker.getNextRange(line);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction$Next", "getTargetRange"));
        }
    }
}

