/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.roots.impl.RootIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ModuleFileIndexImpl
extends FileIndexBase
implements ModuleFileIndex {
    private final Module myModule;

    public ModuleFileIndexImpl(Module module2, DirectoryIndex directoryIndex) {
        super(directoryIndex, FileTypeRegistry.getInstance());
        this.myModule = module2;
    }

    public boolean iterateContent(@NotNull ContentIterator processor2, @Nullable VirtualFileFilter filter) {
        if (processor2 == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(0);
        }
        Set contentRoots = (Set)ReadAction.compute(() -> {
            VirtualFile[][] allRoots;
            if (this.myModule.isDisposed()) {
                return Collections.emptySet();
            }
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
            VirtualFile[][] virtualFileArray = allRoots = ModuleFileIndexImpl.getModuleContentAndSourceRoots(this.myModule);
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile[] roots;
                for (VirtualFile root : roots = virtualFileArray[i]) {
                    DirectoryInfo parentInfo;
                    VirtualFile parent;
                    DirectoryInfo info = this.getInfoForFileOrDirectory(root);
                    if (!info.isInProject(root) || (parent = root.getParent()) != null && (parentInfo = this.myDirectoryIndex.getInfoForFile(parent)).isInProject(parent) && this.myModule.equals(parentInfo.getModule())) continue;
                    result2.add(root);
                }
            }
            return result2;
        });
        for (VirtualFile contentRoot : contentRoots) {
            if (this.iterateContentUnderDirectory(contentRoot, processor2, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(1);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInProject(fileOrDir) && this.myModule.equals(info.getModule());
    }

    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(2);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && this.myModule.equals(info.getModule());
    }

    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(3);
        }
        List<OrderEntry> list2 = ModuleFileIndexImpl.findAllOrderEntriesWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(fileOrDir)));
        if (list2 == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public OrderEntry getOrderEntryForFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(5);
        }
        return ModuleFileIndexImpl.findOrderEntryWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(fileOrDir)));
    }

    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(6);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && this.myModule.equals(info.getModule()) && JavaModuleSourceRootTypes.isTestSourceOrResource(this.myDirectoryIndex.getSourceRootType(info));
    }

    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(7);
        }
        if (rootTypes == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(8);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && this.myModule.equals(info.getModule()) && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info));
    }

    @Override
    protected boolean isScopeDisposed() {
        return this.myModule.isDisposed();
    }

    @Nullable
    public static OrderEntry findOrderEntryWithOwnerModule(@NotNull Module ownerModule, @NotNull List<OrderEntry> orderEntries) {
        if (ownerModule == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(9);
        }
        if (orderEntries == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(10);
        }
        if (orderEntries.size() < 10) {
            for (OrderEntry orderEntry : orderEntries) {
                if (orderEntry.getOwnerModule() != ownerModule) continue;
                return orderEntry;
            }
            return null;
        }
        int index = Collections.binarySearch(orderEntries, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        return index < 0 ? null : orderEntries.get(index);
    }

    @NotNull
    private static List<OrderEntry> findAllOrderEntriesWithOwnerModule(@NotNull Module ownerModule, @NotNull List<OrderEntry> entries) {
        int lastIndex;
        if (ownerModule == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(11);
        }
        if (entries == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(12);
        }
        if (entries.isEmpty()) {
            List<OrderEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                ModuleFileIndexImpl.$$$reportNull$$$0(13);
            }
            return list2;
        }
        if (entries.size() == 1) {
            OrderEntry entry = entries.get(0);
            ArrayList arrayList = entry.getOwnerModule() == ownerModule ? ContainerUtil.newArrayList(entries) : Collections.emptyList();
            if (arrayList == null) {
                ModuleFileIndexImpl.$$$reportNull$$$0(14);
            }
            return arrayList;
        }
        int index = Collections.binarySearch(entries, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        if (index < 0) {
            List<OrderEntry> list3 = Collections.emptyList();
            if (list3 == null) {
                ModuleFileIndexImpl.$$$reportNull$$$0(15);
            }
            return list3;
        }
        int firstIndex = index;
        while (firstIndex - 1 >= 0 && entries.get(firstIndex - 1).getOwnerModule() == ownerModule) {
            --firstIndex;
        }
        for (lastIndex = index + 1; lastIndex < entries.size() && entries.get(lastIndex).getOwnerModule() == ownerModule; ++lastIndex) {
        }
        ArrayList arrayList = ContainerUtil.newArrayList(entries.subList(firstIndex, lastIndex));
        if (arrayList == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerModule";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntriesForFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllOrderEntriesWithOwnerModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInSourceContent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntriesForFile";
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntryForFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSourceContent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isUnderSourceRootOfType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findOrderEntryWithOwnerModule";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAllOrderEntriesWithOwnerModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FakeOrderEntry
    implements OrderEntry {
        private final Module myOwnerModule;

        FakeOrderEntry(Module ownerModule) {
            this.myOwnerModule = ownerModule;
        }

        @NotNull
        public VirtualFile[] getFiles(@NotNull OrderRootType type) {
            if (type == null) {
                FakeOrderEntry.$$$reportNull$$$0(0);
            }
            throw new IncorrectOperationException();
        }

        @NotNull
        public String[] getUrls(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                FakeOrderEntry.$$$reportNull$$$0(1);
            }
            throw new IncorrectOperationException();
        }

        @NotNull
        public String getPresentableName() {
            throw new IncorrectOperationException();
        }

        public boolean isValid() {
            throw new IncorrectOperationException();
        }

        @NotNull
        public Module getOwnerModule() {
            Module module2 = this.myOwnerModule;
            if (module2 == null) {
                FakeOrderEntry.$$$reportNull$$$0(2);
            }
            return module2;
        }

        public <R> R accept(@NotNull RootPolicy<R> policy, @Nullable R initialValue) {
            if (policy == null) {
                FakeOrderEntry.$$$reportNull$$$0(3);
            }
            throw new IncorrectOperationException();
        }

        public int compareTo(@NotNull OrderEntry o) {
            if (o == null) {
                FakeOrderEntry.$$$reportNull$$$0(4);
            }
            throw new IncorrectOperationException();
        }

        public boolean isSynthetic() {
            throw new IncorrectOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl$FakeOrderEntry";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl$FakeOrderEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwnerModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFiles";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUrls";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

