/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="editorHistoryManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class EditorHistoryManager
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(EditorHistoryManager.class);
    private final Project myProject;
    private final List<HistoryEntry> myEntriesList;

    public static EditorHistoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            EditorHistoryManager.$$$reportNull$$$0(0);
        }
        return (EditorHistoryManager)ServiceManager.getService((Project)project, EditorHistoryManager.class);
    }

    EditorHistoryManager(@NotNull Project project) {
        if (project == null) {
            EditorHistoryManager.$$$reportNull$$$0(1);
        }
        this.myEntriesList = new ArrayList<HistoryEntry>();
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> this.trimToSize());
        connection.subscribe(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener.Before(){

            public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                EditorHistoryManager.this.updateHistoryEntry(file2, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$1";
                objectArray[2] = "beforeFileClosed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyEditorManagerListener());
    }

    private synchronized void removeEntry(@NotNull HistoryEntry entry) {
        if (entry == null) {
            EditorHistoryManager.$$$reportNull$$$0(2);
        }
        if (this.myEntriesList.remove(entry)) {
            entry.destroy();
        }
    }

    private synchronized void moveOnTop(@NotNull HistoryEntry entry) {
        if (entry == null) {
            EditorHistoryManager.$$$reportNull$$$0(3);
        }
        this.myEntriesList.remove(entry);
        this.myEntriesList.add(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileOpenedImpl(@NotNull VirtualFile file2, @Nullable FileEditor fallbackEditor, @Nullable FileEditorProvider fallbackProvider) {
        FileEditor selectedEditor;
        FileEditorProvider[] oldProviders;
        if (file2 == null) {
            EditorHistoryManager.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (VirtualFileManager.getInstance().findFileByUrl(file2.getUrl()) == null) {
            return;
        }
        FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
        Pair<FileEditor[], FileEditorProvider[]> editorsWithProviders = editorManager.getEditorsWithProviders(file2);
        Object[] editors = (FileEditor[])editorsWithProviders.getFirst();
        LOG.assertTrue(editors.length == (oldProviders = (FileEditorProvider[])editorsWithProviders.getSecond()).length, (Object)"Different number of editors and providers");
        if (editors.length <= 0 && fallbackEditor != null && fallbackProvider != null) {
            editors = new FileEditor[]{fallbackEditor};
            oldProviders = new FileEditorProvider[]{fallbackProvider};
        }
        if (editors.length <= 0) {
            LOG.error("No editors for file " + file2.getPresentableUrl());
        }
        if ((selectedEditor = editorManager.getSelectedEditor(file2)) == null) {
            selectedEditor = fallbackEditor;
        }
        LOG.assertTrue(selectedEditor != null);
        int selectedProviderIndex = ArrayUtilRt.find((Object[])editors, (Object)selectedEditor);
        LOG.assertTrue(selectedProviderIndex != -1, (Object)("Can't find " + selectedEditor + " among " + Arrays.asList(editors)));
        HistoryEntry entry = this.getEntry(file2);
        if (entry != null) {
            this.moveOnTop(entry);
        } else {
            FileEditorState[] states = new FileEditorState[editors.length];
            FileEditorProvider[] providers = new FileEditorProvider[editors.length];
            for (int i = states.length - 1; i >= 0; --i) {
                FileEditorProvider provider = oldProviders[i];
                LOG.assertTrue(provider != null);
                providers[i] = provider;
                Object editor = editors[i];
                if (!editor.isValid()) continue;
                states[i] = editor.getState(FileEditorStateLevel.FULL);
            }
            EditorHistoryManager editorHistoryManager = this;
            synchronized (editorHistoryManager) {
                this.myEntriesList.add(HistoryEntry.createHeavy(this.myProject, file2, providers, states, providers[selectedProviderIndex]));
            }
            this.trimToSize();
        }
    }

    public void updateHistoryEntry(@Nullable VirtualFile file2, boolean changeEntryOrderOnly) {
        this.updateHistoryEntry(file2, null, null, changeEntryOrderOnly);
    }

    private void updateHistoryEntry(@Nullable VirtualFile file2, @Nullable FileEditor fallbackEditor, @Nullable FileEditorProvider fallbackProvider, boolean changeEntryOrderOnly) {
        Pair<FileEditor, FileEditorProvider> selectedEditorWithProvider;
        if (file2 == null) {
            return;
        }
        FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
        Pair<FileEditor[], FileEditorProvider[]> editorsWithProviders = editorManager.getEditorsWithProviders(file2);
        FileEditor[] editors = (FileEditor[])editorsWithProviders.getFirst();
        FileEditorProvider[] providers = (FileEditorProvider[])editorsWithProviders.getSecond();
        if (editors.length <= 0 && fallbackEditor != null) {
            editors = new FileEditor[]{fallbackEditor};
            providers = new FileEditorProvider[]{fallbackProvider};
        }
        if (editors.length == 0) {
            return;
        }
        HistoryEntry entry = this.getEntry(file2);
        if (entry == null) {
            if (file2.isValid()) {
                this.fileOpenedImpl(file2, fallbackEditor, fallbackProvider);
            }
            return;
        }
        if (!changeEntryOrderOnly) {
            for (int i = editors.length - 1; i >= 0; --i) {
                FileEditor editor = editors[i];
                FileEditorProvider provider = providers[i];
                if (provider == null || !editor.isValid()) continue;
                FileEditorState oldState = entry.getState(provider);
                FileEditorState newState = editor.getState(FileEditorStateLevel.FULL);
                if (newState.equals(oldState)) continue;
                entry.putState(provider, newState);
            }
        }
        if ((selectedEditorWithProvider = editorManager.getSelectedEditorWithProvider(file2)) != null) {
            entry.setSelectedProvider((FileEditorProvider)selectedEditorWithProvider.getSecond());
            LOG.assertTrue(entry.getSelectedProvider() != null);
            if (changeEntryOrderOnly) {
                this.moveOnTop(entry);
            }
        }
    }

    @NotNull
    public synchronized VirtualFile[] getFiles() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(this.myEntriesList.size());
        for (HistoryEntry entry : this.myEntriesList) {
            VirtualFile file2 = entry.getFile();
            if (file2 == null) continue;
            result2.add(file2);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            EditorHistoryManager.$$$reportNull$$$0(5);
        }
        return virtualFileArray;
    }

    public synchronized void removeAllFiles() {
        for (HistoryEntry entry : this.myEntriesList) {
            entry.destroy();
        }
        this.myEntriesList.clear();
    }

    @NotNull
    public synchronized List<VirtualFile> getFileList() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (HistoryEntry entry : this.myEntriesList) {
            VirtualFile file2 = entry.getFile();
            if (file2 == null) continue;
            result2.add(file2);
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            EditorHistoryManager.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Deprecated
    @NotNull
    public synchronized LinkedHashSet<VirtualFile> getFileSet() {
        LinkedHashSet<VirtualFile> linkedHashSet = new LinkedHashSet<VirtualFile>(this.getFileList());
        if (linkedHashSet == null) {
            EditorHistoryManager.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    public synchronized boolean hasBeenOpen(@NotNull VirtualFile f) {
        if (f == null) {
            EditorHistoryManager.$$$reportNull$$$0(8);
        }
        for (HistoryEntry each : this.myEntriesList) {
            if (!f.equals(each.getFile())) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeFile(@NotNull VirtualFile file2) {
        HistoryEntry entry;
        if (file2 == null) {
            EditorHistoryManager.$$$reportNull$$$0(9);
        }
        if ((entry = this.getEntry(file2)) != null) {
            this.removeEntry(entry);
        }
    }

    public FileEditorState getState(@NotNull VirtualFile file2, FileEditorProvider provider) {
        HistoryEntry entry;
        if (file2 == null) {
            EditorHistoryManager.$$$reportNull$$$0(10);
        }
        return (entry = this.getEntry(file2)) != null ? entry.getState(provider) : null;
    }

    public FileEditorProvider getSelectedProvider(VirtualFile file2) {
        HistoryEntry entry = this.getEntry(file2);
        return entry != null ? entry.getSelectedProvider() : null;
    }

    private synchronized HistoryEntry getEntry(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorHistoryManager.$$$reportNull$$$0(11);
        }
        for (int i = this.myEntriesList.size() - 1; i >= 0; --i) {
            HistoryEntry entry = this.myEntriesList.get(i);
            VirtualFile entryFile = entry.getFile();
            if (!file2.equals(entryFile)) continue;
            return entry;
        }
        return null;
    }

    private synchronized void trimToSize() {
        int limit = UISettings.getInstance().getRecentFilesLimit() + 1;
        while (this.myEntriesList.size() > limit) {
            HistoryEntry removed = this.myEntriesList.remove(0);
            removed.destroy();
        }
    }

    public synchronized void loadState(@NotNull Element state2) {
        if (state2 == null) {
            EditorHistoryManager.$$$reportNull$$$0(12);
        }
        this.myEntriesList.clear();
        LinkedHashMap<String, Element> fileToElement = new LinkedHashMap<String, Element>();
        for (Element e : state2.getChildren("entry")) {
            String file2 = e.getAttributeValue("file");
            fileToElement.remove(file2);
            fileToElement.put(file2, e);
        }
        for (Element e : fileToElement.values()) {
            try {
                this.myEntriesList.add(HistoryEntry.createHeavy(this.myProject, e));
            }
            catch (ProcessCanceledException file2) {
            }
            catch (Exception anyException) {
                LOG.error((Throwable)anyException);
            }
        }
    }

    public synchronized Element getState() {
        Element element = new Element("state");
        VirtualFile[] openFiles = FileEditorManager.getInstance((Project)this.myProject).getOpenFiles();
        for (int i = openFiles.length - 1; i >= 0; --i) {
            VirtualFile file2 = openFiles[i];
            if (this.getEntry(file2) == null) continue;
            this.updateHistoryEntry(file2, false);
        }
        for (HistoryEntry entry : this.myEntriesList) {
            entry.writeExternal(element, this.myProject);
        }
        return element;
    }

    public synchronized void dispose() {
        for (HistoryEntry entry : this.myEntriesList) {
            entry.destroy();
        }
        this.myEntriesList.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorHistoryManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorHistoryManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeEntry";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveOnTop";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fileOpenedImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasBeenOpen";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEntry";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyEditorManagerListener
    implements FileEditorManagerListener {
        private MyEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                MyEditorManagerListener.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                MyEditorManagerListener.$$$reportNull$$$0(1);
            }
            EditorHistoryManager.this.fileOpenedImpl(file2, null, null);
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                MyEditorManagerListener.$$$reportNull$$$0(2);
            }
            PsiDocumentManager.getInstance((Project)EditorHistoryManager.this.myProject).performWhenAllCommitted(() -> {
                FileEditor newEditor;
                if (event == null) {
                    MyEditorManagerListener.$$$reportNull$$$0(3);
                }
                if ((newEditor = event.getNewEditor()) != null && !newEditor.isValid()) {
                    return;
                }
                EditorHistoryManager.this.updateHistoryEntry(event.getOldFile(), event.getOldEditor(), event.getOldProvider(), false);
                EditorHistoryManager.this.updateHistoryEntry(event.getNewFile(), true);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$MyEditorManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileOpened";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$selectionChanged$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class EditorHistoryManagerStartUpActivity
    implements DumbAware,
    StartupActivity {
        EditorHistoryManagerStartUpActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                EditorHistoryManagerStartUpActivity.$$$reportNull$$$0(0);
            }
            EditorHistoryManager.getInstance(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$EditorHistoryManagerStartUpActivity", "runActivity"));
        }
    }
}

