/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.idea.Main;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportSettings;
import com.intellij.openapi.application.ImportOldConfigsPanel;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.PropertyResourceBundle;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigImportHelper {
    private static final String FIRST_SESSION_KEY = "intellij.first.ide.session";
    private static final String CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY = "intellij.config.imported.in.current.session";
    private static final String CONFIG = "config";
    private static final String OPTIONS_XML = "options/options.xml";
    private static final String BIN = "bin";
    private static final String CONTENTS = "Contents";
    private static final String PLIST = "Info.plist";
    private static final String PLUGINS = "plugins";

    private ConfigImportHelper() {
    }

    public static void importConfigsTo(@NotNull String newConfigPath) {
        CloudConfigProvider provider;
        if (newConfigPath == null) {
            ConfigImportHelper.$$$reportNull$$$0(0);
        }
        System.setProperty(FIRST_SESSION_KEY, Boolean.TRUE.toString());
        ConfigImportSettings settings = ConfigImportHelper.getConfigImportSettings();
        File newConfigDir = new File(newConfigPath);
        File guessedOldConfigDir = ConfigImportHelper.findRecentConfigDirectory(newConfigDir);
        ImportOldConfigsPanel dialog2 = new ImportOldConfigsPanel(guessedOldConfigDir, f -> ConfigImportHelper.findConfigDirectoryByPath(f));
        dialog2.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        AppUIUtil.updateWindowIcon(dialog2);
        dialog2.setVisible(true);
        Pair<File, File> result2 = dialog2.getSelectedFile();
        if (result2 != null) {
            ConfigImportHelper.doImport((File)result2.first, newConfigDir, (File)result2.second);
            settings.importFinished(newConfigPath);
            System.setProperty(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY, Boolean.TRUE.toString());
        }
        if ((provider = CloudConfigProvider.getProvider()) != null) {
            provider.importFinished(newConfigDir);
        }
    }

    public static boolean isFirstSession() {
        return Boolean.getBoolean(FIRST_SESSION_KEY);
    }

    public static boolean isConfigImported() {
        return Boolean.getBoolean(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY);
    }

    private static ConfigImportSettings getConfigImportSettings() {
        try {
            String customProviderName = "com.intellij.openapi.application." + PlatformUtils.getPlatformPrefix() + "ConfigImportSettings";
            Class<?> customProviderClass = Class.forName(customProviderName);
            if (ConfigImportSettings.class.isAssignableFrom(customProviderClass)) {
                return (ConfigImportSettings)ReflectionUtil.newInstance(customProviderClass);
            }
        }
        catch (ClassNotFoundException | RuntimeException exception) {
            // empty catch block
        }
        return new ConfigImportSettings();
    }

    @Nullable
    private static File findRecentConfigDirectory(File newConfigDir) {
        String prefix;
        File configsHome = (SystemInfo.isMac ? newConfigDir : newConfigDir.getParentFile()).getParentFile();
        if (configsHome == null || !configsHome.isDirectory()) {
            return null;
        }
        String nameWithSelector = PathManager.getPathsSelector();
        if (nameWithSelector == null) {
            nameWithSelector = (SystemInfo.isMac ? newConfigDir : newConfigDir.getParentFile()).getName();
        }
        if ((prefix = ConfigImportHelper.getPrefixFromSelector(nameWithSelector)) == null) {
            return null;
        }
        File[] candidates = configsHome.listFiles((file2, name) -> StringUtil.startsWithIgnoreCase((String)name, (String)prefix));
        File result2 = null;
        if (candidates != null && candidates.length > 0) {
            long lastModified = 0L;
            for (File child : candidates) {
                File candidate = SystemInfo.isMac ? child : new File(child, CONFIG);
                long modified = new File(candidate, OPTIONS_XML).lastModified();
                if (modified <= lastModified) continue;
                lastModified = modified;
                result2 = candidate;
            }
        }
        return result2;
    }

    @Nullable
    private static String getPrefixFromSelector(String nameWithSelector) {
        String selector;
        Matcher m = Pattern.compile("\\.?([^\\d]+)\\d+(\\.\\d+)?").matcher(nameWithSelector);
        String string = selector = m.matches() ? m.group(1) : null;
        return StringUtil.isEmpty((String)selector) ? null : (SystemInfo.isMac ? selector : '.' + selector);
    }

    @Nullable
    private static Pair<File, File> findConfigDirectoryByPath(File selectedDir) {
        File configDir;
        if (ConfigImportHelper.isValidConfigDir(selectedDir)) {
            return Pair.pair((Object)selectedDir, null);
        }
        File config = new File(selectedDir, CONFIG);
        if (ConfigImportHelper.isValidConfigDir(config)) {
            return Pair.pair((Object)config, null);
        }
        if (new File(selectedDir, SystemInfo.isMac ? CONTENTS : BIN).isDirectory() && ConfigImportHelper.isValidConfigDir(configDir = ConfigImportHelper.getSettingsPath(selectedDir, "idea.config.path", PathManager::getDefaultConfigPathFor))) {
            return Pair.pair((Object)configDir, (Object)selectedDir);
        }
        return null;
    }

    private static boolean isValidConfigDir(File candidate) {
        return new File(candidate, OPTIONS_XML).isFile();
    }

    @Nullable
    private static File getSettingsPath(File ideHome, String propertyName, Function<String, String> pathBySelector) {
        File candidate;
        ArrayList<File> files2 = new ArrayList<File>();
        if (SystemInfo.isMac) {
            files2.add(new File(ideHome, "Contents/bin/idea.properties"));
            files2.add(new File(ideHome, "Contents/Info.plist"));
        } else {
            files2.add(new File(ideHome, "bin/idea.properties"));
            String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
            files2.add(new File(ideHome, "bin/" + scriptName + ".bat"));
            files2.add(new File(ideHome, "bin/" + scriptName + ".sh"));
        }
        for (File file2 : files2) {
            String candidatePath;
            if (!file2.isFile() || (candidatePath = PathManager.substituteVars((String)ConfigImportHelper.getPropertyFromFile(file2, propertyName), (String)ideHome.getPath())) == null || !(candidate = new File(candidatePath)).isDirectory()) continue;
            return candidate.getAbsoluteFile();
        }
        for (File file2 : files2) {
            String selector;
            if (!file2.isFile() || (selector = ConfigImportHelper.getPropertyFromFile(file2, "idea.paths.selector")) == null || !(candidate = new File(pathBySelector.apply(selector))).isDirectory()) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    private static String getPropertyFromFile(File file2, String propertyName) {
        try {
            String propertyValue;
            String fileContent = FileUtil.loadFile((File)file2);
            if (file2.getName().endsWith(".properties")) {
                PropertyResourceBundle bundle = new PropertyResourceBundle(new StringReader(fileContent));
                return bundle.containsKey(propertyName) ? bundle.getString(propertyName) : null;
            }
            if (file2.getName().endsWith(".plist") && !StringUtil.isEmpty((String)(propertyValue = ConfigImportHelper.findPListKey(propertyName, fileContent)))) {
                return propertyValue;
            }
            propertyValue = ConfigImportHelper.findProperty(propertyName, fileContent);
            if (!StringUtil.isEmpty((String)propertyValue)) {
                return propertyValue;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static String findPListKey(String propertyName, String fileContent) {
        String key = "<key>" + propertyName + "</key>";
        int idx = fileContent.indexOf(key);
        if (idx > 0 && (idx = fileContent.indexOf("<string>", idx + key.length())) != -1) {
            return ConfigImportHelper.fixDirName(fileContent.substring(idx += "<string>".length(), fileContent.indexOf("</string>", idx)));
        }
        return null;
    }

    @Nullable
    private static String findProperty(String propertyName, String fileContent) {
        String prefix = propertyName + "=";
        int idx = fileContent.indexOf(prefix);
        if (idx >= 0) {
            StringBuilder configDir = new StringBuilder();
            if (fileContent.length() > (idx += prefix.length())) {
                boolean quoted;
                boolean bl = quoted = fileContent.charAt(idx) == '\"';
                if (quoted) {
                    ++idx;
                }
                while (fileContent.length() > idx && (quoted ? fileContent.charAt(idx) != '\"' : fileContent.charAt(idx) != ' ' && fileContent.charAt(idx) != '\t') && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir.append(fileContent.charAt(idx));
                    ++idx;
                }
            }
            if ((configDir = new StringBuilder(ConfigImportHelper.fixDirName(configDir.toString()))).length() > 0) {
                configDir = new StringBuilder(new File(configDir.toString()).getPath());
            }
            return configDir.toString();
        }
        return null;
    }

    private static String fixDirName(String dir) {
        return FileUtil.expandUserHome((String)StringUtil.unquoteString((String)dir, (char)'\"'));
    }

    private static void doImport(File oldConfigDir, File newConfigDir, @Nullable File oldIdeHome) {
        if (FileUtil.filesEqual((File)oldConfigDir, (File)newConfigDir)) {
            return;
        }
        try {
            FileUtil.copyDir((File)oldConfigDir, (File)newConfigDir);
            FileUtil.delete((File)new File(newConfigDir, "user.token"));
            FileUtil.delete((File)new File(newConfigDir, "user.web.token"));
            File oldPluginsDir = new File(oldConfigDir, PLUGINS);
            if (SystemInfo.isMac && !oldPluginsDir.isDirectory()) {
                oldPluginsDir = null;
                if (oldIdeHome != null) {
                    oldPluginsDir = ConfigImportHelper.getSettingsPath(oldIdeHome, "idea.plugins.path", PathManager::getDefaultPluginPathFor);
                }
                if (oldPluginsDir == null) {
                    oldPluginsDir = new File(PathManager.getDefaultPluginPathFor((String)oldConfigDir.getName()));
                }
                if (oldPluginsDir.isDirectory()) {
                    File newPluginsDir = new File(PathManager.getPluginsPath());
                    FileUtil.copyDir((File)oldPluginsDir, (File)newPluginsDir);
                }
            }
            if (oldPluginsDir.isDirectory()) {
                File script;
                File oldSystemDir = null;
                if (oldIdeHome != null) {
                    oldSystemDir = ConfigImportHelper.getSettingsPath(oldIdeHome, "idea.system.path", PathManager::getDefaultSystemPathFor);
                }
                if (oldSystemDir == null) {
                    String selector = SystemInfo.isMac ? oldConfigDir.getName() : StringUtil.trimLeading((String)oldConfigDir.getParentFile().getName(), (char)'.');
                    oldSystemDir = new File(PathManager.getDefaultSystemPathFor((String)selector));
                }
                if ((script = new File(oldSystemDir, "plugins/action.script")).isFile()) {
                    File newPluginsDir = new File(PathManager.getPluginsPath());
                    StartupActionScriptManager.executeActionScript((File)script, (File)oldPluginsDir, (File)newPluginsDir);
                }
            }
        }
        catch (IOException e) {
            String message = ApplicationBundle.message((String)"error.unable.to.import.settings", (Object[])new Object[]{e.getMessage()});
            Main.showMessage((String)ApplicationBundle.message((String)"title.settings.import.failed", (Object[])new Object[0]), (String)message, (boolean)false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newConfigPath", "com/intellij/openapi/application/ConfigImportHelper", "importConfigsTo"));
    }
}

