/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesRootNode;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.SettingsProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiDirectoryImpl;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FavoritesTreeStructure
extends ProjectTreeStructure {
    private static final Logger LOGGER = Logger.getInstance(FavoritesTreeStructure.class);
    private TreeStructureProvider myNonProjectProvider = null;

    public FavoritesTreeStructure(Project project) {
        super(project, "Favorites");
        this.myNonProjectProvider = new MyProvider(project);
    }

    @Override
    protected AbstractTreeNode createRoot(Project project, ViewSettings settings) {
        return new FavoritesRootNode(project);
    }

    public void rootsChanged() {
        ((FavoritesRootNode)((Object)this.getRootElement())).rootsChanged();
    }

    @Override
    public Object[] getChildElements(Object element) {
        if (!(element instanceof AbstractTreeNode)) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        AbstractTreeNode favTreeElement = (AbstractTreeNode)element;
        try {
            if (!(element instanceof FavoritesListNode)) {
                Object[] elements = super.getChildElements(favTreeElement);
                if (elements.length > 0) {
                    return elements;
                }
                ViewSettings settings = favTreeElement instanceof SettingsProvider ? ((SettingsProvider)favTreeElement).getSettings() : ViewSettings.DEFAULT;
                return ArrayUtil.toObjectArray((Collection)this.myNonProjectProvider.modify(favTreeElement, new ArrayList(), settings));
            }
            ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
            FavoritesListNode listNode = (FavoritesListNode)((Object)element);
            if (listNode.getProvider() != null) {
                return ArrayUtil.toObjectArray(listNode.getChildren());
            }
            Collection<AbstractTreeNode> roots = FavoritesListNode.getFavoritesRoots(this.myProject, listNode.getName(), listNode);
            for (AbstractTreeNode abstractTreeNode : roots) {
                Object value = abstractTreeNode.getValue();
                if (value == null || value instanceof PsiElement && !((PsiElement)value).isValid() || value instanceof SmartPsiElementPointer && ((SmartPsiElementPointer)value).getElement() == null) continue;
                boolean invalid = false;
                for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)this.myProject)) {
                    if (!nodeProvider.isInvalidElement(value)) continue;
                    invalid = true;
                    break;
                }
                if (invalid) continue;
                result2.add(abstractTreeNode);
            }
            return ArrayUtil.toObjectArray(result2);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }

    private AbstractTreeNode<String> getEmptyScreen() {
        return new AbstractTreeNode<String>(this.myProject, IdeBundle.message((String)"favorites.empty.screen", (Object[])new Object[0])){

            @NotNull
            public Collection<AbstractTreeNode> getChildren() {
                List<AbstractTreeNode> list2 = Collections.emptyList();
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            public void update(PresentationData presentation) {
                presentation.setPresentableText((String)this.getValue());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesTreeStructure$1", "getChildren"));
            }
        };
    }

    @Override
    public Object getParentElement(Object element) {
        AbstractTreeNode parent = null;
        if (element == this.getRootElement()) {
            return null;
        }
        if (element instanceof AbstractTreeNode) {
            parent = ((AbstractTreeNode)element).getParent();
        }
        if (parent == null) {
            return this.getRootElement();
        }
        return parent;
    }

    @Override
    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        FavoritesTreeNodeDescriptor favoritesTreeNodeDescriptor = new FavoritesTreeNodeDescriptor(this.myProject, parentDescriptor, (AbstractTreeNode)element);
        if (favoritesTreeNodeDescriptor == null) {
            FavoritesTreeStructure.$$$reportNull$$$0(0);
        }
        return favoritesTreeNodeDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesTreeStructure", "createDescriptor"));
    }

    private static class MyProvider
    implements TreeStructureProvider {
        private final Project myProject;

        public MyProvider(Project project) {
            this.myProject = project;
        }

        @NotNull
        public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children2, ViewSettings settings) {
            if (parent == null) {
                MyProvider.$$$reportNull$$$0(0);
            }
            if (children2 == null) {
                MyProvider.$$$reportNull$$$0(1);
            }
            if (parent instanceof PsiDirectoryNode && children2.isEmpty()) {
                VirtualFile virtualFile = ((PsiDirectoryNode)parent).getVirtualFile();
                if (virtualFile == null) {
                    Collection<AbstractTreeNode> collection = children2;
                    if (collection == null) {
                        MyProvider.$$$reportNull$$$0(2);
                    }
                    return collection;
                }
                VirtualFile[] virtualFiles = virtualFile.getChildren();
                ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
                PsiManagerImpl psiManager = (PsiManagerImpl)PsiManager.getInstance((Project)this.myProject);
                for (VirtualFile file2 : virtualFiles) {
                    BasePsiNode child;
                    if (file2.isDirectory()) {
                        child = new PsiDirectoryNode(this.myProject, new PsiDirectoryImpl(psiManager, file2), settings);
                    } else {
                        PsiFile psiFile = psiManager.findFile(file2);
                        if (psiFile == null) continue;
                        child = new PsiFileNode(this.myProject, psiFile, settings);
                    }
                    child.setParent(parent);
                    result2.add((AbstractTreeNode)child);
                }
                ArrayList<AbstractTreeNode> arrayList = result2;
                if (arrayList == null) {
                    MyProvider.$$$reportNull$$$0(3);
                }
                return arrayList;
            }
            Collection<AbstractTreeNode> collection = children2;
            if (collection == null) {
                MyProvider.$$$reportNull$$$0(4);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/favoritesTreeView/FavoritesTreeStructure$MyProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/favoritesTreeView/FavoritesTreeStructure$MyProvider";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "modify";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "modify";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

