/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffTool;
import com.intellij.diff.FocusableContext;
import com.intellij.diff.SuppressiveDiffTool;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.impl.DiffToolSubstitutor;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.SimpleTextDiffProvider;
import com.intellij.diff.tools.util.text.SmartTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.Equality;
import gnu.trove.TIntFunction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffUtil {
    private static final Logger LOG = Logger.getInstance(DiffUtil.class);
    public static final Key<Boolean> TEMP_FILE_KEY = Key.create((String)"Diff.TempFile");
    @NotNull
    public static final String DIFF_CONFIG = "diff.xml";
    public static final int TITLE_GAP = JBUI.scale((int)2);
    public static final List<Image> DIFF_FRAME_ICONS = DiffUtil.loadDiffFrameImages();

    @NotNull
    private static List<Image> loadDiffFrameImages() {
        List list2 = ContainerUtil.list((Object[])new Image[]{ImageLoader.loadFromResource((String)"/diff_frame32.png"), ImageLoader.loadFromResource((String)"/diff_frame64.png"), ImageLoader.loadFromResource((String)"/diff_frame128.png")});
        if (list2 == null) {
            DiffUtil.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public static boolean isDiffEditor(@NotNull Editor editor) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(1);
        }
        return editor.getEditorKind() == EditorKind.DIFF;
    }

    @Nullable
    public static EditorHighlighter initEditorHighlighter(@Nullable Project project, @NotNull DocumentContent content, @NotNull CharSequence text2) {
        EditorHighlighter highlighter;
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(3);
        }
        if ((highlighter = DiffUtil.createEditorHighlighter(project, content)) == null) {
            return null;
        }
        highlighter.setText(text2);
        return highlighter;
    }

    @NotNull
    public static EditorHighlighter initEmptyEditorHighlighter(@NotNull CharSequence text2) {
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(4);
        }
        EditorHighlighter highlighter = DiffUtil.createEmptyEditorHighlighter();
        highlighter.setText(text2);
        EditorHighlighter editorHighlighter = highlighter;
        if (editorHighlighter == null) {
            DiffUtil.$$$reportNull$$$0(5);
        }
        return editorHighlighter;
    }

    @Nullable
    private static EditorHighlighter createEditorHighlighter(@Nullable Project project, @NotNull DocumentContent content) {
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(6);
        }
        FileType type = content.getContentType();
        VirtualFile file2 = content.getHighlightFile();
        Language language = (Language)content.getUserData(DiffUserDataKeys.LANGUAGE);
        EditorHighlighterFactory highlighterFactory = EditorHighlighterFactory.getInstance();
        if (language != null) {
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)file2);
            return highlighterFactory.createEditorHighlighter(syntaxHighlighter, EditorColorsManager.getInstance().getGlobalScheme());
        }
        if (file2 != null && file2.isValid() && (type == null || type == PlainTextFileType.INSTANCE || file2.getFileType() == type || file2 instanceof LightVirtualFile)) {
            return highlighterFactory.createEditorHighlighter(project, file2);
        }
        if (type != null) {
            return highlighterFactory.createEditorHighlighter(project, type);
        }
        return null;
    }

    @NotNull
    private static EditorHighlighter createEmptyEditorHighlighter() {
        EmptyEditorHighlighter emptyEditorHighlighter = new EmptyEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(HighlighterColors.TEXT));
        if (emptyEditorHighlighter == null) {
            DiffUtil.$$$reportNull$$$0(7);
        }
        return emptyEditorHighlighter;
    }

    public static void setEditorHighlighter(@Nullable Project project, @NotNull EditorEx editor, @NotNull DocumentContent content) {
        EditorHighlighter highlighter;
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(8);
        }
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(9);
        }
        if ((highlighter = DiffUtil.createEditorHighlighter(project, content)) != null) {
            editor.setHighlighter(highlighter);
        }
    }

    public static void setEditorCodeStyle(@Nullable Project project, @NotNull EditorEx editor, @Nullable FileType fileType) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(10);
        }
        if (project != null && fileType != null) {
            CodeStyleFacade codeStyleFacade = CodeStyleFacade.getInstance((Project)project);
            editor.getSettings().setTabSize(codeStyleFacade.getTabSize(fileType));
            editor.getSettings().setUseTabCharacter(codeStyleFacade.useTabCharacter(fileType));
        }
        editor.getSettings().setCaretRowShown(false);
        editor.reinitSettings();
    }

    public static void setFoldingModelSupport(@NotNull EditorEx editor) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(11);
        }
        editor.getSettings().setFoldingOutlineShown(true);
        editor.getSettings().setAutoCodeFoldingEnabled(false);
        editor.getColorsScheme().setAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES, null);
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project, boolean isViewer) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(12);
        }
        EditorEx editorEx = DiffUtil.createEditor(document, project, isViewer, false);
        if (editorEx == null) {
            DiffUtil.$$$reportNull$$$0(13);
        }
        return editorEx;
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project, boolean isViewer, boolean enableFolding) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(14);
        }
        EditorFactory factory = EditorFactory.getInstance();
        EditorKind kind = EditorKind.DIFF;
        EditorEx editor = (EditorEx)(isViewer ? factory.createViewer(document, project, kind) : factory.createEditor(document, project, kind));
        editor.getSettings().setShowIntentionBulb(false);
        ((EditorMarkupModel)((Object)editor.getMarkupModel())).setErrorStripeVisible(true);
        editor.getGutterComponentEx().setShowDefaultGutterPopup(false);
        if (enableFolding) {
            DiffUtil.setFoldingModelSupport(editor);
        } else {
            editor.getSettings().setFoldingOutlineShown(false);
            editor.getFoldingModel().setFoldingEnabled(false);
        }
        UIUtil.removeScrollBorder((Component)editor.getComponent());
        EditorEx editorEx = editor;
        if (editorEx == null) {
            DiffUtil.$$$reportNull$$$0(15);
        }
        return editorEx;
    }

    public static void configureEditor(@NotNull EditorEx editor, @NotNull DocumentContent content, @Nullable Project project) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(16);
        }
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(17);
        }
        DiffUtil.setEditorHighlighter(project, editor, content);
        DiffUtil.setEditorCodeStyle(project, editor, content.getContentType());
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(content.getDocument());
        if (virtualFile != null && Registry.is((String)"diff.enable.psi.highlighting")) {
            editor.setFile(virtualFile);
        }
    }

    public static boolean isMirrored(@NotNull Editor editor) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(18);
        }
        if (editor instanceof EditorEx) {
            return ((EditorEx)editor).getVerticalScrollbarOrientation() == 0;
        }
        return false;
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean canNavigateToFile(@Nullable Project project, @Nullable VirtualFile file2) {
        if (project == null || project.isDefault()) {
            return false;
        }
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        if (OutsidersPsiFileSupport.isOutsiderFile(file2)) {
            return false;
        }
        return file2.getUserData(TEMP_FILE_KEY) != Boolean.TRUE;
    }

    public static void installLineConvertor(@NotNull EditorEx editor, @NotNull FoldingModelSupport foldingSupport) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(19);
        }
        if (foldingSupport == null) {
            DiffUtil.$$$reportNull$$$0(20);
        }
        assert (foldingSupport.getCount() == 1);
        TIntFunction foldingLineConvertor = foldingSupport.getLineConvertor(0);
        editor.getGutterComponentEx().setLineNumberConvertor(foldingLineConvertor);
    }

    public static void installLineConvertor(@NotNull EditorEx editor, @NotNull DocumentContent content) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(21);
        }
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(22);
        }
        TIntFunction contentLineConvertor = DiffUtil.getContentLineConvertor(content);
        editor.getGutterComponentEx().setLineNumberConvertor(contentLineConvertor);
    }

    public static void installLineConvertor(@NotNull EditorEx editor, @NotNull DocumentContent content, @NotNull FoldingModelSupport foldingSupport, int editorIndex) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(23);
        }
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(24);
        }
        if (foldingSupport == null) {
            DiffUtil.$$$reportNull$$$0(25);
        }
        TIntFunction contentLineConvertor = DiffUtil.getContentLineConvertor(content);
        TIntFunction foldingLineConvertor = foldingSupport.getLineConvertor(editorIndex);
        editor.getGutterComponentEx().setLineNumberConvertor(DiffUtil.mergeLineConverters(contentLineConvertor, foldingLineConvertor));
    }

    @Nullable
    public static TIntFunction getContentLineConvertor(@NotNull DocumentContent content) {
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(26);
        }
        return (TIntFunction)content.getUserData(DiffUserDataKeysEx.LINE_NUMBER_CONVERTOR);
    }

    @Nullable
    public static TIntFunction mergeLineConverters(@Nullable TIntFunction convertor1, @Nullable TIntFunction convertor2) {
        if (convertor1 == null && convertor2 == null) {
            return null;
        }
        if (convertor1 == null) {
            return convertor2;
        }
        if (convertor2 == null) {
            return convertor1;
        }
        return value -> {
            int value2 = convertor2.execute(value);
            return value2 >= 0 ? convertor1.execute(value2) : value2;
        };
    }

    public static void disableBlitting(@NotNull EditorEx editor) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(27);
        }
        if (Registry.is((String)"diff.divider.repainting.disable.blitting")) {
            editor.getScrollPane().getViewport().setScrollMode(0);
        }
    }

    public static void moveCaret(@Nullable Editor editor, int line) {
        if (editor == null) {
            return;
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, 0));
    }

    public static void scrollEditor(@Nullable Editor editor, int line, boolean animated) {
        DiffUtil.scrollEditor(editor, line, 0, animated);
    }

    public static void scrollEditor(@Nullable Editor editor, int line, int column, boolean animated) {
        if (editor == null) {
            return;
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, column));
        DiffUtil.scrollToCaret(editor, animated);
    }

    public static void scrollToPoint(@Nullable Editor editor, @NotNull Point point, boolean animated) {
        if (point == null) {
            DiffUtil.$$$reportNull$$$0(28);
        }
        if (editor == null) {
            return;
        }
        if (!animated) {
            editor.getScrollingModel().disableAnimation();
        }
        editor.getScrollingModel().scrollHorizontally(point.x);
        editor.getScrollingModel().scrollVertically(point.y);
        if (!animated) {
            editor.getScrollingModel().enableAnimation();
        }
    }

    public static void scrollToCaret(@Nullable Editor editor, boolean animated) {
        if (editor == null) {
            return;
        }
        if (!animated) {
            editor.getScrollingModel().disableAnimation();
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        if (!animated) {
            editor.getScrollingModel().enableAnimation();
        }
    }

    @NotNull
    public static Point getScrollingPosition(@Nullable Editor editor) {
        if (editor == null) {
            Point point = new Point(0, 0);
            if (point == null) {
                DiffUtil.$$$reportNull$$$0(29);
            }
            return point;
        }
        ScrollingModel model = editor.getScrollingModel();
        Point point = new Point(model.getHorizontalScrollOffset(), model.getVerticalScrollOffset());
        if (point == null) {
            DiffUtil.$$$reportNull$$$0(30);
        }
        return point;
    }

    @NotNull
    public static LogicalPosition getCaretPosition(@Nullable Editor editor) {
        LogicalPosition logicalPosition = editor != null ? editor.getCaretModel().getLogicalPosition() : new LogicalPosition(0, 0);
        if (logicalPosition == null) {
            DiffUtil.$$$reportNull$$$0(31);
        }
        return logicalPosition;
    }

    public static void moveCaretToLineRangeIfNeeded(@NotNull Editor editor, int startLine, int endLine) {
        int caretLine;
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(32);
        }
        if (!DiffUtil.isSelectedByLine(caretLine = editor.getCaretModel().getLogicalPosition().line, startLine, endLine)) {
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(startLine, 0));
        }
    }

    @NotNull
    public static Icon getArrowIcon(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            DiffUtil.$$$reportNull$$$0(33);
        }
        Icon icon = (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRight, (Object)AllIcons.Diff.Arrow);
        if (icon == null) {
            DiffUtil.$$$reportNull$$$0(34);
        }
        return icon;
    }

    @NotNull
    public static Icon getArrowDownIcon(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            DiffUtil.$$$reportNull$$$0(35);
        }
        Icon icon = (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRightDown, (Object)AllIcons.Diff.ArrowLeftDown);
        if (icon == null) {
            DiffUtil.$$$reportNull$$$0(36);
        }
        return icon;
    }

    public static void registerAction(@NotNull AnAction action, @NotNull JComponent component) {
        if (action == null) {
            DiffUtil.$$$reportNull$$$0(37);
        }
        if (component == null) {
            DiffUtil.$$$reportNull$$$0(38);
        }
        action.registerCustomShortcutSet(action.getShortcutSet(), component);
    }

    @NotNull
    public static JPanel createMessagePanel(@NotNull String message) {
        if (message == null) {
            DiffUtil.$$$reportNull$$$0(39);
        }
        String text2 = StringUtil.replace((String)message, (String)"\n", (String)"<br>");
        JBLabel label2 = new JBLabel(text2){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                size.width = Math.min(size.width, 200);
                size.height = Math.min(size.height, 100);
                return size;
            }
        }.setCopyable(true);
        label2.setForeground(UIUtil.getInactiveTextColor());
        CenteredPanel centeredPanel = new CenteredPanel((JComponent)label2, JBUI.Borders.empty((int)5));
        if (centeredPanel == null) {
            DiffUtil.$$$reportNull$$$0(40);
        }
        return centeredPanel;
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, AnAction ... actions) {
        if (group == null) {
            DiffUtil.$$$reportNull$$$0(41);
        }
        DiffUtil.addActionBlock(group, Arrays.asList(actions));
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, @Nullable List<? extends AnAction> actions) {
        if (group == null) {
            DiffUtil.$$$reportNull$$$0(42);
        }
        if (actions == null || actions.isEmpty()) {
            return;
        }
        group.addSeparator();
        Object[] children2 = group.getChildren(null);
        for (AnAction anAction : actions) {
            if (!(anAction instanceof Separator) && ArrayUtil.contains((Object)anAction, (Object[])children2)) continue;
            group.add(anAction);
        }
    }

    @NotNull
    public static String getSettingsConfigurablePath() {
        if ("Settings | Tools | Diff" == null) {
            DiffUtil.$$$reportNull$$$0(43);
        }
        return "Settings | Tools | Diff";
    }

    @NotNull
    public static String createTooltipText(@NotNull String text2, @Nullable String appendix) {
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(44);
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("<html><body>");
        result2.append(text2);
        if (appendix != null) {
            result2.append("<br><div style='margin-top: 5px'><font size='2'>");
            result2.append(appendix);
            result2.append("</font></div>");
        }
        result2.append("</body></html>");
        String string = result2.toString();
        if (string == null) {
            DiffUtil.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public static String createNotificationText(@NotNull String text2, @Nullable String appendix) {
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(46);
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("<html><body>");
        result2.append(text2);
        if (appendix != null) {
            result2.append("<br><span style='color:#").append(ColorUtil.toHex((Color)JBColor.gray)).append("'><small>");
            result2.append(appendix);
            result2.append("</small></span>");
        }
        result2.append("</body></html>");
        String string = result2.toString();
        if (string == null) {
            DiffUtil.$$$reportNull$$$0(47);
        }
        return string;
    }

    public static void showSuccessPopup(@NotNull String message, @NotNull RelativePoint point, @NotNull Disposable disposable, final @Nullable Runnable hyperlinkHandler) {
        if (message == null) {
            DiffUtil.$$$reportNull$$$0(48);
        }
        if (point == null) {
            DiffUtil.$$$reportNull$$$0(49);
        }
        if (disposable == null) {
            DiffUtil.$$$reportNull$$$0(50);
        }
        HyperlinkAdapter listener2 = null;
        if (hyperlinkHandler != null) {
            listener2 = new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    hyperlinkHandler.run();
                }
            };
        }
        Color bgColor = MessageType.INFO.getPopupBackground();
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, null, bgColor, (HyperlinkListener)listener2).setAnimationCycle(200).createBalloon();
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)disposable, (Disposable)balloon);
    }

    @NotNull
    public static List<JComponent> createSimpleTitles(@NotNull ContentDiffRequest request) {
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(51);
        }
        List contents = request.getContents();
        List titles = request.getContentTitles();
        if (!ContainerUtil.exists((Iterable)titles, (Condition)Condition.NOT_NULL)) {
            List<Object> list2 = Collections.nCopies(titles.size(), null);
            if (list2 == null) {
                DiffUtil.$$$reportNull$$$0(52);
            }
            return list2;
        }
        ArrayList<JComponent> components = new ArrayList<JComponent>(titles.size());
        for (int i = 0; i < contents.size(); ++i) {
            JComponent title = DiffUtil.createTitle(StringUtil.notNullize((String)((String)titles.get(i))));
            title = DiffUtil.createTitleWithNotifications(title, (DiffContent)contents.get(i));
            components.add(title);
        }
        ArrayList<JComponent> arrayList = components;
        if (arrayList == null) {
            DiffUtil.$$$reportNull$$$0(53);
        }
        return arrayList;
    }

    @NotNull
    public static List<JComponent> createTextTitles(@NotNull ContentDiffRequest request, @NotNull List<? extends Editor> editors) {
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(54);
        }
        if (editors == null) {
            DiffUtil.$$$reportNull$$$0(55);
        }
        List contents = request.getContents();
        List titles = request.getContentTitles();
        boolean equalCharsets = TextDiffViewerUtil.areEqualCharsets(contents);
        boolean equalSeparators = TextDiffViewerUtil.areEqualLineSeparators(contents);
        ArrayList<JComponent> result2 = new ArrayList<JComponent>(contents.size());
        if (equalCharsets && equalSeparators && !ContainerUtil.exists((Iterable)titles, (Condition)Condition.NOT_NULL)) {
            List<Object> list2 = Collections.nCopies(titles.size(), null);
            if (list2 == null) {
                DiffUtil.$$$reportNull$$$0(56);
            }
            return list2;
        }
        for (int i = 0; i < contents.size(); ++i) {
            JComponent title = DiffUtil.createTitle(StringUtil.notNullize((String)((String)titles.get(i))), (DiffContent)contents.get(i), equalCharsets, equalSeparators, editors.get(i));
            title = DiffUtil.createTitleWithNotifications(title, (DiffContent)contents.get(i));
            result2.add(title);
        }
        ArrayList<JComponent> arrayList = result2;
        if (arrayList == null) {
            DiffUtil.$$$reportNull$$$0(57);
        }
        return arrayList;
    }

    @Nullable
    private static JComponent createTitleWithNotifications(@Nullable JComponent title, @NotNull DiffContent content) {
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(58);
        }
        ArrayList<JComponent> notifications = new ArrayList<JComponent>(DiffUtil.getCustomNotifications(content));
        if (content instanceof DocumentContent) {
            Document document = ((DocumentContent)content).getDocument();
            if (FileDocumentManager.getInstance().isPartialPreviewOfALargeFile(document)) {
                notifications.add(DiffNotifications.createNotification("File is too large. Only preview is loaded."));
            }
        }
        if (notifications.isEmpty()) {
            return title;
        }
        JPanel panel2 = new JPanel(new BorderLayout(0, TITLE_GAP));
        if (title != null) {
            panel2.add((Component)title, "North");
        }
        panel2.add((Component)DiffUtil.createStackedComponents(notifications, TITLE_GAP), "South");
        return panel2;
    }

    @Nullable
    private static JComponent createTitle(@NotNull String title, @NotNull DiffContent content, boolean equalCharsets, boolean equalSeparators, @Nullable Editor editor) {
        if (title == null) {
            DiffUtil.$$$reportNull$$$0(59);
        }
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(60);
        }
        if (content instanceof EmptyContent) {
            return null;
        }
        DocumentContent documentContent = (DocumentContent)content;
        Charset charset = equalCharsets ? null : documentContent.getCharset();
        Boolean bom = equalCharsets ? null : documentContent.hasBom();
        LineSeparator separator = equalSeparators ? null : documentContent.getLineSeparator();
        boolean isReadOnly = editor == null || editor.isViewer() || !DiffUtil.canMakeWritable(editor.getDocument());
        return DiffUtil.createTitle(title, separator, charset, bom, isReadOnly);
    }

    @NotNull
    public static JComponent createTitle(@NotNull String title) {
        if (title == null) {
            DiffUtil.$$$reportNull$$$0(61);
        }
        JComponent jComponent = DiffUtil.createTitle(title, null, null, null, false);
        if (jComponent == null) {
            DiffUtil.$$$reportNull$$$0(62);
        }
        return jComponent;
    }

    @NotNull
    public static JComponent createTitle(@NotNull String title, @Nullable LineSeparator separator, @Nullable Charset charset, @Nullable Boolean bom, boolean readOnly) {
        if (title == null) {
            DiffUtil.$$$reportNull$$$0(63);
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        JBLabel titleLabel = new JBLabel(title).setCopyable(true);
        if (readOnly) {
            titleLabel.setIcon(AllIcons.Ide.Readonly);
        }
        panel2.add((Component)titleLabel, "Center");
        if (charset != null && separator != null) {
            JPanel panel22 = new JPanel();
            panel22.setLayout(new BoxLayout(panel22, 0));
            panel22.add(DiffUtil.createCharsetPanel(charset, bom));
            panel22.add(Box.createRigidArea((Dimension)JBUI.size((int)4, (int)0)));
            panel22.add(DiffUtil.createSeparatorPanel(separator));
            panel2.add((Component)panel22, "East");
        } else if (charset != null) {
            panel2.add((Component)DiffUtil.createCharsetPanel(charset, bom), "East");
        } else if (separator != null) {
            panel2.add((Component)DiffUtil.createSeparatorPanel(separator), "East");
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            DiffUtil.$$$reportNull$$$0(64);
        }
        return jPanel;
    }

    @NotNull
    private static JComponent createCharsetPanel(@NotNull Charset charset, @Nullable Boolean bom) {
        if (charset == null) {
            DiffUtil.$$$reportNull$$$0(65);
        }
        String text2 = charset.displayName();
        if (bom != null && bom.booleanValue()) {
            text2 = text2 + " BOM";
        }
        JLabel label2 = new JLabel(text2);
        if (charset.equals(Charset.forName("UTF-8"))) {
            label2.setForeground((Color)JBColor.BLUE);
        } else if (charset.equals(Charset.forName("ISO-8859-1"))) {
            label2.setForeground((Color)JBColor.RED);
        } else {
            label2.setForeground((Color)JBColor.BLACK);
        }
        JLabel jLabel = label2;
        if (jLabel == null) {
            DiffUtil.$$$reportNull$$$0(66);
        }
        return jLabel;
    }

    @NotNull
    private static JComponent createSeparatorPanel(@NotNull LineSeparator separator) {
        if (separator == null) {
            DiffUtil.$$$reportNull$$$0(67);
        }
        JLabel label2 = new JLabel(separator.name());
        Object color = separator == LineSeparator.CRLF ? JBColor.RED : (separator == LineSeparator.LF ? JBColor.BLUE : (separator == LineSeparator.CR ? JBColor.MAGENTA : JBColor.BLACK));
        label2.setForeground((Color)color);
        JLabel jLabel = label2;
        if (jLabel == null) {
            DiffUtil.$$$reportNull$$$0(68);
        }
        return jLabel;
    }

    @NotNull
    public static List<JComponent> createSyncHeightComponents(@NotNull List<JComponent> components) {
        if (components == null) {
            DiffUtil.$$$reportNull$$$0(69);
        }
        if (!ContainerUtil.exists(components, (Condition)Condition.NOT_NULL)) {
            List<JComponent> list2 = components;
            if (list2 == null) {
                DiffUtil.$$$reportNull$$$0(70);
            }
            return list2;
        }
        ArrayList<JComponent> result2 = new ArrayList<JComponent>();
        for (int i = 0; i < components.size(); ++i) {
            result2.add(new SyncHeightComponent(components, i));
        }
        ArrayList<JComponent> arrayList = result2;
        if (arrayList == null) {
            DiffUtil.$$$reportNull$$$0(71);
        }
        return arrayList;
    }

    @NotNull
    public static JComponent createStackedComponents(@NotNull List<JComponent> components, int gap) {
        if (components == null) {
            DiffUtil.$$$reportNull$$$0(72);
        }
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        for (int i = 0; i < components.size(); ++i) {
            if (i != 0) {
                panel2.add(Box.createVerticalStrut(JBUI.scale((int)gap)));
            }
            panel2.add(components.get(i));
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            DiffUtil.$$$reportNull$$$0(73);
        }
        return jPanel;
    }

    public static boolean isFocusedComponent(@Nullable Component component) {
        return DiffUtil.isFocusedComponent(null, component);
    }

    public static boolean isFocusedComponent(@Nullable Project project, @Nullable Component component) {
        if (component == null) {
            return false;
        }
        Component ideFocusOwner = IdeFocusManager.getInstance((Project)project).getFocusOwner();
        if (ideFocusOwner != null && SwingUtilities.isDescendingFrom(ideFocusOwner, component)) {
            return true;
        }
        Component jdkFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return jdkFocusOwner != null && SwingUtilities.isDescendingFrom(jdkFocusOwner, component);
    }

    public static void requestFocus(@Nullable Project project, @Nullable Component component) {
        if (component == null) {
            return;
        }
        IdeFocusManager.getInstance((Project)project).requestFocus(component, true);
    }

    public static boolean isFocusedComponentInWindow(@Nullable Component component) {
        if (component == null) {
            return false;
        }
        Window window = UIUtil.getWindow((Component)component);
        if (window == null) {
            return false;
        }
        Component windowFocusOwner = window.getMostRecentFocusOwner();
        return windowFocusOwner != null && SwingUtilities.isDescendingFrom(windowFocusOwner, component);
    }

    public static void requestFocusInWindow(@Nullable Component component) {
        if (component != null) {
            component.requestFocusInWindow();
        }
    }

    public static void runPreservingFocus(@NotNull FocusableContext context, @NotNull Runnable task2) {
        if (context == null) {
            DiffUtil.$$$reportNull$$$0(74);
        }
        if (task2 == null) {
            DiffUtil.$$$reportNull$$$0(75);
        }
        boolean hadFocus = context.isFocusedInWindow();
        task2.run();
        if (hadFocus) {
            context.requestFocusInWindow();
        }
    }

    @NotNull
    public static TwosideTextDiffProvider createTextDiffProvider(@Nullable Project project, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        DiffUserDataKeysEx.DiffComputer diffComputer;
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(76);
        }
        if (settings == null) {
            DiffUtil.$$$reportNull$$$0(77);
        }
        if (rediff == null) {
            DiffUtil.$$$reportNull$$$0(78);
        }
        if (disposable == null) {
            DiffUtil.$$$reportNull$$$0(79);
        }
        if ((diffComputer = (DiffUserDataKeysEx.DiffComputer)request.getUserData(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER)) != null) {
            SimpleTextDiffProvider simpleTextDiffProvider = new SimpleTextDiffProvider(settings, rediff, disposable, diffComputer);
            if (simpleTextDiffProvider == null) {
                DiffUtil.$$$reportNull$$$0(80);
            }
            return simpleTextDiffProvider;
        }
        TwosideTextDiffProvider smartProvider = SmartTextDiffProvider.create(project, request, settings, rediff, disposable);
        if (smartProvider != null) {
            TwosideTextDiffProvider twosideTextDiffProvider = smartProvider;
            if (twosideTextDiffProvider == null) {
                DiffUtil.$$$reportNull$$$0(81);
            }
            return twosideTextDiffProvider;
        }
        SimpleTextDiffProvider simpleTextDiffProvider = new SimpleTextDiffProvider(settings, rediff, disposable);
        if (simpleTextDiffProvider == null) {
            DiffUtil.$$$reportNull$$$0(82);
        }
        return simpleTextDiffProvider;
    }

    @NotNull
    public static TwosideTextDiffProvider.NoIgnore createNoIgnoreTextDiffProvider(@Nullable Project project, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        DiffUserDataKeysEx.DiffComputer diffComputer;
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(83);
        }
        if (settings == null) {
            DiffUtil.$$$reportNull$$$0(84);
        }
        if (rediff == null) {
            DiffUtil.$$$reportNull$$$0(85);
        }
        if (disposable == null) {
            DiffUtil.$$$reportNull$$$0(86);
        }
        if ((diffComputer = (DiffUserDataKeysEx.DiffComputer)request.getUserData(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER)) != null) {
            SimpleTextDiffProvider.NoIgnore noIgnore = new SimpleTextDiffProvider.NoIgnore(settings, rediff, disposable, diffComputer);
            if (noIgnore == null) {
                DiffUtil.$$$reportNull$$$0(87);
            }
            return noIgnore;
        }
        TwosideTextDiffProvider.NoIgnore smartProvider = SmartTextDiffProvider.createNoIgnore(project, request, settings, rediff, disposable);
        if (smartProvider != null) {
            TwosideTextDiffProvider.NoIgnore noIgnore = smartProvider;
            if (noIgnore == null) {
                DiffUtil.$$$reportNull$$$0(88);
            }
            return noIgnore;
        }
        SimpleTextDiffProvider.NoIgnore noIgnore = new SimpleTextDiffProvider.NoIgnore(settings, rediff, disposable);
        if (noIgnore == null) {
            DiffUtil.$$$reportNull$$$0(89);
        }
        return noIgnore;
    }

    @Nullable
    public static MergeInnerDifferences compareThreesideInner(@NotNull List<CharSequence> chunks, @NotNull ComparisonPolicy comparisonPolicy, @NotNull ProgressIndicator indicator) {
        if (chunks == null) {
            DiffUtil.$$$reportNull$$$0(90);
        }
        if (comparisonPolicy == null) {
            DiffUtil.$$$reportNull$$$0(91);
        }
        if (indicator == null) {
            DiffUtil.$$$reportNull$$$0(92);
        }
        if (chunks.get(0) == null && chunks.get(1) == null && chunks.get(2) == null) {
            return null;
        }
        if (comparisonPolicy == ComparisonPolicy.IGNORE_WHITESPACES && DiffUtil.isChunksEquals(chunks.get(0), chunks.get(1), comparisonPolicy) && DiffUtil.isChunksEquals(chunks.get(0), chunks.get(2), comparisonPolicy)) {
            return new MergeInnerDifferences(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        if (chunks.get(0) == null && chunks.get(1) == null || chunks.get(0) == null && chunks.get(2) == null || chunks.get(1) == null && chunks.get(2) == null) {
            return null;
        }
        if (chunks.get(0) != null && chunks.get(1) != null && chunks.get(2) != null) {
            List<DiffFragment> fragments1 = ByWord.compare(chunks.get(1), chunks.get(0), comparisonPolicy, indicator);
            List<DiffFragment> fragments2 = ByWord.compare(chunks.get(1), chunks.get(2), comparisonPolicy, indicator);
            ArrayList<TextRange> left = new ArrayList<TextRange>();
            ArrayList<TextRange> base = new ArrayList<TextRange>();
            ArrayList<TextRange> right = new ArrayList<TextRange>();
            for (DiffFragment wordFragment : fragments1) {
                base.add(new TextRange(wordFragment.getStartOffset1(), wordFragment.getEndOffset1()));
                left.add(new TextRange(wordFragment.getStartOffset2(), wordFragment.getEndOffset2()));
            }
            for (DiffFragment wordFragment : fragments2) {
                base.add(new TextRange(wordFragment.getStartOffset1(), wordFragment.getEndOffset1()));
                right.add(new TextRange(wordFragment.getStartOffset2(), wordFragment.getEndOffset2()));
            }
            return new MergeInnerDifferences(left, base, right);
        }
        ThreeSide side1 = chunks.get(0) != null ? ThreeSide.LEFT : ThreeSide.BASE;
        ThreeSide side2 = chunks.get(2) != null ? ThreeSide.RIGHT : ThreeSide.BASE;
        CharSequence chunk1 = (CharSequence)side1.select(chunks);
        CharSequence chunk2 = (CharSequence)side2.select(chunks);
        List<DiffFragment> wordConflicts = ByWord.compare(chunk1, chunk2, comparisonPolicy, indicator);
        List textRanges = ThreeSide.map(side -> {
            if (side == side1) {
                return ContainerUtil.map((Collection)wordConflicts, fragment -> new TextRange(fragment.getStartOffset1(), fragment.getEndOffset1()));
            }
            if (side == side2) {
                return ContainerUtil.map((Collection)wordConflicts, fragment -> new TextRange(fragment.getStartOffset2(), fragment.getEndOffset2()));
            }
            return null;
        });
        return new MergeInnerDifferences((List)textRanges.get(0), (List)textRanges.get(1), (List)textRanges.get(2));
    }

    private static boolean isChunksEquals(@Nullable CharSequence chunk1, @Nullable CharSequence chunk2, @NotNull ComparisonPolicy comparisonPolicy) {
        if (comparisonPolicy == null) {
            DiffUtil.$$$reportNull$$$0(93);
        }
        if (chunk1 == null) {
            chunk1 = "";
        }
        if (chunk2 == null) {
            chunk2 = "";
        }
        return ComparisonUtil.isEquals(chunk1, chunk2, comparisonPolicy);
    }

    @NotNull
    public static <T> int[] getSortedIndexes(@NotNull List<T> values, @NotNull Comparator<T> comparator2) {
        if (values == null) {
            DiffUtil.$$$reportNull$$$0(94);
        }
        if (comparator2 == null) {
            DiffUtil.$$$reportNull$$$0(95);
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            indexes.add(i);
        }
        ContainerUtil.sort(indexes, (i1, i2) -> {
            if (values == null) {
                DiffUtil.$$$reportNull$$$0(262);
            }
            if (comparator2 == null) {
                DiffUtil.$$$reportNull$$$0(263);
            }
            Object val1 = values.get((int)i1);
            Object val2 = values.get((int)i2);
            return comparator2.compare(val1, val2);
        });
        int[] nArray = ArrayUtil.toIntArray(indexes);
        if (nArray == null) {
            DiffUtil.$$$reportNull$$$0(96);
        }
        return nArray;
    }

    @NotNull
    public static int[] invertIndexes(@NotNull int[] indexes) {
        if (indexes == null) {
            DiffUtil.$$$reportNull$$$0(97);
        }
        int[] inverted = new int[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            inverted[indexes[i]] = i;
        }
        if (inverted == null) {
            DiffUtil.$$$reportNull$$$0(98);
        }
        return inverted;
    }

    @NotNull
    public static BitSet getSelectedLines(@NotNull Editor editor) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(99);
        }
        Document document = editor.getDocument();
        int totalLines = DiffUtil.getLineCount(document);
        BitSet lines2 = new BitSet(totalLines + 1);
        if (editor instanceof EditorEx) {
            int expectedCaretOffset = ((EditorEx)editor).getExpectedCaretOffset();
            if (editor.getCaretModel().getOffset() != expectedCaretOffset) {
                Caret caret = editor.getCaretModel().getPrimaryCaret();
                DiffUtil.appendSelectedLines(editor, lines2, caret, expectedCaretOffset);
                BitSet bitSet = lines2;
                if (bitSet == null) {
                    DiffUtil.$$$reportNull$$$0(100);
                }
                return bitSet;
            }
        }
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            DiffUtil.appendSelectedLines(editor, lines2, caret, -1);
        }
        BitSet bitSet = lines2;
        if (bitSet == null) {
            DiffUtil.$$$reportNull$$$0(101);
        }
        return bitSet;
    }

    private static void appendSelectedLines(@NotNull Editor editor, @NotNull BitSet lines2, @NotNull Caret caret, int expectedCaretOffset) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(102);
        }
        if (lines2 == null) {
            DiffUtil.$$$reportNull$$$0(103);
        }
        if (caret == null) {
            DiffUtil.$$$reportNull$$$0(104);
        }
        Document document = editor.getDocument();
        int totalLines = DiffUtil.getLineCount(document);
        if (caret.hasSelection()) {
            int line1 = editor.offsetToLogicalPosition((int)caret.getSelectionStart()).line;
            int line2 = editor.offsetToLogicalPosition((int)caret.getSelectionEnd()).line;
            lines2.set(line1, line2 + 1);
            if (caret.getSelectionEnd() == document.getTextLength()) {
                lines2.set(totalLines);
            }
        } else if (expectedCaretOffset == -1) {
            lines2.set(caret.getLogicalPosition().line);
            if (caret.getOffset() == document.getTextLength()) {
                lines2.set(totalLines);
            }
        } else {
            lines2.set(document.getLineNumber(expectedCaretOffset));
            if (expectedCaretOffset == document.getTextLength()) {
                lines2.set(totalLines);
            }
        }
    }

    public static boolean isSelectedByLine(int line, int line1, int line2) {
        if (line1 == line2 && line == line1) {
            return true;
        }
        return line >= line1 && line < line2;
    }

    public static boolean isSelectedByLine(@NotNull BitSet selected, int line1, int line2) {
        if (selected == null) {
            DiffUtil.$$$reportNull$$$0(105);
        }
        if (line1 == line2) {
            return selected.get(line1);
        }
        int next = selected.nextSetBit(line1);
        return next != -1 && next < line2;
    }

    private static void deleteLines(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(106);
        }
        TextRange range2 = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = range2.getStartOffset();
        int offset2 = range2.getEndOffset();
        if (offset1 > 0) {
            --offset1;
        } else if (offset2 < document.getTextLength()) {
            ++offset2;
        }
        document.deleteString(offset1, offset2);
    }

    private static void insertLines(@NotNull Document document, int line, @NotNull CharSequence text2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(107);
        }
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(108);
        }
        if (line == DiffUtil.getLineCount(document)) {
            document.insertString(document.getTextLength(), (CharSequence)("\n" + text2));
        } else {
            document.insertString(document.getLineStartOffset(line), (CharSequence)(text2 + "\n"));
        }
    }

    private static void replaceLines(@NotNull Document document, int line1, int line2, @NotNull CharSequence text2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(109);
        }
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(110);
        }
        TextRange currentTextRange = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = currentTextRange.getStartOffset();
        int offset2 = currentTextRange.getEndOffset();
        document.replaceString(offset1, offset2, text2);
    }

    public static void applyModification(@NotNull Document document, int line1, int line2, @NotNull List<? extends CharSequence> newLines) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(111);
        }
        if (newLines == null) {
            DiffUtil.$$$reportNull$$$0(112);
        }
        if (line1 == line2 && newLines.isEmpty()) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document, line1, StringUtil.join(newLines, (String)"\n"));
        } else if (newLines.isEmpty()) {
            DiffUtil.deleteLines(document, line1, line2);
        } else {
            DiffUtil.replaceLines(document, line1, line2, StringUtil.join(newLines, (String)"\n"));
        }
    }

    public static void applyModification(@NotNull Document document1, int line1, int line2, @NotNull Document document2, int oLine1, int oLine2) {
        if (document1 == null) {
            DiffUtil.$$$reportNull$$$0(113);
        }
        if (document2 == null) {
            DiffUtil.$$$reportNull$$$0(114);
        }
        if (line1 == line2 && oLine1 == oLine2) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document1, line1, DiffUtil.getLinesContent(document2, oLine1, oLine2));
        } else if (oLine1 == oLine2) {
            DiffUtil.deleteLines(document1, line1, line2);
        } else {
            DiffUtil.replaceLines(document1, line1, line2, DiffUtil.getLinesContent(document2, oLine1, oLine2));
        }
    }

    public static String applyModification(final @NotNull CharSequence text2, final @NotNull LineOffsets lineOffsets, final @NotNull CharSequence otherText, final @NotNull LineOffsets otherLineOffsets, final @NotNull List<Range> ranges) {
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(115);
        }
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(116);
        }
        if (otherText == null) {
            DiffUtil.$$$reportNull$$$0(117);
        }
        if (otherLineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(118);
        }
        if (ranges == null) {
            DiffUtil.$$$reportNull$$$0(119);
        }
        return new Object(){
            private final StringBuilder stringBuilder = new StringBuilder();
            private boolean isEmpty = true;

            @NotNull
            public String execute() {
                int lastLine = 0;
                for (Range range2 : ranges) {
                    CharSequence newChunkContent = DiffUtil.getLinesContent(otherText, otherLineOffsets, range2.start2, range2.end2);
                    this.appendOriginal(lastLine, range2.start1);
                    this.append(newChunkContent, range2.end2 - range2.start2);
                    lastLine = range2.end1;
                }
                this.appendOriginal(lastLine, lineOffsets.getLineCount());
                String string = this.stringBuilder.toString();
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private void appendOriginal(int start, int end) {
                this.append(DiffUtil.getLinesContent(text2, lineOffsets, start, end), end - start);
            }

            private void append(CharSequence content, int lineCount) {
                if (lineCount > 0 && !this.isEmpty) {
                    this.stringBuilder.append('\n');
                }
                this.stringBuilder.append(content);
                this.isEmpty &= lineCount == 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil$3", "execute"));
            }
        }.execute();
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(120);
        }
        CharSequence charSequence = DiffUtil.getLinesRange(document, line1, line2).subSequence(document.getImmutableCharSequence());
        if (charSequence == null) {
            DiffUtil.$$$reportNull$$$0(121);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull Document document, int line1, int line2, boolean includeNewLine) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(122);
        }
        CharSequence charSequence = DiffUtil.getLinesRange(document, line1, line2, includeNewLine).subSequence(document.getImmutableCharSequence());
        if (charSequence == null) {
            DiffUtil.$$$reportNull$$$0(123);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull CharSequence sequence, @NotNull LineOffsets lineOffsets, int line1, int line2) {
        if (sequence == null) {
            DiffUtil.$$$reportNull$$$0(124);
        }
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(125);
        }
        CharSequence charSequence = DiffUtil.getLinesContent(sequence, lineOffsets, line1, line2, false);
        if (charSequence == null) {
            DiffUtil.$$$reportNull$$$0(126);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull CharSequence sequence, @NotNull LineOffsets lineOffsets, int line1, int line2, boolean includeNewline) {
        if (sequence == null) {
            DiffUtil.$$$reportNull$$$0(127);
        }
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(128);
        }
        assert (sequence.length() == lineOffsets.getTextLength());
        CharSequence charSequence = DiffUtil.getLinesRange(lineOffsets, line1, line2, includeNewline).subSequence(sequence);
        if (charSequence == null) {
            DiffUtil.$$$reportNull$$$0(129);
        }
        return charSequence;
    }

    public static TextRange getLinesRange(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(130);
        }
        return DiffUtil.getLinesRange(document, line1, line2, false);
    }

    @NotNull
    public static TextRange getLinesRange(@NotNull Document document, int line1, int line2, boolean includeNewline) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(131);
        }
        TextRange textRange = DiffUtil.getLinesRange(LineOffsetsUtil.create(document), line1, line2, includeNewline);
        if (textRange == null) {
            DiffUtil.$$$reportNull$$$0(132);
        }
        return textRange;
    }

    @NotNull
    public static TextRange getLinesRange(@NotNull LineOffsets lineOffsets, int line1, int line2, boolean includeNewline) {
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(133);
        }
        if (line1 == line2) {
            int lineStartOffset = line1 < lineOffsets.getLineCount() ? lineOffsets.getLineStart(line1) : lineOffsets.getTextLength();
            TextRange textRange = new TextRange(lineStartOffset, lineStartOffset);
            if (textRange == null) {
                DiffUtil.$$$reportNull$$$0(134);
            }
            return textRange;
        }
        int startOffset = lineOffsets.getLineStart(line1);
        int endOffset = lineOffsets.getLineEnd(line2 - 1);
        if (includeNewline && endOffset < lineOffsets.getTextLength()) {
            ++endOffset;
        }
        TextRange textRange = new TextRange(startOffset, endOffset);
        if (textRange == null) {
            DiffUtil.$$$reportNull$$$0(135);
        }
        return textRange;
    }

    public static int getOffset(@NotNull Document document, int line, int column) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(136);
        }
        if (line < 0) {
            return 0;
        }
        if (line >= DiffUtil.getLineCount(document)) {
            return document.getTextLength();
        }
        int start = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        return Math.min(start + column, end);
    }

    public static int getLineCount(@NotNull Document document) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(137);
        }
        return Math.max(document.getLineCount(), 1);
    }

    @NotNull
    public static List<String> getLines(@NotNull Document document) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(138);
        }
        List<String> list2 = DiffUtil.getLines(document, 0, DiffUtil.getLineCount(document));
        if (list2 == null) {
            DiffUtil.$$$reportNull$$$0(139);
        }
        return list2;
    }

    @NotNull
    public static List<String> getLines(@NotNull CharSequence text2, @NonNls LineOffsets lineOffsets) {
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(140);
        }
        List<String> list2 = DiffUtil.getLines(text2, lineOffsets, 0, lineOffsets.getLineCount());
        if (list2 == null) {
            DiffUtil.$$$reportNull$$$0(141);
        }
        return list2;
    }

    @NotNull
    public static List<String> getLines(@NotNull Document document, int startLine, int endLine) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(142);
        }
        List<String> list2 = DiffUtil.getLines(document.getCharsSequence(), LineOffsetsUtil.create(document), startLine, endLine);
        if (list2 == null) {
            DiffUtil.$$$reportNull$$$0(143);
        }
        return list2;
    }

    @NotNull
    public static List<String> getLines(@NotNull CharSequence text2, @NonNls LineOffsets lineOffsets, int startLine, int endLine) {
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(144);
        }
        if (startLine < 0 || startLine > endLine || endLine > lineOffsets.getLineCount()) {
            throw new IndexOutOfBoundsException(String.format("Wrong line range: [%d, %d); lineCount: '%d'", startLine, endLine, lineOffsets.getLineCount()));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (int i = startLine; i < endLine; ++i) {
            int start = lineOffsets.getLineStart(i);
            int end = lineOffsets.getLineEnd(i);
            result2.add(text2.subSequence(start, end).toString());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            DiffUtil.$$$reportNull$$$0(145);
        }
        return arrayList;
    }

    public static int bound(int value, int lowerBound, int upperBound) {
        assert (lowerBound <= upperBound) : String.format("%s - [%s, %s]", value, lowerBound, upperBound);
        return Math.max(Math.min(value, upperBound), lowerBound);
    }

    @NotNull
    public static LineRange getAffectedLineRange(@NotNull DocumentEvent e) {
        if (e == null) {
            DiffUtil.$$$reportNull$$$0(146);
        }
        int line1 = e.getDocument().getLineNumber(e.getOffset());
        int line2 = e.getDocument().getLineNumber(e.getOffset() + e.getOldLength()) + 1;
        LineRange lineRange = new LineRange(line1, line2);
        if (lineRange == null) {
            DiffUtil.$$$reportNull$$$0(147);
        }
        return lineRange;
    }

    public static int countLinesShift(@NotNull DocumentEvent e) {
        if (e == null) {
            DiffUtil.$$$reportNull$$$0(148);
        }
        return StringUtil.countNewLines((CharSequence)e.getNewFragment()) - StringUtil.countNewLines((CharSequence)e.getOldFragment());
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start, int end, int changeStart, int changeEnd, int shift) {
        UpdatedLineRange updatedLineRange = DiffUtil.updateRangeOnModification(start, end, changeStart, changeEnd, shift, false);
        if (updatedLineRange == null) {
            DiffUtil.$$$reportNull$$$0(149);
        }
        return updatedLineRange;
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start, int end, int changeStart, int changeEnd, int shift, boolean greedy) {
        if (end <= changeStart) {
            UpdatedLineRange updatedLineRange = new UpdatedLineRange(start, end, false);
            if (updatedLineRange == null) {
                DiffUtil.$$$reportNull$$$0(150);
            }
            return updatedLineRange;
        }
        if (start >= changeEnd) {
            UpdatedLineRange updatedLineRange = new UpdatedLineRange(start + shift, end + shift, false);
            if (updatedLineRange == null) {
                DiffUtil.$$$reportNull$$$0(151);
            }
            return updatedLineRange;
        }
        if (start <= changeStart && end >= changeEnd) {
            UpdatedLineRange updatedLineRange = new UpdatedLineRange(start, end + shift, false);
            if (updatedLineRange == null) {
                DiffUtil.$$$reportNull$$$0(152);
            }
            return updatedLineRange;
        }
        int newChangeEnd = changeEnd + shift;
        if (start >= changeStart && end <= changeEnd) {
            UpdatedLineRange updatedLineRange = greedy ? new UpdatedLineRange(changeStart, newChangeEnd, true) : new UpdatedLineRange(newChangeEnd, newChangeEnd, true);
            if (updatedLineRange == null) {
                DiffUtil.$$$reportNull$$$0(153);
            }
            return updatedLineRange;
        }
        if (start < changeStart) {
            UpdatedLineRange updatedLineRange = greedy ? new UpdatedLineRange(start, newChangeEnd, true) : new UpdatedLineRange(start, changeStart, true);
            if (updatedLineRange == null) {
                DiffUtil.$$$reportNull$$$0(154);
            }
            return updatedLineRange;
        }
        UpdatedLineRange updatedLineRange = greedy ? new UpdatedLineRange(changeStart, end + shift, true) : new UpdatedLineRange(newChangeEnd, end + shift, true);
        if (updatedLineRange == null) {
            DiffUtil.$$$reportNull$$$0(155);
        }
        return updatedLineRange;
    }

    @NotNull
    public static TextDiffType getLineDiffType(@NotNull LineFragment fragment) {
        if (fragment == null) {
            DiffUtil.$$$reportNull$$$0(156);
        }
        boolean left = fragment.getStartLine1() != fragment.getEndLine1();
        boolean right = fragment.getStartLine2() != fragment.getEndLine2();
        TextDiffType textDiffType = DiffUtil.getDiffType(left, right);
        if (textDiffType == null) {
            DiffUtil.$$$reportNull$$$0(157);
        }
        return textDiffType;
    }

    @NotNull
    public static TextDiffType getDiffType(@NotNull DiffFragment fragment) {
        if (fragment == null) {
            DiffUtil.$$$reportNull$$$0(158);
        }
        boolean left = fragment.getEndOffset1() != fragment.getStartOffset1();
        boolean right = fragment.getEndOffset2() != fragment.getStartOffset2();
        TextDiffType textDiffType = DiffUtil.getDiffType(left, right);
        if (textDiffType == null) {
            DiffUtil.$$$reportNull$$$0(159);
        }
        return textDiffType;
    }

    @NotNull
    public static TextDiffType getDiffType(boolean hasDeleted, boolean hasInserted) {
        if (hasDeleted && hasInserted) {
            TextDiffType textDiffType = TextDiffType.MODIFIED;
            if (textDiffType == null) {
                DiffUtil.$$$reportNull$$$0(160);
            }
            return textDiffType;
        }
        if (hasDeleted) {
            TextDiffType textDiffType = TextDiffType.DELETED;
            if (textDiffType == null) {
                DiffUtil.$$$reportNull$$$0(161);
            }
            return textDiffType;
        }
        if (hasInserted) {
            TextDiffType textDiffType = TextDiffType.INSERTED;
            if (textDiffType == null) {
                DiffUtil.$$$reportNull$$$0(162);
            }
            return textDiffType;
        }
        LOG.error("Diff fragment should not be empty");
        TextDiffType textDiffType = TextDiffType.MODIFIED;
        if (textDiffType == null) {
            DiffUtil.$$$reportNull$$$0(163);
        }
        return textDiffType;
    }

    @NotNull
    public static MergeConflictType getMergeType(@NotNull Condition<ThreeSide> emptiness, @NotNull Equality<ThreeSide> equality, @NotNull BooleanGetter conflictResolver) {
        if (emptiness == null) {
            DiffUtil.$$$reportNull$$$0(164);
        }
        if (equality == null) {
            DiffUtil.$$$reportNull$$$0(165);
        }
        if (conflictResolver == null) {
            DiffUtil.$$$reportNull$$$0(166);
        }
        boolean isLeftEmpty = emptiness.value((Object)ThreeSide.LEFT);
        boolean isBaseEmpty = emptiness.value((Object)ThreeSide.BASE);
        boolean isRightEmpty = emptiness.value((Object)ThreeSide.RIGHT);
        assert (!(isLeftEmpty && isBaseEmpty && isRightEmpty));
        if (isBaseEmpty) {
            if (isLeftEmpty) {
                MergeConflictType mergeConflictType = new MergeConflictType(TextDiffType.INSERTED, false, true);
                if (mergeConflictType == null) {
                    DiffUtil.$$$reportNull$$$0(167);
                }
                return mergeConflictType;
            }
            if (isRightEmpty) {
                MergeConflictType mergeConflictType = new MergeConflictType(TextDiffType.INSERTED, true, false);
                if (mergeConflictType == null) {
                    DiffUtil.$$$reportNull$$$0(168);
                }
                return mergeConflictType;
            }
            boolean equalModifications = equality.equals((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            if (equalModifications) {
                MergeConflictType mergeConflictType = new MergeConflictType(TextDiffType.INSERTED, true, true);
                if (mergeConflictType == null) {
                    DiffUtil.$$$reportNull$$$0(169);
                }
                return mergeConflictType;
            }
            MergeConflictType mergeConflictType = new MergeConflictType(TextDiffType.CONFLICT, true, true, false);
            if (mergeConflictType == null) {
                DiffUtil.$$$reportNull$$$0(170);
            }
            return mergeConflictType;
        }
        if (isLeftEmpty && isRightEmpty) {
            MergeConflictType mergeConflictType = new MergeConflictType(TextDiffType.DELETED, true, true);
            if (mergeConflictType == null) {
                DiffUtil.$$$reportNull$$$0(171);
            }
            return mergeConflictType;
        }
        boolean unchangedLeft = equality.equals((Object)ThreeSide.BASE, (Object)ThreeSide.LEFT);
        boolean unchangedRight = equality.equals((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
        assert (!unchangedLeft || !unchangedRight);
        if (unchangedLeft) {
            MergeConflictType mergeConflictType = new MergeConflictType(isRightEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, false, true);
            if (mergeConflictType == null) {
                DiffUtil.$$$reportNull$$$0(172);
            }
            return mergeConflictType;
        }
        if (unchangedRight) {
            MergeConflictType mergeConflictType = new MergeConflictType(isLeftEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, true, false);
            if (mergeConflictType == null) {
                DiffUtil.$$$reportNull$$$0(173);
            }
            return mergeConflictType;
        }
        boolean equalModifications = equality.equals((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
        if (equalModifications) {
            MergeConflictType mergeConflictType = new MergeConflictType(TextDiffType.MODIFIED, true, true);
            if (mergeConflictType == null) {
                DiffUtil.$$$reportNull$$$0(174);
            }
            return mergeConflictType;
        }
        boolean canBeResolved = !isLeftEmpty && !isRightEmpty && conflictResolver.get();
        MergeConflictType mergeConflictType = new MergeConflictType(TextDiffType.CONFLICT, true, true, canBeResolved);
        if (mergeConflictType == null) {
            DiffUtil.$$$reportNull$$$0(175);
        }
        return mergeConflictType;
    }

    @NotNull
    public static MergeConflictType getLineMergeType(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            DiffUtil.$$$reportNull$$$0(176);
        }
        if (sequences == null) {
            DiffUtil.$$$reportNull$$$0(177);
        }
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(178);
        }
        if (policy == null) {
            DiffUtil.$$$reportNull$$$0(179);
        }
        MergeConflictType mergeConflictType = DiffUtil.getMergeType((Condition<ThreeSide>)((Condition)side -> {
            if (fragment == null) {
                DiffUtil.$$$reportNull$$$0(261);
            }
            return DiffUtil.isLineMergeIntervalEmpty(fragment, side);
        }), (Equality<ThreeSide>)((Equality)(side1, side2) -> {
            if (fragment == null) {
                DiffUtil.$$$reportNull$$$0(257);
            }
            if (sequences == null) {
                DiffUtil.$$$reportNull$$$0(258);
            }
            if (lineOffsets == null) {
                DiffUtil.$$$reportNull$$$0(259);
            }
            if (policy == null) {
                DiffUtil.$$$reportNull$$$0(260);
            }
            return DiffUtil.compareLineMergeContents(fragment, sequences, lineOffsets, policy, side1, side2);
        }), () -> {
            if (fragment == null) {
                DiffUtil.$$$reportNull$$$0(254);
            }
            if (sequences == null) {
                DiffUtil.$$$reportNull$$$0(255);
            }
            if (lineOffsets == null) {
                DiffUtil.$$$reportNull$$$0(256);
            }
            return DiffUtil.canResolveLineConflict(fragment, sequences, lineOffsets);
        });
        if (mergeConflictType == null) {
            DiffUtil.$$$reportNull$$$0(180);
        }
        return mergeConflictType;
    }

    private static boolean canResolveLineConflict(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<LineOffsets> lineOffsets) {
        List contents;
        if (fragment == null) {
            DiffUtil.$$$reportNull$$$0(181);
        }
        if (sequences == null) {
            DiffUtil.$$$reportNull$$$0(182);
        }
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(183);
        }
        return ComparisonMergeUtil.tryResolveConflict((CharSequence)(contents = ThreeSide.map(side -> {
            if (sequences == null) {
                DiffUtil.$$$reportNull$$$0(251);
            }
            if (lineOffsets == null) {
                DiffUtil.$$$reportNull$$$0(252);
            }
            if (fragment == null) {
                DiffUtil.$$$reportNull$$$0(253);
            }
            return DiffUtil.getLinesContent((CharSequence)side.select(sequences), (LineOffsets)side.select(lineOffsets), fragment.getStartLine(side), fragment.getEndLine(side));
        })).get(0), (CharSequence)contents.get(1), (CharSequence)contents.get(2)) != null;
    }

    private static boolean compareLineMergeContents(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        if (fragment == null) {
            DiffUtil.$$$reportNull$$$0(184);
        }
        if (sequences == null) {
            DiffUtil.$$$reportNull$$$0(185);
        }
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(186);
        }
        if (policy == null) {
            DiffUtil.$$$reportNull$$$0(187);
        }
        if (side1 == null) {
            DiffUtil.$$$reportNull$$$0(188);
        }
        if (side2 == null) {
            DiffUtil.$$$reportNull$$$0(189);
        }
        int start1 = fragment.getStartLine(side1);
        int end1 = fragment.getEndLine(side1);
        int start2 = fragment.getStartLine(side2);
        int end2 = fragment.getEndLine(side2);
        if (end2 - start2 != end1 - start1) {
            return false;
        }
        CharSequence sequence1 = (CharSequence)side1.select(sequences);
        CharSequence sequence2 = (CharSequence)side2.select(sequences);
        LineOffsets offsets1 = (LineOffsets)side1.select(lineOffsets);
        LineOffsets offsets2 = (LineOffsets)side2.select(lineOffsets);
        for (int i = 0; i < end1 - start1; ++i) {
            CharSequence content2;
            int line1 = start1 + i;
            int line2 = start2 + i;
            CharSequence content1 = DiffUtil.getLinesContent(sequence1, offsets1, line1, line1 + 1);
            if (ComparisonUtil.isEquals(content1, content2 = DiffUtil.getLinesContent(sequence2, offsets2, line2, line2 + 1), policy)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLineMergeIntervalEmpty(@NotNull MergeLineFragment fragment, @NotNull ThreeSide side) {
        if (fragment == null) {
            DiffUtil.$$$reportNull$$$0(190);
        }
        if (side == null) {
            DiffUtil.$$$reportNull$$$0(191);
        }
        return fragment.getStartLine(side) == fragment.getEndLine(side);
    }

    @NotNull
    public static MergeConflictType getWordMergeType(@NotNull MergeWordFragment fragment, @NotNull List<? extends CharSequence> texts, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            DiffUtil.$$$reportNull$$$0(192);
        }
        if (texts == null) {
            DiffUtil.$$$reportNull$$$0(193);
        }
        if (policy == null) {
            DiffUtil.$$$reportNull$$$0(194);
        }
        MergeConflictType mergeConflictType = DiffUtil.getMergeType((Condition<ThreeSide>)((Condition)side -> {
            if (fragment == null) {
                DiffUtil.$$$reportNull$$$0(250);
            }
            return DiffUtil.isWordMergeIntervalEmpty(fragment, side);
        }), (Equality<ThreeSide>)((Equality)(side1, side2) -> {
            if (fragment == null) {
                DiffUtil.$$$reportNull$$$0(247);
            }
            if (texts == null) {
                DiffUtil.$$$reportNull$$$0(248);
            }
            if (policy == null) {
                DiffUtil.$$$reportNull$$$0(249);
            }
            return DiffUtil.compareWordMergeContents(fragment, texts, policy, side1, side2);
        }), BooleanGetter.FALSE);
        if (mergeConflictType == null) {
            DiffUtil.$$$reportNull$$$0(195);
        }
        return mergeConflictType;
    }

    public static boolean compareWordMergeContents(@NotNull MergeWordFragment fragment, @NotNull List<? extends CharSequence> texts, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        if (fragment == null) {
            DiffUtil.$$$reportNull$$$0(196);
        }
        if (texts == null) {
            DiffUtil.$$$reportNull$$$0(197);
        }
        if (policy == null) {
            DiffUtil.$$$reportNull$$$0(198);
        }
        if (side1 == null) {
            DiffUtil.$$$reportNull$$$0(199);
        }
        if (side2 == null) {
            DiffUtil.$$$reportNull$$$0(200);
        }
        int start1 = fragment.getStartOffset(side1);
        int end1 = fragment.getEndOffset(side1);
        int start2 = fragment.getStartOffset(side2);
        int end2 = fragment.getEndOffset(side2);
        CharSequence document1 = (CharSequence)side1.select(texts);
        CharSequence document2 = (CharSequence)side2.select(texts);
        CharSequence content1 = document1.subSequence(start1, end1);
        CharSequence content2 = document2.subSequence(start2, end2);
        return ComparisonUtil.isEquals(content1, content2, policy);
    }

    private static boolean isWordMergeIntervalEmpty(@NotNull MergeWordFragment fragment, @NotNull ThreeSide side) {
        if (fragment == null) {
            DiffUtil.$$$reportNull$$$0(201);
        }
        if (side == null) {
            DiffUtil.$$$reportNull$$$0(202);
        }
        return fragment.getStartOffset(side) == fragment.getEndOffset(side);
    }

    public static boolean executeWriteCommand(@Nullable Project project, @NotNull Document document, @Nullable String commandName, @Nullable String commandGroupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean underBulkUpdate, @NotNull Runnable task2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(203);
        }
        if (confirmationPolicy == null) {
            DiffUtil.$$$reportNull$$$0(204);
        }
        if (task2 == null) {
            DiffUtil.$$$reportNull$$$0(205);
        }
        if (!DiffUtil.makeWritable(project, document)) {
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
            LOG.warn("Document is read-only" + (file2 != null ? ": " + file2.getPresentableName() : ""));
            return false;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (document == null) {
                DiffUtil.$$$reportNull$$$0(242);
            }
            if (task2 == null) {
                DiffUtil.$$$reportNull$$$0(243);
            }
            if (confirmationPolicy == null) {
                DiffUtil.$$$reportNull$$$0(244);
            }
            CommandProcessor.getInstance().executeCommand(project, () -> {
                if (document == null) {
                    DiffUtil.$$$reportNull$$$0(245);
                }
                if (task2 == null) {
                    DiffUtil.$$$reportNull$$$0(246);
                }
                if (underBulkUpdate) {
                    DocumentUtil.executeInBulk(document, true, task2);
                } else {
                    task2.run();
                }
            }, commandName, (Object)commandGroupId, confirmationPolicy, document);
        });
        return true;
    }

    public static boolean executeWriteCommand(@NotNull Document document, @Nullable Project project, @Nullable String commandName, @NotNull Runnable task2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(206);
        }
        if (task2 == null) {
            DiffUtil.$$$reportNull$$$0(207);
        }
        return DiffUtil.executeWriteCommand(project, document, commandName, null, UndoConfirmationPolicy.DEFAULT, false, task2);
    }

    public static boolean isEditable(@NotNull Editor editor) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(208);
        }
        return !editor.isViewer() && DiffUtil.canMakeWritable(editor.getDocument());
    }

    public static boolean canMakeWritable(@NotNull Document document) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(209);
        }
        if (document.isWritable()) {
            return true;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && file2.isValid() && file2.isInLocalFileSystem()) {
            if (file2.getUserData(TEMP_FILE_KEY) == Boolean.TRUE) {
                return false;
            }
            return !file2.isWritable();
        }
        return false;
    }

    public static boolean makeWritable(@Nullable Project project, @NotNull Document document) {
        VirtualFile file2;
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(210);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document)) == null) {
            return document.isWritable();
        }
        if (!file2.isValid()) {
            return false;
        }
        return DiffUtil.makeWritable(project, file2) && document.isWritable();
    }

    public static boolean makeWritable(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffUtil.$$$reportNull$$$0(211);
        }
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        return !ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{file2}).hasReadonlyFiles();
    }

    public static void putNonundoableOperation(@Nullable Project project, @NotNull Document document) {
        UndoManager undoManager;
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(212);
        }
        UndoManager undoManager2 = undoManager = project != null ? UndoManager.getInstance((Project)project) : UndoManager.getGlobalInstance();
        if (undoManager != null) {
            DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
            undoManager.nonundoableActionPerformed(ref, false);
        }
    }

    public static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, VirtualFile ... files2) {
        if (files2 == null) {
            DiffUtil.$$$reportNull$$$0(213);
        }
        ModalityState modalityState = ApplicationManager.getApplication().getDefaultModalityState();
        VfsUtil.markDirty((boolean)recursive, (boolean)reloadChildren, (VirtualFile[])files2);
        RefreshQueue.getInstance().refresh(async, recursive, null, modalityState, files2);
    }

    @NotNull
    public static Dimension getDefaultDiffPanelSize() {
        Dimension dimension = new Dimension(400, 200);
        if (dimension == null) {
            DiffUtil.$$$reportNull$$$0(214);
        }
        return dimension;
    }

    @NotNull
    public static Dimension getDefaultDiffWindowSize() {
        Rectangle screenBounds = ScreenUtil.getMainScreenBounds();
        int width = (int)((double)screenBounds.width * 0.8);
        int height = (int)((double)screenBounds.height * 0.8);
        Dimension dimension = new Dimension(width, height);
        if (dimension == null) {
            DiffUtil.$$$reportNull$$$0(215);
        }
        return dimension;
    }

    @NotNull
    public static WindowWrapper.Mode getWindowMode(@NotNull DiffDialogHints hints) {
        WindowWrapper.Mode mode;
        if (hints == null) {
            DiffUtil.$$$reportNull$$$0(216);
        }
        if ((mode = hints.getMode()) == null) {
            boolean isUnderDialog = LaterInvocator.isInModalContext();
            mode = isUnderDialog ? WindowWrapper.Mode.MODAL : WindowWrapper.Mode.FRAME;
        }
        WindowWrapper.Mode mode2 = mode;
        if (mode2 == null) {
            DiffUtil.$$$reportNull$$$0(217);
        }
        return mode2;
    }

    public static void closeWindow(@Nullable Window window, boolean modalOnly, boolean recursive) {
        boolean isClosed;
        if (window == null) {
            return;
        }
        Container component = window;
        while (component != null && (!(component instanceof Window) || (isClosed = DiffUtil.closeWindow(component, modalOnly)))) {
            component = recursive ? component.getParent() : null;
        }
    }

    private static boolean closeWindow(@NotNull Window window, boolean modalOnly) {
        if (window == null) {
            DiffUtil.$$$reportNull$$$0(218);
        }
        if (window instanceof IdeFrameImpl) {
            return false;
        }
        if (modalOnly && window instanceof Frame) {
            return false;
        }
        if (window instanceof DialogWrapperDialog) {
            ((DialogWrapperDialog)window).getDialogWrapper().doCancelAction();
            return !window.isVisible();
        }
        window.setVisible(false);
        window.dispose();
        return true;
    }

    public static <T> UserDataHolderBase createUserDataHolder(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            DiffUtil.$$$reportNull$$$0(219);
        }
        UserDataHolderBase holder = new UserDataHolderBase();
        holder.putUserData(key, value);
        return holder;
    }

    public static boolean isUserDataFlagSet(@NotNull Key<Boolean> key, UserDataHolder ... holders) {
        if (key == null) {
            DiffUtil.$$$reportNull$$$0(220);
        }
        for (UserDataHolder holder : holders) {
            Boolean data;
            if (holder == null || (data = (Boolean)holder.getUserData(key)) == null) continue;
            return data;
        }
        return false;
    }

    public static <T> T getUserData(@Nullable UserDataHolder first, @Nullable UserDataHolder second, @NotNull Key<T> key) {
        Object data;
        if (key == null) {
            DiffUtil.$$$reportNull$$$0(221);
        }
        if (first != null && (data = first.getUserData(key)) != null) {
            return (T)data;
        }
        if (second != null && (data = second.getUserData(key)) != null) {
            return (T)data;
        }
        return null;
    }

    public static void addNotification(@Nullable JComponent component, @NotNull UserDataHolder holder) {
        if (holder == null) {
            DiffUtil.$$$reportNull$$$0(222);
        }
        if (component == null) {
            return;
        }
        List oldComponents = ContainerUtil.notNullize((List)((List)holder.getUserData(DiffUserDataKeys.NOTIFICATIONS)));
        holder.putUserData(DiffUserDataKeys.NOTIFICATIONS, (Object)ContainerUtil.append((List)oldComponents, (Object[])new JComponent[]{component}));
    }

    @NotNull
    public static List<JComponent> getCustomNotifications(@NotNull UserDataHolder context, @NotNull UserDataHolder request) {
        if (context == null) {
            DiffUtil.$$$reportNull$$$0(223);
        }
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(224);
        }
        List requestComponents = (List)request.getUserData(DiffUserDataKeys.NOTIFICATIONS);
        List contextComponents = (List)context.getUserData(DiffUserDataKeys.NOTIFICATIONS);
        List list2 = ContainerUtil.concat((List)ContainerUtil.notNullize((List)contextComponents), (List)ContainerUtil.notNullize((List)requestComponents));
        if (list2 == null) {
            DiffUtil.$$$reportNull$$$0(225);
        }
        return list2;
    }

    @NotNull
    public static List<JComponent> getCustomNotifications(@NotNull DiffContent content) {
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(226);
        }
        List list2 = ContainerUtil.notNullize((List)((List)content.getUserData(DiffUserDataKeys.NOTIFICATIONS)));
        if (list2 == null) {
            DiffUtil.$$$reportNull$$$0(227);
        }
        return list2;
    }

    @Nullable
    public static Object getData(@Nullable DataProvider provider, @Nullable DataProvider fallbackProvider, @NonNls String dataId) {
        Object data;
        if (provider != null && (data = provider.getData(dataId)) != null) {
            return data;
        }
        if (fallbackProvider != null && (data = fallbackProvider.getData(dataId)) != null) {
            return data;
        }
        return null;
    }

    public static <T> void putDataKey(@NotNull UserDataHolder holder, @NotNull DataKey<T> key, @Nullable T value) {
        DataProvider dataProvider;
        if (holder == null) {
            DiffUtil.$$$reportNull$$$0(228);
        }
        if (key == null) {
            DiffUtil.$$$reportNull$$$0(229);
        }
        if (!((dataProvider = (DataProvider)holder.getUserData(DiffUserDataKeys.DATA_PROVIDER)) instanceof GenericDataProvider)) {
            dataProvider = new GenericDataProvider(dataProvider);
            holder.putUserData(DiffUserDataKeys.DATA_PROVIDER, (Object)dataProvider);
        }
        ((GenericDataProvider)dataProvider).putData(key, value);
    }

    @NotNull
    public static DiffSettingsHolder.DiffSettings getDiffSettings(@NotNull DiffContext context) {
        DiffSettingsHolder.DiffSettings settings;
        if (context == null) {
            DiffUtil.$$$reportNull$$$0(230);
        }
        if ((settings = (DiffSettingsHolder.DiffSettings)context.getUserData(DiffSettingsHolder.DiffSettings.KEY)) == null) {
            settings = DiffSettingsHolder.DiffSettings.getSettings((String)context.getUserData(DiffUserDataKeys.PLACE));
            context.putUserData(DiffSettingsHolder.DiffSettings.KEY, (Object)settings);
        }
        DiffSettingsHolder.DiffSettings diffSettings = settings;
        if (diffSettings == null) {
            DiffUtil.$$$reportNull$$$0(231);
        }
        return diffSettings;
    }

    @NotNull
    public static <K, V> TreeMap<K, V> trimDefaultValues(@NotNull TreeMap<K, V> map2, @NotNull Convertor<K, V> defaultValue) {
        if (map2 == null) {
            DiffUtil.$$$reportNull$$$0(232);
        }
        if (defaultValue == null) {
            DiffUtil.$$$reportNull$$$0(233);
        }
        TreeMap<K, V> result2 = new TreeMap<K, V>();
        for (Map.Entry<K, V> it : map2.entrySet()) {
            K key = it.getKey();
            V value = it.getValue();
            if (value.equals(defaultValue.convert(key))) continue;
            result2.put(key, value);
        }
        TreeMap<K, V> treeMap = result2;
        if (treeMap == null) {
            DiffUtil.$$$reportNull$$$0(234);
        }
        return treeMap;
    }

    @NotNull
    public static <T extends DiffTool> List<T> filterSuppressedTools(@NotNull List<T> tools) {
        if (tools == null) {
            DiffUtil.$$$reportNull$$$0(235);
        }
        if (tools.size() < 2) {
            List list2 = tools;
            if (list2 == null) {
                DiffUtil.$$$reportNull$$$0(236);
            }
            return list2;
        }
        ArrayList suppressedTools = new ArrayList();
        for (DiffTool tool2 : tools) {
            try {
                if (!(tool2 instanceof SuppressiveDiffTool)) continue;
                suppressedTools.addAll(((SuppressiveDiffTool)tool2).getSuppressedTools());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (suppressedTools.isEmpty()) {
            List list3 = tools;
            if (list3 == null) {
                DiffUtil.$$$reportNull$$$0(237);
            }
            return list3;
        }
        List filteredTools = ContainerUtil.filter(tools, tool -> !suppressedTools.contains(tool.getClass()));
        List list4 = filteredTools.isEmpty() ? tools : filteredTools;
        if (list4 == null) {
            DiffUtil.$$$reportNull$$$0(238);
        }
        return list4;
    }

    @Nullable
    public static DiffTool findToolSubstitutor(@NotNull DiffTool tool, @NotNull DiffContext context, @NotNull DiffRequest request) {
        if (tool == null) {
            DiffUtil.$$$reportNull$$$0(239);
        }
        if (context == null) {
            DiffUtil.$$$reportNull$$$0(240);
        }
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(241);
        }
        for (DiffToolSubstitutor substitutor : (DiffToolSubstitutor[])DiffToolSubstitutor.EP_NAME.getExtensions()) {
            DiffTool replacement = substitutor.getReplacement(tool, context, request);
            if (replacement == null) continue;
            boolean canShow = replacement.canShow(context, request);
            if (!canShow) {
                LOG.error("DiffTool substitutor returns invalid tool");
                continue;
            }
            return replacement;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 148: 
            case 156: 
            case 158: 
            case 164: 
            case 165: 
            case 166: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 233: 
            case 235: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 148: 
            case 156: 
            case 158: 
            case 164: 
            case 165: 
            case 166: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 233: 
            case 235: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffUtil";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 27: 
            case 32: 
            case 99: 
            case 102: 
            case 208: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 17: 
            case 22: 
            case 24: 
            case 26: 
            case 58: 
            case 60: 
            case 226: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: 
            case 4: 
            case 44: 
            case 46: 
            case 108: 
            case 110: 
            case 115: 
            case 140: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: 
            case 14: 
            case 106: 
            case 107: 
            case 109: 
            case 111: 
            case 120: 
            case 122: 
            case 130: 
            case 131: 
            case 136: 
            case 137: 
            case 138: 
            case 142: 
            case 203: 
            case 206: 
            case 209: 
            case 210: 
            case 212: 
            case 242: 
            case 245: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingSupport";
                break;
            }
            case 28: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 39: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 50: 
            case 79: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 51: 
            case 54: 
            case 76: 
            case 83: 
            case 224: 
            case 241: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 59: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 74: 
            case 223: 
            case 230: 
            case 240: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 75: 
            case 205: 
            case 207: 
            case 243: 
            case 246: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 77: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 78: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rediff";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparisonPolicy";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 94: 
            case 262: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 95: 
            case 263: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexes";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLines";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document1";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document2";
                break;
            }
            case 116: 
            case 125: 
            case 128: 
            case 133: 
            case 178: 
            case 183: 
            case 186: 
            case 252: 
            case 256: 
            case 259: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherText";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherLineOffsets";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 124: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 146: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 156: 
            case 158: 
            case 176: 
            case 181: 
            case 184: 
            case 190: 
            case 192: 
            case 196: 
            case 201: 
            case 247: 
            case 250: 
            case 253: 
            case 254: 
            case 257: 
            case 261: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptiness";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictResolver";
                break;
            }
            case 177: 
            case 182: 
            case 185: 
            case 251: 
            case 255: 
            case 258: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequences";
                break;
            }
            case 179: 
            case 187: 
            case 194: 
            case 198: 
            case 249: 
            case 260: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 188: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side1";
                break;
            }
            case 189: 
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side2";
                break;
            }
            case 191: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 193: 
            case 197: 
            case 248: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 204: 
            case 244: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmationPolicy";
                break;
            }
            case 211: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 213: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 216: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 218: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 219: 
            case 220: 
            case 221: 
            case 229: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 222: 
            case 228: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 232: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 233: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 235: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 239: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDiffFrameImages";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 148: 
            case 156: 
            case 158: 
            case 164: 
            case 165: 
            case 166: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 233: 
            case 235: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "initEmptyEditorHighlighter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyEditorHighlighter";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollingPosition";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretPosition";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrowIcon";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrowDownIcon";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessagePanel";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsConfigurablePath";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltipText";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotificationText";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleTitles";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextTitles";
                break;
            }
            case 62: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitle";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "createCharsetPanel";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "createSeparatorPanel";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "createSyncHeightComponents";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "createStackedComponents";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextDiffProvider";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "createNoIgnoreTextDiffProvider";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedIndexes";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "invertIndexes";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLines";
                break;
            }
            case 121: 
            case 123: 
            case 126: 
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinesContent";
                break;
            }
            case 132: 
            case 134: 
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinesRange";
                break;
            }
            case 139: 
            case 141: 
            case 143: 
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedLineRange";
                break;
            }
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                objectArray = objectArray2;
                objectArray2[1] = "updateRangeOnModification";
                break;
            }
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineDiffType";
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffType";
                break;
            }
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeType";
                break;
            }
            case 180: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineMergeType";
                break;
            }
            case 195: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordMergeType";
                break;
            }
            case 214: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDiffPanelSize";
                break;
            }
            case 215: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDiffWindowSize";
                break;
            }
            case 217: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowMode";
                break;
            }
            case 225: 
            case 227: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomNotifications";
                break;
            }
            case 231: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffSettings";
                break;
            }
            case 234: {
                objectArray = objectArray2;
                objectArray2[1] = "trimDefaultValues";
                break;
            }
            case 236: 
            case 237: 
            case 238: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSuppressedTools";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDiffEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initEditorHighlighter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initEmptyEditorHighlighter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEditorHighlighter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setEditorHighlighter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setEditorCodeStyle";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setFoldingModelSupport";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "configureEditor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isMirrored";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "installLineConvertor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getContentLineConvertor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "disableBlitting";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "scrollToPoint";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToLineRangeIfNeeded";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getArrowIcon";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getArrowDownIcon";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "registerAction";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createMessagePanel";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addActionBlock";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createTooltipText";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationText";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "showSuccessPopup";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleTitles";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createTextTitles";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createTitleWithNotifications";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createTitle";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createCharsetPanel";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createSeparatorPanel";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createSyncHeightComponents";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createStackedComponents";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "runPreservingFocus";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "createTextDiffProvider";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "createNoIgnoreTextDiffProvider";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "compareThreesideInner";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "isChunksEquals";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getSortedIndexes";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "invertIndexes";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedLines";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "appendSelectedLines";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedByLine";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "deleteLines";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "insertLines";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "replaceLines";
                break;
            }
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "applyModification";
                break;
            }
            case 120: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "getLinesContent";
                break;
            }
            case 130: 
            case 131: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "getLinesRange";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "getOffset";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "getLineCount";
                break;
            }
            case 138: 
            case 140: 
            case 142: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "getLines";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedLineRange";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "countLinesShift";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "getLineDiffType";
                break;
            }
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "getDiffType";
                break;
            }
            case 164: 
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "getMergeType";
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "getLineMergeType";
                break;
            }
            case 181: 
            case 182: 
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "canResolveLineConflict";
                break;
            }
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "compareLineMergeContents";
                break;
            }
            case 190: 
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "isLineMergeIntervalEmpty";
                break;
            }
            case 192: 
            case 193: 
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "getWordMergeType";
                break;
            }
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "compareWordMergeContents";
                break;
            }
            case 201: 
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "isWordMergeIntervalEmpty";
                break;
            }
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "executeWriteCommand";
                break;
            }
            case 208: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "canMakeWritable";
                break;
            }
            case 210: 
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "makeWritable";
                break;
            }
            case 212: {
                objectArray = objectArray;
                objectArray[2] = "putNonundoableOperation";
                break;
            }
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "markDirtyAndRefresh";
                break;
            }
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "getWindowMode";
                break;
            }
            case 218: {
                objectArray = objectArray;
                objectArray[2] = "closeWindow";
                break;
            }
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "createUserDataHolder";
                break;
            }
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "isUserDataFlagSet";
                break;
            }
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 222: {
                objectArray = objectArray;
                objectArray[2] = "addNotification";
                break;
            }
            case 223: 
            case 224: 
            case 226: {
                objectArray = objectArray;
                objectArray[2] = "getCustomNotifications";
                break;
            }
            case 228: 
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "putDataKey";
                break;
            }
            case 230: {
                objectArray = objectArray;
                objectArray[2] = "getDiffSettings";
                break;
            }
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "trimDefaultValues";
                break;
            }
            case 235: {
                objectArray = objectArray;
                objectArray[2] = "filterSuppressedTools";
                break;
            }
            case 239: 
            case 240: 
            case 241: {
                objectArray = objectArray;
                objectArray[2] = "findToolSubstitutor";
                break;
            }
            case 242: 
            case 243: 
            case 244: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeWriteCommand$12";
                break;
            }
            case 245: 
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$11";
                break;
            }
            case 247: 
            case 248: 
            case 249: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getWordMergeType$10";
                break;
            }
            case 250: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getWordMergeType$9";
                break;
            }
            case 251: 
            case 252: 
            case 253: {
                objectArray = objectArray;
                objectArray[2] = "lambda$canResolveLineConflict$8";
                break;
            }
            case 254: 
            case 255: 
            case 256: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLineMergeType$7";
                break;
            }
            case 257: 
            case 258: 
            case 259: 
            case 260: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLineMergeType$6";
                break;
            }
            case 261: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLineMergeType$5";
                break;
            }
            case 262: 
            case 263: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSortedIndexes$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 148: 
            case 156: 
            case 158: 
            case 164: 
            case 165: 
            case 166: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 233: 
            case 235: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CenteredPanel
    extends JPanel {
        private final JComponent myComponent;

        public CenteredPanel(@NotNull JComponent component) {
            if (component == null) {
                CenteredPanel.$$$reportNull$$$0(0);
            }
            this.myComponent = component;
            this.add(component);
        }

        public CenteredPanel(@NotNull JComponent component, @NotNull Border border) {
            if (component == null) {
                CenteredPanel.$$$reportNull$$$0(1);
            }
            if (border == null) {
                CenteredPanel.$$$reportNull$$$0(2);
            }
            this(component);
            this.setBorder(border);
        }

        @Override
        public void doLayout() {
            Dimension size = this.getSize();
            Dimension preferredSize = this.myComponent.getPreferredSize();
            Insets insets = this.getInsets();
            JBInsets.removeFrom((Dimension)size, (Insets)insets);
            int width = Math.min(size.width, preferredSize.width);
            int height = Math.min(size.height, preferredSize.height);
            int x = Math.max(0, (size.width - preferredSize.width) / 2);
            int y = Math.max(0, (size.height - preferredSize.height) / 2);
            this.myComponent.setBounds(insets.left + x, insets.top + y, width, height);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.addInsets(this.myComponent.getPreferredSize());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.addInsets(this.myComponent.getMinimumSize());
        }

        @Override
        public Dimension getMaximumSize() {
            return this.addInsets(this.myComponent.getMaximumSize());
        }

        private Dimension addInsets(Dimension dimension) {
            JBInsets.addTo((Dimension)dimension, (Insets)this.getInsets());
            return dimension;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "border";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/util/DiffUtil$CenteredPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SyncHeightComponent
    extends JPanel {
        @NotNull
        private final List<JComponent> myComponents;

        public SyncHeightComponent(@NotNull List<JComponent> components, int index) {
            if (components == null) {
                SyncHeightComponent.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.myComponents = components;
            JComponent delegate = components.get(index);
            if (delegate != null) {
                this.add((Component)delegate, "Center");
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = this.getPreferredHeight();
            return size;
        }

        private int getPreferredHeight() {
            int height = 0;
            for (JComponent component : this.myComponents) {
                if (component == null) continue;
                height = Math.max(height, component.getPreferredSize().height);
            }
            return height;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/diff/util/DiffUtil$SyncHeightComponent", "<init>"));
        }
    }

    public static class UpdatedLineRange {
        public final int startLine;
        public final int endLine;
        public final boolean damaged;

        public UpdatedLineRange(int startLine, int endLine, boolean damaged) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.damaged = damaged;
        }
    }
}

